var Snog = window.Snog || {};
Snog.Forms = Snog.Forms || {};
Snog.$ = Snog.$ || window.jQuery || null;

;((window, document) =>
{
	"use strict";
	var $ = Snog.$;

	Snog.Forms.PriceInput = XF.Element.newHandler({
		container: null,

		options: {
			container: '.js-formPriceInputContainer',
			price: 0
		},

		init: function ()
		{
			const target = this.target || this.$target.get(0);
			this.container = document.querySelector(this.options.container);

			if (this.container)
			{
				this.container.value = target.value * this.options.price;

				if (typeof XF.on === 'function')
				{
					XF.on(target, 'change', this.change.bind(this));
				}
				else
				{
					$(target).on('change', this.change.bind(this));
				}
			}
		},

		change: function (e)
		{
			this.container.value = e.target.value * this.options.price;

			if (typeof XF.on === 'function')
			{
				XF.trigger(this.container, 'change')
			}
			else
			{
				$(this.container).trigger('input')
			}
		}
	});

	Snog.Forms.PriceTotal = XF.Element.newHandler({
		container: null,
		inputs: [],
		total: 0,

		options: {
			container: '.js-formPriceInputContainer',
			questionIds: []
		},

		init: function ()
		{
			let target = this.target || this.$target.get(0);

			this.container = target.querySelector('.js-formBillableRowTotal');
			this.inputs = [];

			if (this.options.questionIds)
			{
				this.options.questionIds.forEach((id) => {
					let container = document.querySelector(this.options.container + id);
					if (container)
					{
						this.inputs.push(container);
						if (typeof XF.on === 'function')
						{
							XF.on(container, 'change', this.change.bind(this));
						}
						else
						{
							$(container).on('input', XF.proxy(this, 'change'));
						}

						this.change(null);
					}
				});
			}
		},

		change: function (e)
		{
			this.total = this.getTotal();
			this.container.textContent = this.total;
		},

		getTotal: function ()
		{
			let total = 0;
			this.inputs.forEach((input) => {
				total = total + Number(input.value);
			});

			return total;
		}
	});

	XF.Element.register('snog-forms-price-input', 'Snog.Forms.PriceInput');
	XF.Element.register('snog-forms-price-total', 'Snog.Forms.PriceTotal');
})(window, document)