<?php

namespace Snog\Forms\Admin\Controller;

use Snog\Forms\Mvc\Controller\LogListTrait;
use XF\Mvc\ParameterBag;

class Logs extends \XF\Admin\Controller\AbstractController
{
	use LogListTrait;

	protected function preDispatchController($action, ParameterBag $params)
	{
		$this->assertAdminPermission('viewLogs');
	}

	protected function getFormLogClassIdentifier()
	{
		return 'Snog\Forms:Logs';
	}

	protected function getFormLogLinkType()
	{
		return 'admin';
	}

	protected function getFormLogLinkPrefix()
	{
		return 'logs/forms-logs';
	}

	protected function getFormLogTemplatePrefix()
	{
		return 'snog_forms_log';
	}

	public function actionDelete(ParameterBag $params)
	{
		$entry = $this->assertFormsLogExists($params->log_id);

		/** @var \XF\ControllerPlugin\Delete $plugin */
		$plugin = $this->plugin('XF:Delete');
		return $plugin->actionDelete(
			$entry,
			$this->buildLink('logs/forms-logs/delete', $entry),
			$this->buildLink('logs/forms-logs', $entry),
			$this->buildLink('logs/forms-logs'),
			\XF::phrase('snog_forms_log_by_x_from_x', [
				'log_id' => $entry->log_id,
				'username' => $entry->User ? $entry->User->username : \XF\Util\Ip::convertIpBinaryToString($entry->ip_address),
				'time' => \XF::language()->dateTime($entry->log_date)
			])
		);
	}

	public function actionClear()
	{
		if ($this->isPost())
		{
			if ($this->filter('clear_answers', 'bool'))
			{
				/** @var \Snog\Forms\Repository\Answer $answerRepo */
				$answerRepo = $this->repository('Snog\Forms:Answer');
				$answerRepo->clearAnswers();
			}
			$this->getFormsLogRepo()->clearLog();
			return $this->redirect($this->buildLink('logs/forms-logs/'));
		}
		else
		{
			return $this->view('XF:Log\FormsLogs\Clear', 'snog_forms_log_clear');
		}
	}
}