<?php

namespace Snog\Forms\Cron;

/**
 * Cron entry for poll results.
 */
class Pollresults
{
	/**
	 * Processes poll results for promotions.
	 */
	public static function processResults()
	{
		$app = \XF::app();

		/** @var \Snog\Forms\Entity\Promotion[] $promotionValues */
		$promotionValues = $app->finder('Snog\Forms:Promotion')
			->with(['Form', 'Form.ConversationUser', 'Thread', 'Post', 'closedPoll', 'User'])
			->where('poll_id', '>', 0)
			->where('close_date', '<=', time() - 5)
			->fetch();

		foreach ($promotionValues as $promotion)
		{
			// ONLY PROCESS PROMOTION POLLS
			$form = $promotion->Form;
			if (isset($form->postpoll) && $form->postpoll)
			{
				if (isset($promotion->closedPoll->responses))
				{
					$results = $promotion->closedPoll->responses;
					$yesCount = 0;
					$noCount = 0;
					foreach ($results as $result)
					{
						if ($result['response'] == \XF::phrase('yes')) $yesCount = $result['response_vote_count'];
						if ($result['response'] == \XF::phrase('no')) $noCount = $result['response_vote_count'];
					}

					if ($yesCount > $noCount)
					{
						/** @var \Snog\Forms\Service\Promotion\Approve $approver */
						$approver = $app->service('Snog\Forms:Promotion\Approve', $promotion);
						$approver->setApprovedBy(\XF::phrase('poll_results'));
						$approver->approve();
					}

					if ($noCount > $yesCount)
					{
						/** @var \Snog\Forms\Service\Promotion\Deny $denier */
						$denier = $app->service('Snog\Forms:Promotion\Deny', $promotion);
						$denier->setDeniedBy(\XF::phrase('poll_results'));
						$denier->deny();
					}

					if ($yesCount == $noCount)
					{
						$router = $app->router('public');
						$link = $router->buildLink('full:threads', $promotion->Thread);
						$poll = $promotion->Thread->title;
						$title = \XF::phrase('snog_forms_tie_title');

						// SEND TIE PC

						$sender = $form->ConversationUser;
						if ($sender)
						{
							$message = \XF::phrase('snog_forms_x_result_tie', ['link' => $link, 'poll' => $poll]);
							self::sendPC($title, $message, $sender, $form->pmerror, $form->pmdelete, true);
						}

						// ADD DECISION LINKS TO POST IF NOT ALREADY THERE
						$promotion->approve = true;

						// REMOVE POLL INFO TO PREVENT SPAMMING OF PC IN BOX
						$promotion->poll_id = 0;
						$promotion->close_date = 0;

						$promotion->saveIfChanged($saved, false, false);
					}
				}
				else
				{
					$router = $app->router('public');
					$link = $router->buildLink('full:threads', $promotion->Thread);
					$poll = $promotion->Thread->title;
					$title = \XF::phrase('snog_forms_cron_error_title');

					// SEND ERROR PC

					$sender = $form->ConversationUser;
					if ($sender)
					{
						$message = \XF::phrase('snog_forms_cron_error', ['link' => $link, 'poll' => $poll]);
						self::sendPC($title, $message, $sender, $form->pmerror, $form->pmdelete, true);
					}

					// ADD DECISION LINKS TO POST IF NOT ALREADY THERE
					$promotion->approve = true;

					// REMOVE POLL INFO TO PREVENT SPAMMING OF PC IN BOX
					$promotion->poll_id = 0;
					$promotion->close_date = 0;

					$promotion->saveIfChanged($saved, false, false);
				}
			}
		}
	}

	protected static function sendPC($title, $message, $sender, $receiver, $close = true, $parse = false)
	{
		$app = \XF::app();
		$options['open_invite'] = false;
		$options['conversation_open'] = !$close;

		/** @var \XF\Service\Conversation\Creator $creator */
		$creator = $app->service('XF:Conversation\Creator', $sender);
		$creator->setOptions($options);
		$creator->setRecipients($receiver, false, false);
		$creator->setContent($title, $message, (bool) $parse);
		$creator->setIsAutomated();
		$creator->save();

		$conversation = $creator->getConversation();

		// DELETE PC FROM SENDER'S INBOX
		if ($close)
		{
			/** @var \XF\Finder\ConversationUser $finder */
			$finder = $app->finder('XF:ConversationUser');

			/** @var \XF\Entity\ConversationUser $userConv */
			$userConv = $finder->forUser($sender, false)
				->where('conversation_id', $conversation->conversation_id)
				->fetchOne();

			if (!$userConv)
			{
				throw new \LogicException(\XF::phrase('requested_conversation_not_found'));
			}

			$recipientState = 'deleted_ignored';
			$recipient = $userConv->Recipient;

			if ($recipient)
			{
				$recipient->recipient_state = $recipientState;
				$recipient->save();
			}
		}

		return true;
	}
}