<?php

namespace Snog\Forms\Entity;

use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Structure;

/**
 * Class Promotion
 * @package Snog\Forms\Entity
 *
 * COLUMNS
 * @property int $post_id
 * @property int $thread_id
 * @property int $poll_id
 * @property int $user_id
 * @property int $posid
 * @property int $close_date
 * @property bool $approve
 * @property int $original_group
 * @property array $original_additional
 * @property int $new_group
 * @property array $new_additional
 * @property int $forum_node
 * @property int $log_id
 *
 * RELATIONS
 * @property Form $Form
 * @property Log $Log
 * @property Answers[] $Answers
 * @property \XF\Entity\Thread $Thread
 * @property \XF\Entity\Post $Post
 * @property \XF\Entity\User $User
 * @property \XF\Entity\Poll $closedPoll
 */
class Promotion extends Entity
{
	public function revertInstantPromotion()
	{
		// REMOVE INSTANT PROMOTE
		$form = $this->Form;
		$user = $this->User;
		if ($form && $user)
		{
			/** @var \XF\Service\User\UserGroupChange $userGroupService */
			$userGroupService = $this->app()->service('XF:User\UserGroupChange');
			$userGroupService->addUserGroupChange($user->user_id, 'formsInstantPromote' . $form->posid, []);

			/** @var \Snog\Forms\Repository\Promotion $promotionRepo */
			$promotionRepo = $this->repository('Snog\Forms:Promotion');
			$promotionRepo->applyPrimaryGroupChange($user->user_id, $this->original_group);
		}
	}

	protected function setupApiResultData(\XF\Api\Result\EntityResult $result, $verbosity = self::VERBOSITY_NORMAL, array $options = [])
	{
		if (!empty($options['with_answers']) || \XF::$versionId >= 2030031 && $result->getResultType() === \XF\Api\Result\EntityResultInterface::TYPE_WEBHOOK)
		{
			$answers = $this->getRelationFinder('Answers')->fetchColumns(['questionid', 'answer']);
			$result->includeExtra('answers', $answers);
		}

		if (!empty($options['with_user']) || \XF::$versionId >= 2030031 && $result->getResultType() === \XF\Api\Result\EntityResultInterface::TYPE_WEBHOOK)
		{
			$result->includeRelation('User');
		}
	}

	public static function getStructure(Structure $structure)
	{
		$structure->table = 'xf_snog_forms_promotions';
		$structure->shortName = 'Snog\Forms:Promotion';
		$structure->contentType = 'snog_forms_promotion';
		$structure->primaryKey = 'post_id';
		$structure->columns = [
			'post_id' => ['type' => self::UINT, 'default' => 0, 'api' => true],
			'thread_id' => ['type' => self::UINT, 'default' => 0, 'api' => true],
			'poll_id' => ['type' => self::UINT, 'default' => 0, 'api' => true],
			'user_id' => ['type' => self::UINT, 'default' => 0, 'api' => true],
			'posid' => ['type' => self::UINT, 'default' => 0, 'api' => true],
			'close_date' => ['type' => self::UINT, 'default' => 0, 'api' => true],
			'approve' => ['type' => self::BOOL, 'default' => false, 'api' => true],
			'original_group' => ['type' => self::UINT, 'default' => 0, 'api' => true],
			'original_additional' => ['type' => self::JSON_ARRAY, 'default' => [], 'api' => true],
			'new_group' => ['type' => self::UINT, 'default' => 0, 'api' => true],
			'new_additional' => ['type' => self::JSON_ARRAY, 'default' => [], 'api' => true],
			'forum_node' => ['type' => self::UINT, 'default' => 0, 'api' => true],
			'log_id' => ['type' => self::UINT, 'default' => 0, 'api' => true]
		];

		if (\XF::$versionId >= 2030031)
		{
			$structure->behaviors['XF:Webhook'] = [];
		}

		$structure->getters = [];
		$structure->relations = [
			'Form' => [
				'entity' => 'Snog\Forms:Form',
				'type' => self::TO_ONE,
				'conditions' => [['posid', '=', '$posid']],
				'primary' => true
			],
			'Log' => [
				'entity' => 'Snog\Forms:Log',
				'type' => self::TO_ONE,
				'conditions' => 'log_id',
				'primary' => true
			],
			'Answers' => [
				'entity' => 'Snog\Forms:Answers',
				'type' => self::TO_MANY,
				'conditions' => 'log_id',
				'key' => 'questionid',
				'primary' => false
			],
			'Thread' => [
				'entity' => 'XF:Thread',
				'type' => self::TO_ONE,
				'conditions' => 'thread_id',
				'primary' => true,
			],
			'Post' => [
				'entity' => 'XF:Post',
				'type' => self::TO_ONE,
				'conditions' => 'post_id',
				'primary' => true,
			],
			'User' => [
				'entity' => 'XF:User',
				'type' => self::TO_ONE,
				'conditions' => 'user_id',
				'primary' => true,
			],
			'closedPoll' => [
				'entity' => 'XF:Poll',
				'type' => self::TO_ONE,
				'conditions' => [
					['poll_id', '=', '$poll_id'],
					['close_date', '=', '$close_date']
				],
			],
		];

		$structure->withAliases = [
			'api' => [
				'User.api',
				'Post.api'
			]
		];

		return $structure;
	}
}