<?php

namespace Snog\Forms\Pub\Controller;

use Snog\Forms\Mvc\Controller\LogListTrait;

class Log extends \XF\Pub\Controller\AbstractController
{
	use LogListTrait;

	public function assertViewingPermissions($action)
	{
		parent::assertViewingPermissions($action);

		if (!\XF::visitor()->hasPermission('snogForms', 'viewLogs'))
		{
			throw $this->exception($this->noPermission());
		}
	}

	protected function getFormLogClassIdentifier()
	{
		return 'Snog\Forms:Logs';
	}

	protected function getFormLogLinkPrefix()
	{
		return 'form/logs';
	}

	protected function getFormLogTemplatePrefix()
	{
		return 'snog_forms_log';
	}
}