<?php

namespace Snog\Forms\Service\Promotion;

use XF\Service\AbstractService;

class Approve extends AbstractService
{
	protected $promotion;

	protected $approvedBy;

	public function __construct(\XF\App $app, \Snog\Forms\Entity\Promotion $promotion)
	{
		parent::__construct($app);
		$this->promotion = $promotion;
		$this->approvedBy = \XF::visitor();
	}

	public function setApprovedBy($approvedBy)
	{
		$this->approvedBy = $approvedBy;
	}

	public function validate(&$errors = [])
	{
		return true;
	}

	public function approve()
	{
		$promotion = $this->promotion;
		$user = $promotion->User;
		if (!$user)
		{
			return false;
		}

		/** @var \Snog\Forms\Repository\Promotion $promotionRepo */
		$promotionRepo = $this->repository('Snog\Forms:Promotion');

		$form = $promotion->Form;

		// REMOVE INSTANT PROMOTE
		if ($form->removeinstant)
		{
			$promotion->revertInstantPromotion();
		}

		// CLOSE THE POLL IF ONE EXISTS
		if ($promotion->poll_id)
		{
			$promotionRepo->closePoll($promotion);
		}

		// CHANGE PRIMARY GROUP
		if ($form->promote_type == 1)
		{
			$promotionRepo->applyPrimaryGroupChange($user->user_id, $form->decidepromote);
		}

		// HANDLE USER GROUP ADD IF NOT MAKING A MODERATOR
		if ($form->make_moderator <= 1 && $form->promote_type == 2)
		{
			/** @var \XF\Service\User\UserGroupChange $userGroupService */
			$userGroupService = $this->service('XF:User\UserGroupChange');
			$userGroupService->addUserGroupChange($user->user_id, 'formsAddGroups' . $form->posid, $promotion->new_additional);
		}

		// XF HANDLES USER GROUP ADDS IF MAKING A MODERATOR - MAKE THE CALLS
		if ($form->make_moderator > 1)
		{
			/** @var \Snog\Forms\Repository\Promotion $promotionRepo */
			$promotionRepo = $this->repository('Snog\Forms:Promotion');
			$promotionRepo->promoteModerator($promotion, $user);
		}

		// APPEND APPROVED TO POST

		/** @var \XF\Entity\Post $post */
		$post = $this->em()->find('XF:Post', $promotion->post_id);
		if ($post)
		{
			$message = $post->message;
			$message .= "\r\n\r\n";

			if ($this->approvedBy instanceof \XF\Entity\User)
			{
				$message .= "[SIZE=2]" . \XF::phrase('snog_forms_approved_by') . " " . $this->approvedBy->username . "[/SIZE]";
			}
			elseif (is_string($this->approvedBy))
			{
				$message .= "[SIZE=2]" . \XF::phrase('snog_forms_approved_by') . " " . $this->approvedBy . "[/SIZE]";
			}

			$post->message = $message;
			if ($post->isChanged('message'))
			{
				$post->save(false, false);
			}
		}

		// ALL DONE - DELETE THE PROMOTION RECORD
		$promotion->delete();
		$this->afterApprove();

		return true;
	}

	protected function afterApprove()
	{
		$promotion = $this->promotion;
		$form = $promotion->Form;
		$user = $promotion->User;

		// Send approved pc
		if ($form->approved_title)
		{
			$sender = $form->ConversationUser;
			if ($sender)
			{
				$message = str_replace('{1}', $form->position, $form->approved_text);
				$this->sendPC($form->approved_title, $message, $sender, $user->username, $form->pmdelete, $form->parseyesno);
			}
		}

		if ($form->approved_file)
		{
			include $form->approved_file;
		}

		if (\XF::$versionId >= 2030031)
		{
			/** @var \XF\Repository\Webhook $webhookRepo */
			$webhookRepo = $this->repository('XF:Webhook');
			$webhookRepo->queueWebhook(
				$this->promotion->getEntityContentType(),
				$this->promotion->getEntityId(),
				'approve',
				$this->promotion
			);
		}
	}

	protected function sendPC($title, $message, $sender, $receiver, $close = true, $parse = false)
	{
		$options['open_invite'] = false;
		$options['conversation_open'] = !$close;

		/** @var \XF\Service\Conversation\Creator $creator */
		$creator = $this->service('XF:Conversation\Creator', $sender);
		$creator->setOptions($options);
		$creator->setRecipients($receiver, false, false);
		$creator->setContent($title, $message, (bool) $parse);
		$creator->setIsAutomated();
		$creator->save();

		$conversation = $creator->getConversation();

		// DELETE PC FROM SENDER'S INBOX
		if ($close)
		{
			/** @var \XF\Finder\ConversationUser $finder */
			$finder = $this->finder('XF:ConversationUser');

			/** @var \XF\Entity\ConversationUser $userConv */
			$userConv =  $finder->forUser($sender, false)
				->where('conversation_id', $conversation->conversation_id)
				->fetchOne();

			if (!$userConv)
			{
				return false;
			}

			$recipientState = 'deleted_ignored';
			$recipient = $userConv->Recipient;

			if ($recipient)
			{
				$recipient->recipient_state = $recipientState;
				$recipient->save();
			}
		}

		return true;
	}
}
