<?php

namespace Snog\Forms\Service\Promotion;

use XF\Service\AbstractService;

class Deny extends AbstractService
{
	protected $promotion;

	protected $deniedBy;

	public function __construct(\XF\App $app, \Snog\Forms\Entity\Promotion $promotion)
	{
		parent::__construct($app);
		$this->promotion = $promotion;
		$this->deniedBy = \XF::visitor();
	}

	public function setDeniedBy($deniedBy)
	{
		$this->deniedBy = $deniedBy;
	}

	public function validate(&$errors = [])
	{
		return true;
	}

	public function deny()
	{
		$promotion = $this->promotion;
		$user = $promotion->User;
		if (!$user)
		{
			return false;
		}

		/** @var \Snog\Forms\Repository\Promotion $promotionRepo */
		$promotionRepo = $this->repository('Snog\Forms:Promotion');

		// CLOSE POLL
		if ($promotion->poll_id)
		{
			$promotionRepo->closePoll($promotion);
		}

		$form = $promotion->Form;

		// REMOVE INSTANT PROMOTE
		if ($form->removeinstant)
		{
			$promotion->revertInstantPromotion();
		}

		/** @var \XF\Entity\Post $post */
		$post = $this->em()->find('XF:Post', $promotion->post_id);
		if ($post)
		{
			$message = $post->message;
			$message .= "\r\n\r\n";

			if ($this->deniedBy instanceof \XF\Entity\User)
			{
				$message .= "[SIZE=2]" . \XF::phrase('snog_forms_denied_by') . " " . $this->deniedBy->username . "[/SIZE]";
			}
			elseif (is_string($this->deniedBy))
			{
				$message .= "[SIZE=2]" . \XF::phrase('snog_forms_denied_by') . " " . $this->deniedBy . "[/SIZE]";
			}

			$post->message = $message;
			if ($post->isChanged('message'))
			{
				$post->save(false, false);
			}
		}

		// ALL DONE - DELETE THE PROMOTION RECORD
		$promotion->delete();
		$this->afterDeny();

		return true;
	}

	protected function afterDeny()
	{
		$promotion = $this->promotion;
		$form = $promotion->Form;
		$user = $promotion->User;

		// Send denied pc
		if ($form->denied_title)
		{
			$sender = $form->ConversationUser;
			if ($sender)
			{
				$message = str_replace('{1}', $form->position, $form->denied_text);
				$this->sendPC($form->denied_title, $message, $sender, $user->username, $form->pmdelete, $form->parseyesno);
			}
		}

		if (\XF::$versionId >= 2030031)
		{
			/** @var \XF\Repository\Webhook $webhookRepo */
			$webhookRepo = $this->repository('XF:Webhook');
			$webhookRepo->queueWebhook(
				$this->promotion->getEntityContentType(),
				$this->promotion->getEntityId(),
				'deny',
				$this->promotion
			);
		}
	}

	protected function sendPC($title, $message, $sender, $receiver, $close = true, $parse = false)
	{
		$options['open_invite'] = false;
		$options['conversation_open'] = !$close;

		/** @var \XF\Service\Conversation\Creator $creator */
		$creator = $this->service('XF:Conversation\Creator', $sender);
		$creator->setOptions($options);
		$creator->setRecipients($receiver, false, false);
		$creator->setContent($title, $message, (bool) $parse);
		$creator->setIsAutomated();
		$creator->save();

		$conversation = $creator->getConversation();

		// DELETE PC FROM SENDER'S INBOX
		if ($close)
		{
			/** @var \XF\Finder\ConversationUser $finder */
			$finder = $this->finder('XF:ConversationUser');

			/** @var \XF\Entity\ConversationUser $userConv */
			$userConv =  $finder->forUser($sender, false)
				->where('conversation_id', $conversation->conversation_id)
				->fetchOne();

			if (!$userConv)
			{
				return false;
			}

			$recipientState = 'deleted_ignored';
			$recipient = $userConv->Recipient;

			if ($recipient)
			{
				$recipient->recipient_state = $recipientState;
				$recipient->save();
			}
		}

		return true;
	}
}
