<?php

namespace Snog\Forms\XF\Pub\Controller;

use XF\Mvc\ParameterBag;

class Forum extends XFCP_Forum
{
	public function actionForum(ParameterBag $params)
	{
		$reply = parent::actionForum($params);

		if ($reply instanceof \XF\Mvc\Reply\View)
		{
			$forum = $reply->getParam('forum');
			if ($forum instanceof \XF\Entity\Forum)
			{
				/** @var \Snog\Forms\Repository\Form $formRepo */
				$formRepo = $this->repository('Snog\Forms:Form');
				$forms = $formRepo->getActiveFormsForForum($forum);

				$replaceButton = false;

				/** @var \Snog\Forms\Entity\Form $form */
				foreach ($forms as $form)
				{
					if ($form->post_thread_button_replace)
					{
						$replaceButton = true;
						break;
					}
				}

				$reply->setParam('forms', $forms);
				$reply->setParam('formsReplacePostThreadButton', $replaceButton);
			}
		}

		return $reply;
	}
}