<?php

namespace Snog\Forms\XF\Pub\Controller;

use Snog\Forms\Entity\Question;
use XF\Mvc\ParameterBag;

class Thread extends XFCP_Thread
{
	public function actionIndex(ParameterBag $params)
	{
		$view = parent::actionIndex($params);

		if ($view instanceof \XF\Mvc\Reply\View)
		{
			/** @var \Snog\Forms\XF\Entity\Thread $thread */
			$thread = $view->getParam('thread');
			if (!$thread)
			{
				return $view;
			}

			$form = $thread->Form;
			if (!$form || !$form->quickreply)
			{
				return $view;
			}

			/** @var \Snog\Forms\Repository\Question $questionRepo */
			$questionRepo = $this->repository('Snog\Forms:Question');
			$questions = $questionRepo->getQuestionList($form->posid);

			if (!$questions)
			{
				return $view;
			}

			$needNodeTree = false;
			$nodeTree = null;

			$uploadNeeded = false;

			$expectedAnswers = [];
			$conditionQuestions = [];

			// SETUP CONDITIONALS AND ANSWERS FOR CHOICE QUESTIONS
			foreach ($questions as $question)
			{
				// BUILD AND SORT CONDITIONAL QUESTIONS
				if ($question->hasconditional)
				{
					$conditionals = $questionRepo->getQuestionConditionals($question, $questions, $uploadNeeded);
					$conditionQuestions[$question['questionid']] = $conditionals;
				}

				// DETECT FILE UPLOAD QUESTION TYPE
				if ($question->isUploadNeeded())
				{
					$uploadNeeded = true;
				}

				if ($question->type == 'forum_select')
				{
					$needNodeTree = true;
				}
			}

			$warnings = [];
			$visitor = \XF::visitor();
			$canSubmit = $form->checkUserCriteriaMatch($visitor);
			if (!$canSubmit)
			{
				$warnings[] = \XF::phrase('snog_forms_not_allowed_to_submit');
			}

			/** @var \Snog\Forms\ControllerPlugin\Form $formPlugin */
			$formPlugin = $this->plugin('Snog\Forms:Form');

			if ($form->cooldown !== 0)
			{
				$cooldownError = $formPlugin->assertFormCooldown($form, $visitor, $this->request->getIp(), false);
				if (!empty($cooldownError))
				{
					$canSubmit = false;
					$warnings[] = $cooldownError;
				}
			}

			if ($needNodeTree)
			{
				/** @var \XF\Repository\Node $nodeRepo */
				$nodeRepo = $this->repository('XF:Node');
				$nodeTree = $nodeRepo->createNodeTree($nodeRepo->getFullNodeList());
			}

			$viewParams = [
				'formExpectedAnswers' => $expectedAnswers,
				'formQuestions' => $questions,
				'formConditionQuestions' => $conditionQuestions,
				'formWarnings' => $warnings,
				'canSubmitForm' => $canSubmit,
				'nodeTree' => $nodeTree
			];

			$view->setParams($viewParams);
		}

		return $view;
	}

	protected function getThreadViewExtraWith()
	{
		$extraWith = parent::getThreadViewExtraWith();
		$extraWith[] = 'Form';

		return $extraWith;
	}
}