<?php

namespace StylesFactory\SFCore;

use XF\AddOn\AbstractSetup;
use XF\AddOn\StepRunnerInstallTrait;
use XF\AddOn\StepRunnerUninstallTrait;
use XF\AddOn\StepRunnerUpgradeTrait;
use XF\Db\Schema\Alter;
use XF\Db\Schema\Create;

class Setup extends AbstractSetup
{
    use StepRunnerInstallTrait;
    use StepRunnerUpgradeTrait;
    use StepRunnerUninstallTrait;
    
    public function installStep1(array $stepParams = [])
    {
        $sm = $this->schemaManager();

        $sm->alterTable('xf_node', function(Alter $table)
        {
            $table->addColumn('dwa', 'text')->nullable()->setDefault('NULL');
	        $table->addColumn('verti_back', 'varchar', 250)->nullable();
        });
        $this->createWidget('sf_announcements', 'sf_announcements', []);
    }

    public function uninstallStep1(array $stepParams = [])
    {
        $sm = $this->schemaManager();

        $sm->alterTable('xf_node', function(Alter $table)
        {
            $table->dropColumns(array('dwa'));
	        $table->dropColumns(array('verti_back'));
        });
        $this->deleteWidget('sf_announcements', 'sf_announcements', []);
    }

}