<?php

namespace StylesFactory\SFCore\XF\Widget;

use XF\Widget\AbstractWidget;
use function in_array;

class VaultMembers extends AbstractWidget
{
	protected $defaultOptions = [
		'limit' => 50,
		'staffOnline' => true,
		'staffQuery' => false,
		'followedOnline' => true
	];

	public function render()
	{
		if (!\XF::visitor()->canViewMemberList())
		{
			return '';
		}

		/** @var \XF\Repository\SessionActivity $activityRepo */
		$activityRepo = $this->repository('XF:SessionActivity');



        $results = $this->db()->fetchAll('SELECT * FROM `xf_user_group` ORDER BY display_style_priority DESC');


		$viewParams = [
			'online' => $activityRepo->getOnlineStatsBlockData(true, $this->options['limit'], $this->options['staffQuery']),
            'results' => $results
		];


		return $this->renderer('widget_vault_members_online', $viewParams);
	}

	public function verifyOptions(\XF\Http\Request $request, array &$options, &$error = null)
	{
		$options = $request->filter([
			'limit' => 'uint',
			'staffOnline' => 'bool',
			'staffQuery' => 'bool',
			'followedOnline' => 'bool',
		]);
		return true;
	}
}