# ![JoyPixels Logo](https://www.joypixels.com/images/logos/logo-cyan-tm.svg)

> [![npm version](https://img.shields.io/npm/v/emoji-toolkit.svg)](https://www.npmjs.com/package/emoji-toolkit) [![npm downloads](https://img.shields.io/npm/dt/emoji-toolkit.svg)](https://www.npmjs.com/package/emoji-toolkit) [![jsDelivr hits](https://data.jsdelivr.com/v1/package/npm/emoji-toolkit/badge?style=rounded)](https://www.jsdelivr.com/package/npm/emoji-toolkit)

A set of libraries to help users find and replace native system emojis with JoyPixels (formerly EmojiOne) in their app or website.

> Heads up! 
> EmojiOne has rebranded to JoyPixels. Please see our [UPGRADE DOC](UPGRADE.md) for details on what's new, especially 
> if you're migrating from [emojione](https://www.github.com/joypixels/emojione), as all references to "emojione" in
> class names and file names have been changed.

## What's Included?

 - This project includes libraries used to convert emoji into various formats, including conversion to JoyPixels emoji images.
 - All libraries included here are available free under the MIT license.
 
 
## License to Use JoyPixels Images
 
### JoyPixels Version 4+
JoyPixels Version 4+ is available under the same licensing structure as Version 3. Please see below for more details.
 
### JoyPixels Version 3+
 
JoyPixels launched version 3.0 in 2017, which has several licensing options available. PNG 32px, 64px, and 128px as well as 32px and 64px sprites are available for digital use, with attribution. See [https://www.joypixels.com/licenses/free](https://www.joypixels.com/licenses/free) for more information on usage and attribution requirements.

*Premium Licenses are available for larger PNG assets and SVG assets, for digital and print use (within budget constraints).* See [https://www.joypixels.com/licenses/premium](https://www.joypixels.com/licenses/premium) for more information or to obtain a Premium License.
 
For product/retail licensing, see our Enterprise License [https://www.joypixels.com/licenses/enterprise](https://www.joypixels.com/licenses/enterprise).
 
### JoyPixels Version 2
 
JoyPixels version 2 is no longer supported or distributed. Please see [UPGRADE.md](UPGRADE.md) for instructions on upgrading from version 2 to version 3. Version 2 was bound by the [Creative Commons Attribution 4.0 International License](https://creativecommons.org/licenses/by/4.0/).

## Installation
To install the JoyPixels/emoji-toolkit, please refer to the guide at [INSTALLATION.md](INSTALLATION.md). **Version 3 introduces many  potentially-breaking changes.** Refer to the [UPGRADE.md](UPGRADE.md) documentation for more details.


## Contributing
Please see [CONTRIBUTING.md](CONTRIBUTING.md) for more info on contributing to the JoyPixels/emoji-toolkit project. For artwork comments and questions please see the emojione-assets repo.

## Usage
You'll find basic usage examples here in the [/examples/](examples/) directory, and links to usage demos in [USAGE.md](USAGE.md).

## Change Log
See the [releases page](https://github.com/joypixels/emoji-toolkit/releases) for information on what's new in the latest release.

## Information

### Bug reports

If you discover any bugs, feel free to create an issue on GitHub. We also welcome the open-source community to contribute to the project by forking it and issuing pull requests.

 *  https://github.com/joypixels/emoji-toolkit/issues


### Contact

If you have any questions, comments, or concerns you are welcome to contact us.

*  [![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/emojione/emojione?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)
* [support@joypixels.com](mailto:support@joypixels.com)
* https://www.joypixels.com
* https://twitter.com/joypixels


### Alternatives
We sincerely hope that you choose to use JoyPixels and support our project, but if you feel like it's not for you, please have a look at these possible alternatives:

* https://github.com/hassankhan/emojify.js (This repository has been archived by the owner before Nov 9, 2022. It is now read-only.)
* https://github.com/emojidex/ (used to be known as [Phantom Open Emoji](https://github.com/Genshin/PhantomOpenEmoji))
* https://github.com/iamcal/emoji-data (with [PHP](https://github.com/iamcal/php-emoji) and [Javascript](https://github.com/iamcal/js-emoji) interfaces)
* https://github.com/node-modules/emoji
* https://github.com/steveklabnik/emoji
* https://github.com/rockerhieu/emojicon (This projected is discontinued)
* https://github.com/HenrikJoreteg/emoji-images (this repo not actively maintained)
* https://github.com/frissdiegurke/emoji-parser (repository no longer exists)
* https://github.com/muan/emojilib
* https://github.com/kcthota/emoji4j (This project is not actively being maintainted)
