<?php
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    $G_API = true;

    session_start();

    include 'assets/php/utils.php';

    include 'assets/php/autoload.php';

    require __DIR__ . '/vendor/autoload.php';

    include 'config.php';

    date_default_timezone_set(Config::Get('timezone'));

    $db = new MysqliDb(array(
        'host' => Config::Get('mysql_server'),
        'username' => Config::Get('mysql_user'),
        'password' => Config::Get('mysql_pw'),
        'db'=> Config::Get('mysql_db'),
        'port' => Config::Get('mysql_port'),
        'prefix' => 'gex_',
        'charset' => (!tempty(Config::Get('mysql_charset')) ? Config::Get('mysql_charset') : 'latin1')
    ));

    $nokeyfiles = NoAuthFiles::GetForApplication('api');

    $addonManager = new AddonManager;
    $apiManager = new FileManager('api');
    $languageManager = new LanguageManager('language');
    $versionManager = new VersionManager();

    if (isset($_GET['t']) && !tempty($_GET['t'])) {
        if (!in_array($_GET['t'], $nokeyfiles)) {
            if (!isset($_GET['key'])) {
                Error('key required');
            } else {
                if ($_GET['key'] != Settings::Get('settings_api_key')) {
                    Error('incorrect key');
                }
            }
        }

        $languageManager->Load();

        if (in_array($_GET['t'], array_keys($apiManager->files))) {
            foreach ($apiManager->files[$_GET['t']]['files'] as $_file) {
                if (file_exists($_file)) {
                    include $_file;
                }
            }
        } else {
            Error("requested target not found");
        }
    } else {
        Error('no target given');
    }
