<?php
    if (!isset($G_API)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    RequiredArguments('action');

    if ('goal' == $action) {
        Result(array('total' => FormatPrice(Donations::GetMonthTotal()), 'goal' => FormatPrice(Settings::Get('settings_donations_monthlygoal'))));
    } elseif ('currency' == $action) {
        Result(array('code' => Settings::Get('settings_donations_currency_plain'), 'symbol' => Settings::Get('settings_donations_currency')));
    } elseif ('create' == $action) {
        RequiredArguments('steamid_for', 'amount', 'packageid');
        OptionalArguments('steamid_buyer', 'name_buyer', 'transactionid', 'email', 'gateway', 'runonetimerewards', 'notify');

        if (tempty($steamid64_buyer)) {
            $steamid_buyer = $steamid_for;
        }

        $for = new User($steamid_for);
        $buyer = new User($steamid_buyer);
        $package = new Package($packageid);

        if (!$for->valid) {
            Error('User with steamid '.$steamid_for.' not found.');
        } elseif (!$buyer->valid) {
            Error('User with steamid '.$steamid_buyer.' not found.');
        } elseif (!$package->valid) {
            Error('Package with id '.$packageid.' not found.');
        }

        if (tempty($name_buyer)) {
            $name_buyer = $buyer->GetValue('nick');
        }

        if (tempty($transactionid)) {
            $transactionid = 'api-'.time();
        }

        if (tempty($gateway)) {
            $gateway = 'api';
        }

        if (!is_numeric($notify)) {
            $notify = 1;
        }

        if (!is_numeric($runonetimerewards)) {
            $notify = 1;
        }

        $data = array(
            'name_buyer' => $name_buyer,
            'steamid64_buyer' => $buyer->GetValue('steamid64'),
            'steamid64_for' => $for->GetValue('steamid64'),
            'amount' => $amount,
            'package' => $packageid,
            'transactionid' => $transactionid,
            'coupon' => '',
            'email' => $email,
            'gateway' => $gateway,
        );

        if (Payment::Finish($data, $buyer, $for, $package, false, (false == $notify), $runonetimerewards)) {
            Success();
        } else {
            Error('unknown error');
        }
    }
