<?php
if (!isset($G_API)) {
    die(json_encode(array('error' => 'authentification failed')));
}

RequiredArguments('type');
OptionalArguments('page');

global $type, $page, $db;

if (tempty($page)) {
    $page = 1;
} else {
    $page = intval($page);
}


if (!in_array($type, array('bans', 'users', 'donations', 'groups', 'serverbundles', 'packages', 'packages_bought',
    'rewards', 'servers', 'warnings', 'statistics', 'settings'))) {
    Error("Type not allowed");
}

if (strtolower($type) == 'settings') {
    $db->where("setting in ('settings_general_defaultgroup')");
}

$db->pageLimit = 500;
$dict = $db->arraybuilder()->paginate($type, $page);

function produceCSV($file_name, $arr) {
    $has_header = false;

    foreach ($arr as $c) {
        $fp = fopen($file_name, 'w');

        if (!$has_header) {
            fputcsv($fp, array_keys($c));
            $has_header = true;
        }

        fputcsv($fp, $c);
        fclose($fp);
    }
}

produceCSV("php://output", $dict);