<?php
    if (!isset($G_API)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    RequiredArguments('action');

    if ('assign' == $action) {
        RequiredArguments('steamid', 'packageid');
        OptionalArguments('donationid', 'days', 'runonetimerewards', 'notify');

        if (is_numeric($packageid)) {
            $for = new User($steamid);
            $package = new Package($packageid);

            if (!is_numeric($donationid)) {
                $donationid = 0;
            }

            if (!is_numeric($days)) {
                $days = -1;
            }

            if (!is_numeric($notify)) {
                $notify = 1;
            }

            if (!is_numeric($runonetimerewards)) {
                $notify = 1;
            }

            if (!$for->valid) {
                Error('User with steamid '.$steamid.' not found.');
            } elseif (!$package->valid) {
                Error('Package with id '.$packageid.' not found.');
            }

            $package->ActivateFor($for, $donationid, $days, (false == $runonetimerewards), (false == $notify));

            Success();
        } else {
            Error('Malformed packageid.');
        }
    }
