<?php
    if (!isset($G_API)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    RequiredArguments('action', 'steamid');

    $user = new User($steamid);

    $checkUserValid = array('setgroup', 'getgroup');

    if (in_array($action, $checkUserValid)) {
        if (!$user->valid) {
            Error('user not found');
        }
    }

    if ('setgroup' == $action) {
        RequiredArguments('groupname', 'bundle');

        $user->SetGroup($groupname, $bundle);

        Success();
    } elseif ('getgroup' == $action) {
        RequiredArguments('bundle');

        Result(array('result' => $user->GetGroup($bundle)->GetValue('groupname')));
    } elseif ('unban' == $action) {
        RequiredArguments('serverbundle');

        $user->Unban($bundle);
        Success();
    } elseif ('create' == $action) {
        if ($user->valid) {
            Error('user already exists');
        }

        if (!StartsWith($steamid, '7')) {
            Error('steamid64 required.');
        }

        if (User::Create($steamid)) {
            Success();
        } else {
            Error('user could not be created.');
        }
    }
