function post(path, params, method) {
    method = method || "post";

    var form = document.createElement("form");
    form.setAttribute("method", method);
    form.setAttribute("action", path);

    params['__token'] = window.csrf;

    for (var key in params) {
        if (params.hasOwnProperty(key)) {
            var hiddenField = document.createElement("input");
            hiddenField.setAttribute("type", "hidden");
            hiddenField.setAttribute("name", key);
            hiddenField.setAttribute("value", params[key]);

            form.appendChild(hiddenField);
        }
    }

    document.body.appendChild(form);
    form.submit();
}

function ReplaceAll(find, replace, str) {
    return str.replace(new RegExp(find, 'g'), replace);
}

function activateTab(tab) {
    $('.nav-tabs a[href="#' + tab + '"]').tab('show');
}

function isCollapsed(element) {
    var $e = $(element);

    return $e.width() * $e.height() !== 0;
}

function PlaySound(src) {
    var audio = new Audio(src);
    audio.play();
}

function SaveInStorage(key, value) {
    if (typeof(Storage) !== 'undefined') {
        sessionStorage.setItem(key, value);
    }
}

function LoadFromStorage(key) {
    if (typeof(Storage) !== 'undefined') {
        return sessionStorage.getItem(key);
    }
    else {
        return '';
    }
}

function Redirect(url) {
    window.location.replace(url);
}

function OpenInNewTab(url) {
    var win = window.open(url, '_blank');
    win.focus();
}

function UpdateURL(url, noreplace = false) {
    /*if(!noreplace && url){
        url = url.replace(/index.php/g, "");
    }*/

    history.pushState(null, null, url);
    $.get("request.php?t=main_loginredirect", {
        to: url
    });
}

function htmlspecialchars(text) {
    if(!text){
        return "";
    }

    return text
      .replace(/&/g, "&amp;")
      .replace(/</g, "&lt;")
      .replace(/>/g, "&gt;")
      .replace(/"/g, "&quot;")
      .replace(/'/g, "&#039;");
}

function htmlspecialchars_eq(text) {
    if(!text){
        return "";
    }

    return text
      .replace(/</g, "&lt;")
      .replace(/>/g, "&gt;")
}

function quotes_unsafe(text){
    if(!text){
        return "";
    }

    return text
         .replace(/&quot;/g, '"')
         .replace(/&#039;/g, "'");
}

function htmlspecialchars_decode(text) {
    if(!text){
        return "";
    }

    return text
         .replace(/&amp;/g, "&")
         .replace(/&lt;/g, "<")
         .replace(/&gt;/g, ">")
         .replace(/&quot;/g, '"')
         .replace(/&#039;/g, "'");
}

var summernote_toolbar_default = [
    ['style', ['style']],
    ['font', ['bold', 'italic', 'underline', 'clear']],
    ['fontsize', ['fontsize']],
    ['color', ['color']],
    ['para', ['ul', 'ol', 'paragraph']],
    ['insert', ['link', 'hr', 'picture']],
    ['view', ['fullscreen', 'codeview']],
]

var summernote_toolbar_reduced = [
    ['style', ['style']],
    ['font', ['bold', 'italic', 'underline', 'clear']],
    ['color', ['color']],
    ['para', ['ul', 'ol']],
    ['insert', ['link', 'hr']],
    ['view', ['fullscreen', 'codeview']]
]

function FromJson(jsonstr){
    var ret = {};

    try{
        ret = JSON.parse(jsonstr);
    }catch(err){

    }

    return ret;
}

function ToJson(arr){
    var ret = "{}";

    try{
        ret = JSON.stringify(arr);
    }catch(err){

    }

    return ret;
}