<?php
    if (FunctionEnabled('spl_autoload_register') && FunctionEnabled('spl_autoload_unregister')) {
        function _gex_autoload($class_name)
        {
            $file = 'assets/php/classes/'.strtolower($class_name).'.class.php';

            if (file_exists($file)) {
                require_once($file);
            }
        }

        spl_autoload_register('_gex_autoload');
    } else {
        $classes = scandir('assets/php/classes/');
        foreach ($classes as $class) {
            if (EndsWith($class, '.class.php')) {
                include 'assets/php/classes/' . $class;
            }
        }
    }
