<?php
    class AddonManager
    {
        public $addons = array();
        private $files = array();

        public function __construct()
        {
            $path = './addons/';
            $addons_raw = scandir($path);

            foreach ($addons_raw as $addon) {
                if ('.' === $addon or '..' === $addon) {
                    continue;
                }

                $addonpath = $path.$addon.'/';

                if (is_dir($path . $addon)) {
                    $name = $addon;
                    $this->addons[$name]['rawname'] = $name;
                    $this->addons[$name]['path'] = $addonpath;
                    $this->addons[$name]['data'] = array();

                    if (file_exists($addonpath.'addon.txt')) {
                        $json = FromJson(file_get_contents($addonpath.'addon.txt'));

                        if (!empty($json)) {
                            $this->addons[$name]['data'] = $json;
                        }
                    }

                    $this->addons[$name]['installed'] = false;

                    if (file_exists($addonpath.'installed.txt') || !file_exists($addonpath.'install.php')) {
                        $this->addons[$name]['installed'] = true;

                        if (file_exists($addonpath.'installed.txt') && isset($this->addons[$name]['data']['version'])) {
                            $fl = GetFirstLine($addonpath.'installed.txt');

                            if ($fl) {
                                if ('0.0.0' != $fl) {
                                    if (version_compare($fl, $this->addons[$name]['data']['version'], '<')) {
                                        $this->addons[$name]['installed'] = false;
                                    }
                                }
                            }
                        }
                    }

                    $subfolders = glob($addonpath.'*', GLOB_ONLYDIR);

                    foreach ($subfolders as $subfolderpath) {
                        $subfolderpath_expl = explode('/', $subfolderpath);
                        $subfolder = end($subfolderpath_expl);

                        $subfolderpath = $subfolderpath.'/';

                        if (is_dir($subfolderpath)) {
                            $subfiles_raw = scandir($subfolderpath);

                            foreach ($subfiles_raw as $subfile) {
                                $filepath = $subfolderpath.$subfile;

                                if (is_file($filepath)) {
                                    if (FileHasExt($subfile, 'php') || FileHasExt($subfile, 'json')) {
                                        $this->files['./'.$subfolder.'/'][] = $filepath;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public function GetFilesForFolder($folder)
        {
            if (isset($this->files[$folder])) {
                if (is_array($this->files[$folder])) {
                    return $this->files[$folder];
                }
            }

            return array();
        }

        public function GetAddon($name)
        {
            if (isset($addons[$name])) {
                return $addons[$name];
            } else {
                return null;
            }
        }

        public function Uninstall($name)
        {
            if (isset($this->addons[$name])) {
                if (file_exists($this->addons[$name]['path'].'uninstall.php')) {
                    include $this->addons[$name]['path'].'uninstall.php';

                    if (function_exists('Uninstall')) {
                        Uninstall();
                    }
                }

                DeleteTarget($this->addons[$name]['path']);

                unset($this->addons[$name]);

                return true;
            } else {
                return false;
            }
        }

        public function Install($name)
        {
            global $auth_user;

            if (function_exists('Install')) {
                die('<br/><br/>ERROR!!! Can not update two addons/products in one request!');
            }

            if (isset($this->addons[$name])) {
                if (file_exists($this->addons[$name]['path'].'install.php')) {
                    include $this->addons[$name]['path'].'install.php';

                    if (function_exists('Install')) {
                        if (Install()) {
                            $version = '0.0.0';

                            if (isset($this->addons[$name]['data']['version'])) {
                                $version = $this->addons[$name]['data']['version'];
                            }

                            $file = fopen($this->addons[$name]['path'].'installed.txt', 'w');
                            fwrite($file, $version.'\n'.date(Settings::Get('settings_general_timeformat')).' by '.$auth_user->GetValue('steamid64'));
                            fclose($file);

                            return true;
                        }
                    }
                }
            }

            return false;
        }
    }
