<?php
    class Banprotest extends DBTableClass{
        public function __construct($id, $data = null){
            $this->Initialize('bans_protests', $id, 'id', $data);
        }
        
        public static function GetAll($pending = false){
            $db = MysqliDb::getInstance();
            
            if($pending){
                $db->where("status", 0);
            }
            
            $protests = $db->get("bans_protests");
            $protests_deliver = array();
            
            foreach($protests as $protest){
                $protests_deliver[$protest['id']] = new Banprotest($protest['id']);
            }
            
            return $protests_deliver;
        }
        
        public static function GetForBan($banid){
            $db = MysqliDb::getInstance();
            
            $db->where("banid", $banid);
            $protests = $db->get("bans_protests");
            
            $protests_deliver = array();
            
            foreach($protests as $protest){
                $protests_deliver[$protest['id']] = new Banprotest($protest['id']);
            }
            
            return $protests_deliver;
        }
        
        public static function Create($banid, $text){
            $db = MysqliDb::getInstance();
            
            $db->where("id", $banid);
            $ban = $db->getOne("bans");
            
            if($db->count){
                $protests = Banprotest::GetForBan($banid);
                
                $count = 0;
                $error = false;
                
                foreach($protests as $protest){
                    if($protest->GetValue('status') == 0){
                        $error = true;
                    }
                    
                    $count++;
                    
                    if($count >= (Settings::Get('settings_bans_protests_max'))){
                        $error = true;
                    }
                }
                
                if(!$error){
                    if($ban['steamid64'] == $GLOBALS['auth_user']->GetValue('steamid64')){
                        $data = array(
                            'protesttext' => preg_replace('/[\'"]/', '', htmlspecialchars($text)),
                            'banid' => $banid,
                            'status' => 0
                        );
                        
                        $db->insert("bans_protests", $data);
                        
                        if($db->count){
                            foreach(Permissions::GetSteamIDsWithPermission(false, 'bans_unban') as $steamid){
                                Notifications::Send($steamid, 'notification_protest_new', array('user' => $GLOBALS['auth_user']->GetValue('nick'), 'banid' => $ban['id']), 'index.php?t=admin_bans', 'question-circle-o');
                            }

                            return true;
                        }
                    }
                }
            }
            
            return false;
        }
    }
?>