<?php
	class Bans
	{
		public static function GetAll($limit = false, $page = 1)
		{
			$db = MysqliDb::getInstance();

			if ($limit) {
				$db->pageLimit = $limit;
			}

			$db->where('status < 2');
			$db->orderBy('date_banned', 'Desc');

			$bans = null;

			$bans = !$limit ? $db->get('bans') : $db->arraybuilder()->paginate('bans', $page);

			return $bans;
		}

		public static function ValidateBanLength($length, $bundle)
		{
			if ($length < 0 || is_float($length)) {
				return false;
			}

			$maxlength = $GLOBALS['auth_user']->GetGroup($bundle)->GetSetting('maxbanlength');

			if ($maxlength > 0) {
				if ($length > $maxlength || 0 == $length) {
					return false;
				}
			}

			return true;
		}

		public static function CanBan($steamid64, $length, $bundle)
		{
			if (Permissions::HasPermission('super')) {
				return true;
			}

			$toban = new User($steamid64);

			if (Bans::ValidateBanLength($length, $bundle)) {
				if ($toban->valid) {
					if (($GLOBALS['auth_user']->GetGroup($bundle)->GetValue('level') > $toban->GetGroup($bundle)->GetValue('level')) || Permissions::HasPermission('super')) {
						return true;
					} else {
						return false;
					}
				} else {
					return true;
				}
			} else {
				return false;
			}
		}

		public static function Add($steamid64, $length, $reason, $steamid64_admin, $serverbundle, $global, $date = null, $use_admin = false)
		{
			$db = MysqliDb::getInstance();
			global $auth_user;
			
			if ($auth_user === null) {
				return false;
			}

			if (!$use_admin && null === $steamid64_admin) {
				$steamid64_admin = $auth_user->GetValue('steamid64');
			}

			$data = [
				'steamid64' => $steamid64,
				'date_banned' => $db->now(),
				'serverbundle' => $serverbundle,
				'length' => $length,
				'reason' => $reason,
				'global' => $global,
				'steamid64_admin' => $steamid64_admin,
				'steamid64_admin_unbanned' => '',
				'status' => 0,
			];

			if ($date) {
				$data['date_banned'] = $date;
			}

			$db->insert('bans', $data);

			if ($db->count) {
				return true;
			} else {
				return false;
			}
		}

		public static function Unban($id)
		{
			$db = MysqliDb::getInstance();

			global $auth_user;

			if (!$auth_user) {
				$auth_user = new User('0');
			}

			$db->where('id', $id);
			$db->update('bans', array('status' => 1, 'date_unbanned' => $db->now(), 'steamid64_admin_unbanned' => $auth_user->GetValue('steamid64')));

			if ($db->count) {
				return true;
			} else {
				return false;
			}
		}

		public static function Remove($id)
		{
			$db = MysqliDb::getInstance();
		}

		public static function GetByUser($steamid64)
		{
			$db = MysqliDb::getInstance();

			$db->where('steamid64', $steamid64);
			$db->where('status < 2');
			$db->orderBy('date_banned', 'Desc');

			return $db->get('bans');
		}
	}
