<?php
class Cache extends DBTableClass{
    public function __construct($identifier, $ttl, $json=false){
        $jsonify = null;

        if($json){
            $jsonify = array('value');
        }

        $this->Initialize('cache', $identifier, 'identifier', null, $jsonify);

        if($this->valid){
            if(strtotime($this->GetValue('timestamp')) + $ttl < time()){
                $this->SetValue('value', null);
            }
        }else{
            global $db;

            $db->insert('cache', array('identifier' => $identifier));
            $this->RefreshData();
        }
    }

    public function Get(){
        return $this->GetValue('value');
    }

    public function Set($value){
        $this->Update(array('value' => $value,
                            'timestamp' => date('Y-m-d H:i:s')));
    }
}