<?php
    /**
     * Contains several methods for a system cleanup.
     */
    class Cleanup
    {
        /**
         * Deletes all users that had no activity within the last year.
         */
        public static function CleanUsers()
        {
            global $db;

            $db->rawQuery("DELETE FROM gex_users WHERE date_lastonline_web < DATE_SUB(NOW(), INTERVAL 180 DAY) AND date_lastonline_gmod < DATE_SUB(NOW(), INTERVAL 180 DAY) AND date_registered < DATE_SUB(NOW(), INTERVAL 180 DAY) AND email = '' AND ts3uid = '' AND steamid64 <> '0';");

            return $db->count;
        }

        /**
         * Clears the debug log.
         */
        public static function CleanDebug()
        {
            global $db;

            $db->delete('debug');

            return $db->count;
        }

        /**
         * Clears denied paysafecard requests.
         */
        public static function CleanPaysafecard()
        {
            global $db;

            $db->where('status', 2);
            $db->where('date < DATE_SUB(NOW(), INTERVAL 30 DAY)');
            $db->delete('paysafecard');

            return $db->count;
        }

        /**
         * Clears old and read notifications.
         */
        public static function CleanNotifications()
        {
            global $db;

            $db->where('date < DATE_SUB(NOW(), INTERVAL 180 DAY)');
            $db->where('status > 0');
            $db->delete('notifications');

            return $db->count;
        }

        /**
         * Clears expired sessions.
         */
        public static function CleanSessions()
        {
            global $db;

            $db->where('expires < NOW()');

            //print_r($db->get('sessions'));

            $db->delete('sessions');

            return $db->count;
        }

        /**
         * Deletes unrelated data.
         */
        public static function CleanUnrelatedData()
        {
            global $db;

            $count = 0;

            $db->rawQuery('DELETE FROM gex_bans WHERE serverbundle NOT IN (SELECT id FROM gex_serverbundles);');
            $count += $db->count;

            $db->rawQuery('DELETE FROM gex_warnings WHERE serverbundle NOT IN (SELECT id FROM gex_serverbundles);');
            $count += $db->count;

            $db->rawQuery('DELETE FROM gex_packages WHERE serverbundle NOT IN (SELECT id FROM gex_serverbundles);');
            $count += $db->count;

            $db->rawQuery('DELETE FROM gex_statistics WHERE serverbundle NOT IN (SELECT id FROM gex_serverbundles);');
            $count += $db->count;

            $db->rawQuery('DELETE FROM gex_rewards WHERE serverbundle NOT IN (SELECT id FROM gex_serverbundles) AND status <> 0;');
            $count += $db->count;

            $db->rawQuery('DELETE FROM gex_console WHERE server NOT IN (SELECT id FROM gex_servers);');
            $count += $db->count;

            $db->rawQuery('DELETE FROM gex_commands WHERE server NOT IN (SELECT id FROM gex_servers);');
            $count += $db->count;

            return $count;
        }
    }
