<?php
    class Comments
    {
        public $application;
        public $foreign_id;
        
        public function __construct($application, $foreign_id)
        {
            $this->application = $application;
            $this->foreign_id = $foreign_id;
        }
        
        public function GetComments($desc = false)
        {
            $db = MysqliDb::getInstance();
            
            $oder = 'Asc';
            
            if ($desc) {
                $order = 'Desc';
            }

            $db->where("application", $this->application);
            $db->where("foreign_id", $this->foreign_id);
            $db->orderBy("date", $order);
            
            $comments_data = $db->get("comments");
            $comments = array();
            
            foreach ($comments_data as $cdata) {
                $comments[] = new Comment($cdata['id'], $cdata);
            }
            
            return $comments;
        }
        
        public function Add($content, $steamid64 = null)
        {
            $db = MysqliDb::getInstance();
            
            if ($steamid64 === null) {
                global $auth_user;
                
                if ($auth_user) {
                    $steamid64 = $auth_user->GetValue('steamid64');
                } else {
                    return false;
                }
            }
            
            $data = array(
                'foreign_id' => $this->foreign_id,
                'application' => $this->application,
                'content' => $content,
                'steamid64' => $steamid64
            );
            
            $db->insert("comments", $data);
            
            return ($db->count > 0);
        }
    }
    
    class Comment extends DBTableClass
    {
        public function __construct($id, $data = null)
        {
            $this->Initialize('comments', $id, 'id', $data);
        }
    }
