<?php
    class Coupon extends DBTableClass{
        public function __construct($code, $mayempty = false){
            $code = strtolower(str_replace('-', '', $code));
            
            $this->Initialize('coupons', $code, 'code');
            
            if($this->valid){
                if($this->GetValue('amount_left') <= 0 && !$mayempty){
                    $this->valid = false;
                }
            }
            
        }
        
        public function Devaluate(){
            $this->SetValue('amount_left', 0);
        }
        
        public function AddAmount($amount){
            $this->SetValue('amount_left', ($this->GetValue('amount_left') + $amount));
        }
        
        public static function GetAll(){
            $db = MysqliDb::getInstance();
            
            $db->orderBy("date", "Desc");
            $coupons = $db->get("coupons");
            return $coupons;
        }
        
        public static function Create($amount, $code = false ){
            $db = MysqliDb::getInstance();
            
            if(!$code){
                $code = strtoupper(random_string(16));
            }
            
            $data = array(
                'code' => $code,
                'amount' => FormatPrice($amount),
                'amount_left' => $amount_left
            );
            
            $db->insert('coupons', $data);
            
            return $db->count;
        }
    }
?>