<?php
    /**
     * The DBTableClass is used as a processor for MySQL data.
     */

    class DBTableClass
    {
        /**
         * Raw MySQL data array
         * @var array
         */
        public $data;

        /**
         * MySQL data found or not
         * @var bool
         */
        public $valid = false;

        /**
         * Name of the global temp variable to save already requested data
         * @var array
         */
        private $tempname;

        /**
         * Name of the MySQL table
         * @var string
         */
        private $tablename;

        /**
         * Name of the primary key
         * @var string
         */
        private $id_name;

        /**
         * List of all keys that contain JSON
         * @var array
         */
        private $jsonify;

        /**
         * Initializes the class, checks if there is already temporary data or data is given in the parameters. Parses JSON if needed.
         * @param string $tablename
         * @param string|id $id
         * @param string $id_name
         * @param array $data
         * @param array $jsonify
         */
        public function Initialize($tablename, $id, $id_name, $data = null, $jsonify = array())
        {
            $this->tablename = $tablename;
            $this->id_name = $id_name;
            $this->tempname = 'TEMP_' . strtoupper($tablename);
            $this->jsonify = $jsonify;

            if (!isset($GLOBALS[$this->tempname])) {
                $GLOBALS[$this->tempname] = array();
            }

            if ($data) {
                $this->data = $data;
                $this->valid = $data;

                foreach ($this->jsonify as $key) {
                    if (isset($this->data[$key])) {
                        if (!is_array($this->data[$key])) {
                            $this->data[$key] = FromJson($this->data[$key]);
                        }
                    }
                }

                $GLOBALS[$this->tempname][$this->GetValue($this->id_name)] = $this->data;

                return;
            }

            if (isset($GLOBALS[$this->tempname][$id])) {
                $this->data = $GLOBALS[$this->tempname][$id];
                $this->valid = true;
            } else {
                $this->data[$id_name] = $id;
                $this->RefreshData();
            }
        }

        /**
         * Returns a MySQL value
         * @param string $key
         *
         * @return string|int|array
         */
        public function GetValue($key)
        {
            return $this->data[$key];
        }

        /**
         * Updates a MySQL value
         * @param string $key
         * @param string|int|array $value
         *
         * @return bool
         */
        public function SetValue($key, $value)
        {
            $db = MysqliDb::getInstance();

            if (is_array($value)) {
                $value = ToJson($value);
            }

            $data = array($key => $value);
            $db->where($this->id_name, $this->data[$this->id_name]);

            if ($db->update($this->tablename, $data)) {
                $this->RefreshData();
                return true;
            } else {
                return false;
            }
        }

        /**
         * Updates multiple MySQL values
         * @param array $data
         *
         * @return bool
         */
        public function Update($data)
        {
            $db = MysqliDb::getInstance();

            foreach($data as $key => $value){
                if (is_array($value)) {
                    $data[$key] = ToJson($value);
                }
            }

            $db->where($this->id_name, $this->data[$this->id_name]);

            if ($db->update($this->tablename, $data)) {
                $this->RefreshData();
                return true;
            } else {
                return false;
            }
        }

        /**
         * Gathers MySQL data, parses JSON if needed
         */
        public function RefreshData()
        {
            $db = MysqliDb::getInstance();

            $db->where($this->id_name, $this->GetValue($this->id_name));
            $data = $db->getOne($this->tablename);

            if ($db->count) {
                $this->valid = true;

                $this->data = $data;

                foreach ($this->jsonify as $key) {
                    if (isset($this->data[$key])) {
                        $this->data[$key] = FromJson($this->data[$key]);
                    }
                }

                $GLOBALS[$this->tempname][$this->GetValue($this->id_name)] = $this->data;
            } else {
                $this->valid = false;
            }
        }

        /**
         * Deletes the MySQL row
         *
         * @return bool
         */
        public function Delete()
        {
            $db = MysqliDb::getInstance();

            $db->where($this->id_name, $this->GetValue($this->id_name));
            $db->delete($this->tablename);

            if ($db->count) {
                return true;
            } else {
                return false;
            }
        }
    }
