<?php

    class Discord
    {
        public function makeRequest($endpoint, $method, $data = null)
        {
            global $versionManager;

            $requester = new CURLRequester('https://discord.com/api/v6/'.$endpoint, $method, true, false);

            $requester->addHeader('Authorization', 'Bot '.Settings::Get('settings_discord_bot_token'));
            $requester->addHeader('User-Agent', sprintf('DiscordBot (%s, %s)', GetCurrentLocation(), $versionManager->version));

            return $requester->request($data, true, 5);
        }

        public function sendMessage($user_id)
        {
            $channel = $this->makeRequest('users/@me/channels', 'post', array('recipient_id' => $user_id));

            if ($channel && isset($channel['id'])) {
                return $this->makeRequest(sprintf('/channels/%s/messages', $channel['id']), 'post', array('content' => 'test'));
            }
        }

        public function addRoleToUser($user_id, $role_id)
        {
            return $this->makeRequest(sprintf('/guilds/%s/members/%s/roles/%s', Settings::Get('settings_discord_guild_id'), $user_id, $role_id), 'PUT');
        }

        public function removeRoleFromUser($user_id, $role_id)
        {
            return $this->makeRequest(sprintf('/guilds/%s/members/%s/roles/%s', Settings::Get('settings_discord_guild_id'), $user_id, $role_id), 'DELETE');
        }

        public function getGuildMembers($cached = true)
        {
            if ($cached) {
                if (time() - intval(Settings::Get('discord_guild_members_updated')) <= 900) {
                    $cached_members = FromJson(Settings::Get('discord_guild_members'));

                    if (sizeof($cached_members) > 1) {
                        return $cached_members;
                    }
                }
            }

            $members = array();
            $last_id = null;

            while (0 == sizeof($members) % 1000) {
                if (!$last_id) {
                    $members_new = $this->makeRequest(sprintf('/guilds/%s/members?limit=1000', Settings::Get('settings_discord_guild_id')), 'GET');
                } else {
                    $members_new = $this->makeRequest(sprintf('/guilds/%s/members?limit=1000&after=%s', Settings::Get('settings_discord_guild_id'), $last_id), 'GET');
                }

                if (is_array($members_new)){
                    $members = array_merge($members, $members_new);

                    if (0 == sizeof($members_new)) {
                        break;
                    } elseif (1000 == sizeof($members_new)) {
                        $last_id = $members_new[999]['user']['id'];
                    }
                }
            }

            Settings::Set('discord_guild_members', ToJson($members));
            Settings::Set('discord_guild_members_updated', time());

            return $members;
        }

        public function getGuild()
        {
            return $this->makeRequest(sprintf('/guilds/%s', Settings::Get('settings_discord_guild_id')), 'GET');
        }

        public function getUserByUsername($username)
        {
            $username_exploded = explode('#', $username);
            $users = $this->getGuildMembers();

            if (2 == sizeof($username_exploded) && $users) {
                foreach ($users as $user) {
                    if (isset($user['user'])) {
                        if ($user['user']['username'] == $username_exploded[0] && $user['user']['discriminator'] == $username_exploded[1]) {
                            return $user['user'];
                        }
                    }
                }
            }

            return false;
        }
    }
