<?php
    class Donation extends DBTableClass
    {
        public function __construct($id, $data = null)
        {
            $this->Initialize('donations', $id, 'id', $data);
        }

        public function Revoke()
        {
            if ($this->GetValue('revoked')) {
                return false;
            }

            $db = MysqliDb::getInstance();

            $error = false;

            $db->where("donationid", $this->GetValue('id'));
            $db->where("status", 0);
            if (!$db->update("rewards", array('status' => 3))) {
                $error = true;
            }

            $db->where("donationid", $this->GetValue('id'));
            $db->where("status", 1);
            $packages_bought = $db->get("packages_bought");

            $db->where("donationid", $this->GetValue('id'));
            $db->where("status", 1);
            if (!$db->update("packages_bought", array('status' => 2))) {
                $error = true;
            }

            $this->SetValue('revoked', 1);

            if (!$error) {
                Notifications::Send($this->GetValue('steamid64_buyer'), 'notification_donation_revoked', array('donationid' => $this->GetValue('id'), 'amount' => Settings::Get('settings_donations_currency') . $this->GetValue('amount')), 'index.php?t=home', 'undo');

                foreach ($packages_bought as $package_bought) {
                    $package = new Package($package_bought['package']);
                    Notifications::Send($package_bought['steamid64'], 'notification_package_disabled', array('package' => $package->GetValue('title')), 'index.php?t=home', 'power-off');
                }
            }

            return !$error;
        }

        public function Unrevoke()
        {
            if (!$this->GetValue('revoked')) {
                return false;
            }

            $db = MysqliDb::getInstance();

            $error = false;

            $db->where("donationid", $this->GetValue('id'));
            $db->where("status", 3);
            if (!$db->update("rewards", array('status' => 0))) {
                $error = true;
            }

            $db->where("donationid", $this->GetValue('id'));
            $db->where("status", 2);
            $packages_bought = $db->get("packages_bought");

            $db->where("donationid", $this->GetValue('id'));
            $db->where("status", 2);
            if (!$db->update("packages_bought", array('status' => 1))) {
                $error = true;
            }

            $this->SetValue('revoked', 0);

            if (!$error) {
                Notifications::Send($this->GetValue('steamid64_buyer'), 'notification_donation_unrevoked', array('donationid' => $this->GetValue('id'), 'amount' => Settings::Get('settings_donations_currency') . $this->GetValue('amount')), 'index.php?t=home', 'repeat');

                foreach ($packages_bought as $package_bought) {
                    $package = new Package($package_bought['package']);
                    Notifications::Send($package_bought['steamid64'], 'notification_package_reactivated', array('package' => $package_bought['package_name']), 'index.php?t=home', 'unlock-alt');
                }
            }

            return !$error;
        }
    }
