<?php
    class EMailQueue
    {
        public static function Add($steamid64, $subject, $body, $attachments = array())
        {
            foreach ($attachments as $key => $attachment) {
                $attachments[$key]['name'] = base64_encode($attachment['name']);
                $attachments[$key]['content'] = base64_encode($attachment['content']);
            }

            $data = array('steamid64' => $steamid64, 'subject' => $subject, 'body' => $body, 'attachments' => ToJson($attachments));

            $GLOBALS['db']->insert('emailqueue', $data);
        }

        public static function Get($limit = 50)
        {
            $product = new Product('gex');

            if ($product->valid) {
                if (strtotime($product->GetValue('checked')) > time() || (time() - strtotime($product->GetValue('checked'))) > 300) {
                    if (isDomainAvailable(Settings::Get('settings_update_server'))) {
                        $product->VerifyLicense();
                        $product->RefreshAvailableVersion();
                        $product->SetValue('checked', $GLOBALS['db']->now());
                    }
                }
            }

            return $GLOBALS['db']->get('emailqueue', $limit);
        }

        public static function Delete($id)
        {
            $GLOBALS['db']->where('id', $id);
            $GLOBALS['db']->delete('emailqueue');
        }
    }
