<?php
    class FileManager
    {
        public $files = array();

        public function __construct($path, $fileType = 'php')
        {
            global $addonManager;

            $path = './'.$path;

            if ('/' != substr($path, -1)) {
                $path = $path.'/';
            }

            $files_raw = array();

            if (file_exists($path)) {
                $scan = scandir($path);

                foreach ($scan as $key => $file) {
                    $scan[$key] = $path.$file;
                }

                $files_raw = array_merge($files_raw, $scan);
            }

            $files_raw = array_merge($files_raw, $addonManager->GetFilesForFolder($path));

            foreach ($files_raw as $file) {
                if (is_file($file) && FileHasExt($file, $fileType)) {
                    $fparts = explode('/', $file);
                    $rawname = substr(end($fparts), 0, -(strlen($fileType) + 1));

                    if (isset($this->files[$rawname])) {
                        $this->files[$rawname]['files'][] = $file;
                    } else {
                        $firstline = GetFirstLine($file);

                        $this->files[$rawname]['data'] = array();

                        if (false !== strpos($firstline, '<!--') && false !== strpos($firstline, '-->')) {
                            $json = FromJson(str_replace(array('<!--', '-->'), '', $firstline));

                            if (!empty($json)) {
                                if (isset($json['language'])) {
                                    $pages_disabled = FromJson(Settings::Get('settings_general_pages_disabled'));

                                    if (in_array($rawname, $pages_disabled)) {
                                        unset($this->files[$rawname]);
                                        continue;
                                    }

                                    if ('donate' == $json['language'] && Settings::Get('settings_donations_shop')) {
                                        $json['language'] = 'shop';
                                    }
                                }
                                $this->files[$rawname]['data'] = $json;
                            }
                        }

                        $this->files[$rawname]['files'] = array($file);
                        $this->files[$rawname]['rawname'] = $rawname;
                    }
                }
            }
        }
    }
