<?php
    class G2APay
    {
        public static function FormatPrice($price)
        {
            return number_format((float) $price, 2, '.', '');
        }

        public static function GetURL($rest = false)
        {
            if ($rest) {
                return (Settings::Get('settings_donations_g2apay_sandbox') ? 'https://www.test.pay.g2a.com/rest/' : 'https://pay.g2a.com/rest/');
            } else {
                return (Settings::Get('settings_donations_g2apay_sandbox') ? 'https://checkout.test.pay.g2a.com/' : 'https://checkout.pay.g2a.com/');
            }
        }

        public static function CalculateHash($order_id, $amount)
        {
            return hash('sha256', $order_id . G2APay::FormatPrice($amount) . Settings::Get('settings_donations_currency_plain') . Settings::Get('settings_donations_g2apay_secret'));
        }

        public static function CalculateIPNHash($transaction_id, $order_id, $amount)
        {
            return hash('sha256', $transaction_id . $order_id . $amount .  Settings::Get('settings_donations_g2apay_secret'));
        }

        public static function CalculateRESTHash()
        {
            return hash('sha256', Settings::Get('settings_donations_g2apay_apihash') . Settings::Get('settings_donations_g2apay_email') . Settings::Get('settings_donations_g2apay_secret'));
        }

        public static function StartPayment($data)
        {
            $client = new CURLRequester(G2APay::GetURL() . 'index/createQuote', 'POST', true, true);

            Debug('G2APay_StartPayment: ' . ToJson($data));

            $response = $client->request($data);

            Debug('G2APay_StartPayment_Response: ' . ToJson($response));

            if (isset($response['status'])) {
                if ($response['status'] == 'ok') {
                    return G2APay::GetURL() . 'index/gateway?token=' . $response['token'];
                }
            }

            return false;
        }

        public static function GetPaymentData($transaction_id)
        {
            $client = new CURLRequester(G2APay::GetURL(true) . 'transactions/' . $transaction_id, 'GET', true, true);
            $client->addHeader('Authorization', Settings::Get('settings_donations_g2apay_apihash') . ';' . G2APay::CalculateRESTHash());
            $response = $client->request();

            return $response;
        }

        public static function PostProcess($POST)
        {
            $db = MysqliDb::getInstance();

            Debug('G2APay_IPN: ' . ToJson($POST));

            if (isset($POST['userOrderId'])) {
                $payment = Payment::PostProcess($POST['userOrderId']);

                if ($payment) {
                    Debug('Payment found. Payment Hash: ' . $POST['userOrderId']);

                    $buyer = new User($payment['buyer']);
                    $for = new User($payment['for']);
                    $coupon = new Coupon($payment['coupon']);
                    $price = FormatPrice($payment['price']);
                    $package = new Package($payment['package'], null, true, $buyer);

                    if ($buyer->valid && $for->valid && $package->valid && $price) {
                        $hash_should = G2APay::CalculateIPNHash($POST['transactionId'], $POST['userOrderId'], $POST['amount']);

                        if ($hash_should == $POST['hash']) {
                            if (Payment::IsProblematic('g2apay', $POST)) {
                                $db->where("gateway", "g2apay");
                                $db->where("transactionid", $POST['transactionId']);

                                $data = $db->getOne("donations");

                                if ($db->count) {
                                    $donation = new Donation($data['id'], $data);

                                    if (!$donation->GetValue('revoked')) {
                                        $donation->Revoke();

                                        foreach (Permissions::GetSteamIDsWithPermission(true, 'admin_donations') as $steamid64) {
                                            Notifications::Send($steamid64, 'notification_donation_revoked_g2apay', array('donationid' => $donation["id"], 'amount' => Settings::Get('settings_donations_currency') . $donation["amount"]), 'index.php?t=admin_donations&id=' . $donation["id"], 'star');
                                        }
                                    }
                                }
                            } elseif (Payment::Validate('g2apay', array($POST, $package, $price))) {
                                $payment_server = G2APay::GetPaymentData($POST['transactionId']);
                                $amount = FormatPrice($POST['amount']);

                                if (isset($payment_server['amount'])) {
                                    if ($amount == $payment_server['amount']) {
                                        Debug('Payment verified.');

                                        $db->where("transactionid", $POST['transactionId']);
                                        $db->getOne("donations");

                                        if ($db->count) {
                                            Error('TransactionID already proceeded', true);
                                        }

                                        if ($payment['coupon']) {
                                            if ($coupon->valid) {
                                                $coupon->Devaluate();
                                            } else {
                                                Payment::CouponRefund($for, $POST['transactionId'], $amount);
                                                Error('Invalid coupon. Refunding...', true);
                                            }
                                        }

                                        $data = array(
                                            'name_buyer' => $payment_server['customer']['lastName'] . ', ' . $payment_server['customer']['firstName'],
                                            'steamid64_buyer' => $buyer->GetValue('steamid64'),
                                            'steamid64_for' => $for->GetValue('steamid64'),
                                            'amount' => $amount,
                                            'package' => $package->GetValue('id'),
                                            'transactionid' => $POST['transactionId'],
                                            'coupon' => $payment['coupon'],
                                            'email' => '',
                                            'gateway' => 'g2apay'
                                        );

                                        Payment::Finish($data, $buyer, $for, $package, $payment);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
