<?php
    class Gateway extends DBTableClass
    {
        public function __construct($name, $data = null)
        {
            $this->Initialize('gateways', $name, 'name', $data);
        }

        public function Load($package, $for, $coupon, $price_custom)
        {
            global $auth_user;

            $error = Lang('gateway_inactive');

            if (Settings::Get('settings_donations_email_required') && tempty($auth_user->GetValue('email'))) {
                $error = Lang('email_required').': <a data-toggle=modal data-target=#main_modal_settings href=#>'.Lang('settings').'</a>';
            } else {
                if ($this->GetValue('enabled')) {
                    $error = Lang('package_not_buyable');
                    if ($package->Buyable($for, true)) {
                        $price = $package->GetValue('price');

                        $taxes_refresh = false;

                        if ($package->GetValue('price_custom')) {
                            if ($price_custom >= $package->GetValue('price')) {
                                $price = $price_custom;

                                $taxes_refresh = true;
                            }
                        } else {
                            if (Settings::Get('settings_donations_taxes_add')) {
                                if (('paysafecard' == $this->GetValue('name') && !tempty(Paysafecard::GetKey())) || 'coupon' == $this->GetValue('name')) {
                                    $price = FormatPrice($package->taxes['netAmount']);
                                }
                            }
                        }

                        if ($price > 100 && DemoLock()) {
                            $price = 100;
                        }

                        $price = FormatPrice($price);

                        $error = Lang('gateway_not_found');

                        $couponcode = '';

                        if ($coupon->valid) {
                            if ($coupon->GetValue('amount_left') < $price && $coupon->GetValue('amount_left') > 0) {
                                $couponcode = $coupon->GetValue('code');

                                if (!$package->GetValue('price_custom') && Settings::Get('settings_donations_taxes_add')) {
                                    $price = FormatPrice($package->taxes['netAmount'] - $coupon->GetValue('amount_left'));
                                } else {
                                    $price = FormatPrice($price - $coupon->GetValue('amount_left'));
                                }

                                $taxes_refresh = true;
                            }
                        }

                        if ($taxes_refresh) {
                            $package->taxes = GetTaxes($price, (true == $package->GetValue('price_custom')));
                            $price = $package->taxes['total'];
                        }

                        if (('paysafecard' == $this->GetValue('name') && tempty(Paysafecard::GetKey())) || 'coupon' == $this->GetValue('name')) {
                            $package->taxes['taxAmount'] = 0;
                            $package->taxes['taxRate'] = 0;
                        }

                        $payment_id = Payment::PreProcess(array(
                            'buyer' => $auth_user->GetValue('steamid64'),
                            'for' => $for->GetValue('steamid64'),
                            'coupon' => $couponcode,
                            'price' => $price,
                            'price_custom' => $package->GetValue('price_custom'),
                            'package' => $package->GetValue('id'),
                            'package_name' => $package->GetValue('title'),
                            'tax_amount' => $package->taxes['taxAmount'],
                            'tax_rate' => $package->taxes['taxRate'],
                            'tax_note' => $package->taxes['note'],
                            'amount_net' => $package->taxes['netAmount'],
                            'country' => $package->taxes['country'],
                        ));

                        if ('paypal' == $this->GetValue('name')) {
                            $url = 'https://www.paypal.com/cgi-bin/webscr';

                            if (ValidateBool(Settings::Get('settings_donations_paypal_sandbox'))) {
                                $url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
                            }

                            $cmd = Settings::Get('settings_donations_paypal_type');
                            $url_notify = GetCurrentLocation().'request.php?t=ipn_paypal';
                            $url_return = GetCurrentLocation().'index.php?t=purchase&payment_success=paypal';
                            $url_return_cancel = GetCurrentLocation().'index.php?t=purchase&canceled_client&bundle='.$package->GetValue('serverbundle').'&package='.$package->GetValue('id');
                            $communityname = Settings::Get('settings_general_community_name');
                            $email_seller = Settings::Get('settings_donations_paypal_email');

                            $custom = $payment_id;

                            $currency = Settings::Get('settings_donations_currency_plain');

                            $data = array(
                                'cmd' => $cmd,
                                'notify_url' => $url_notify,
                                'return' => $url_return,
                                'cancel_return' => $url_return_cancel,
                                'amount' => $price,
                                'business' => $email_seller,
                                'custom' => $custom,
                                'cpp_logo_image' => 'http://i.imgur.com/BHYVQ3N.png',
                                'cpp_cart_border_color' => '#263B80',
                                'handling' => 0,
                                'currency_code' => $currency,
                                'item_number' => $package->GetValue('id'),
                                'item_name' => $package->GetValue('title'),
                                'no_shipping' => 1,
                                'rm' => 2,
                                'no_node' => 1,
                                'cbt' => 'Return to '.$communityname,
                            );

                            echo '<form method="POST" action="'.$url.'" id="purchase_form_paypal">';
                            foreach ($data as $key => $val) {
                                echo "<input type='hidden' name='".$key."' value='".$val."'>";
                            }
                            echo '</form>';
                            echo "<script>setTimeout(function(){ $('#purchase_form_paypal').submit(); }, 100);</script>";

                            return true;
                        } elseif ('paysafecard' == $this->GetValue('name')) {
                            if (!tempty(Paysafecard::GetKey())) {
                                $pscpayment = new Paysafecard(Paysafecard::GetKey(), Settings::Get('settings_donations_paysafecard_environment'));

                                $gex_paymentid = $payment_id;
                                $currency = Settings::Get('settings_donations_currency_plain');

                                $url_notify = GetCurrentLocation().'request.php?t=ipn_paysafecard&payment_id={payment_id}&gex_payment_id='.$gex_paymentid;
                                $url_return = GetCurrentLocation().'request.php?t=main_paysafecard_success&payment_id={payment_id}&gex_payment_id='.$gex_paymentid;
                                $url_return_cancel = GetCurrentLocation().'index.php?t=purchase&canceled_client&bundle='.$package->GetValue('serverbundle').'&package='.$package->GetValue('id');

                                $response = $pscpayment->createPayment($price, $currency, md5($auth_user->GetValue('steamid64')), GetClientIP(), $url_return, $url_return_cancel, $url_notify);

                                Log::Add('paysafecard', json_encode(array($pscpayment->getRequest(), $pscpayment->getCurl(), $pscpayment->getResponse())));

                                Debug(ToJson($response));

                                if ($response) {
                                    Redirect($response['redirect']['auth_url']);

                                    return true;
                                } else {
                                    $pscerror = $pscpayment->getError()['message'];

                                    if (is_array($pscerror)) {
                                        $error = json_encode($pscerror);
                                    } else {
                                        $error = $pscerror;
                                    }
                                }
                            } else {
                                echo '
                        			<script>
                        				$("#purchase_main").html(`
                        				    <div class="row">
                            					<div class="col-xs-12">
                            						<div class="alert alert-danger" role="alert">'.Lang('psc_info').'</a></div>
                            					</div>
                            				</div>
                            				<div class="row">
                        				        <div class="col-sm-8">
                            						<div class="box">
                            						    <div class="box-header">
                            						        <div class="box-title pull-left">
                            									<p><i class="fa fa-credit-card-alt fa-lg"></i></p>
                            						        	<p><b>Paysafecard</b></p>
                            						        </div>
                            							</div>
                            							<div class="box-content purchase-pins">
                            							    <div class="col-md-12">
                                							    <div style="top: 20px;" class="input-group">
                                                                    <input id="purchase_paysafecard_pins" type="text" class="form-control" placeholder="'.Lang('your_pins').'">
                                                                    <span class="input-group-btn">
                                                                        <button id="purchase_paysafecard_button" onclick="purchase_paysafecard();" class="btn btn-danger" type="button">'.Lang('send').'</button>
                                                                    </span>
                                                                </div>
                            							    </div>
                            						  	</div>
                            						</div>
                            					</div>
                        				        <div class="col-sm-4">
                            						<div class="box">
                            						    <div class="box-header">
                            						        <div class="box-title pull-left">
                            									<p><i class="fa fa-money fa-lg"></i></p>
                            						        	<p><b>'.Lang('payment_details').'</b></p>
                            						        </div>
                            							</div>
                            							<div class="box-content text-center purchase-price">
                            						  		<h2><b>'.Settings::Get('settings_donations_currency').FormatPrice($price).'</b></h2>
                            						  	    <br>
                            						  	</div>
                            						</div>
                            					</div>
                            				</div>
                        				`);
    
                        				$(".purchase-pins").height($(".purchase-price").height());
    
                        				function purchase_paysafecard(){
                            				$.getJSON( "request.php?t=purchase", {
                                            	gateway: "paysafecard",
                                            	pins: $("#purchase_paysafecard_pins").val(),
                                            	payment_id: "'.$payment_id.'"
                                            }).done(function( data ) {
                                                console.log("test");
                                                console.log(data);
                                                if(data["success"]){
                                					$("#purchase_paysafecard_pins").effect("highlight", {color: "#449D44"}, 500);
                                					$("#purchase_paysafecard_button").removeClass("btn-danger");
                                					$("#purchase_paysafecard_button").addClass("btn-success");
                                					$("#purchase_paysafecard_button").html("<span class=\'fa fa-check\'></span>");
                                					$("#purchase_paysafecard_button").attr("disabled","true");
    
                                					setTimeout(function(){
                                			        	$("#purchase_main").html("<b><big><i style=\"color: green;\" class=\"fa fa-check-circle-o\"></i> '.Lang('postpurchase_review').'</big></b><br><br><a class=\"btn btn-primary\" href=\"index.php?t=home\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('dashboard').'</a>");
                                					}, 1500);
                                				}else{
                                					$("#purchase_paysafecard_pins").effect("highlight", {color: "#FC6A6A"}, 500);
                                					new PNotify({title: "'.Lang('error').'", text: data["error"], type: "error"});
                                				}
                                            });
                        				}
                        			</script>
                        		';

                                return true;
                            }
                        } elseif ('payssion' == $this->GetValue('name')) {
                            $methods_f = Payssion::GetPaymentMethods();

                            echo '<script>$("#purchase_main").html(`<center><div class="row"><div class="col-sm-6 col-sm-offset-3"><div class="box">
                        						    <div class="box-header">
                        						        <div class="box-title pull-left">
                        									<p><i class="fa fa-globe fa-lg"></i></p>
                        						        	<p><b>Payssion</b></p>
                        						        </div>
                        							</div>
                        							<div class="box-content purchase-pins"><ul class="nav nav-pills" role="tablist" id="purchase_payssion_method">';

                            $first = true;

                            foreach ($methods_f as $country => $methods) {
                                foreach ($methods as $id => $name) {
                                    $active = '';

                                    if ($first) {
                                        $first = false;
                                        $active = 'active';
                                    }

                                    echo '
                            			<li style="cursor:pointer;width:45%; margin-left: 3.5%; margin-top:10px;" value="'.$id.'" id="" class="purchase_payssion_method '.$active.'">
                            				<a role="tab" data-toggle="tab" aria-expanded="false" id="purchase_payssion_method_'.$id.'">
                            					'.$name.'
                            				</a>
                            			</li>
                            		';
                                }
                            }

                            echo '</ul><br/><br/><button id="purchase_payssion_button" onclick="purchase_payssion();" class="btn btn-danger" type="button">'.Lang('proceed').' <i class="fa fa-long-arrow-right"></i></button><br/><br/></div></div></div></div></center>`);
    
    
                                function purchase_payssion(){
                    				$.getJSON( "request.php?t=purchase", {
                                    	gateway: "payssion",
                                    	payment_id: "'.$payment_id.'",
                                    	method: $(".purchase_payssion_method.active").attr("value")
                                    }).done(function( data ) {
                                        if(data["url"]){
                        					Redirect(data["url"]);
                        				}
                                    }).fail(function( data ) {
                                        data = JSON.parse(data.responseText);
                                    
                        				if(data["error"]){
                        					$("#purchase_payssion_method").effect("highlight", {color: "#FC6A6A"}, 500);
                        					new PNotify({title: "'.Lang('error').'", text: data["error"], type: "error"});
                        				}
                                    });
                				}
                    		</script>
    
                    		';

                            return true;
                        } elseif ('coupon' == $this->GetValue('name')) {
                            $error = Lang('coupon_invalid');
                            $free = false;

                            if ($price <= 0 && '_free' == $coupon->GetValue('code')) {
                                $free = true;
                            }

                            if (($coupon->valid && '' == $couponcode) || $free) {
                                $error = Lang('not_enough_creit');

                                if ($free || $coupon->GetValue('amount_left') >= $price) {
                                    if (!$free) {
                                        $coupon->SetValue('amount_left', $coupon->GetValue('amount_left') - $price);
                                    }

                                    echo '
                            			<script>
                            				$("#purchase_main").html("<b><big><i style=\"color: green;\" class=\"fa fa-check-circle-o\"></i> '.Lang('postpurchase_coupon').'</big></b><br><br><a class=\"btn btn-primary\" href=\"index.php?t=home\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('dashboard').'</a>");
                            			</script>
                            		';

                                    $data = array(
                                        'name_buyer' => $auth_user->GetValue('nick'),
                                        'steamid64_buyer' => $auth_user->GetValue('steamid64'),
                                        'steamid64_for' => $for->GetValue('steamid64'),
                                        'amount' => (Settings::Get('settings_demo') ? $price : 0),
                                        'package' => $package->GetValue('id'),
                                        'transactionid' => $coupon->GetValue('code').'-'.time(),
                                        'coupon' => $coupon->GetValue('code'),
                                        'email' => $auth_user->GetValue('email'),
                                        'gateway' => 'coupon',
                                        'revoked' => 0,
                                    );

                                    if (!Settings::Get('settings_demo')) {
                                        $data['tax_amount'] = 0;
                                        $data['tax_rate'] = 0;
                                    }

                                    Payment::Finish($data, $auth_user, $for, $package);

                                    return true;
                                }
                            }
                        } elseif ('g2apay' == $this->GetValue('name')) {
                            $order_id = $payment_id;

                            $url_failure = GetCurrentLocation().'index.php?t=purchase&canceled_client&bundle='.$package->GetValue('serverbundle').'&package='.$package->GetValue('id');
                            $url_ok = GetCurrentLocation().'index.php?t=purchase&payment_success=g2apay';

                            $data = array(
                                'api_hash' => Settings::Get('settings_donations_g2apay_apihash'),
                                'hash' => G2APay::CalculateHash($order_id, $price),
                                'order_id' => $order_id,
                                'amount' => G2APay::FormatPrice($price),
                                'currency' => Settings::Get('settings_donations_currency_plain'),
                                'url_failure' => $url_failure,
                                'url_ok' => $url_ok,
                                'items' => array(
                                                    array(
                                                        'sku' => $package->GetValue('id'),
                                                        'name' => $package->GetValue('title'),
                                                        'amount' => $price,
                                                        'qty' => 1,
                                                        'id' => $package->GetValue('id'),
                                                        'price' => $price,
                                                        'url' => GetCurrentLocation().'index.php?t=shop&bundle='.$package->GetValue('serverbundle').'&package='.$package->GetValue('id'),
                                                    ),
                                                ),
                            );

                            $url = G2APay::StartPayment($data);

                            if ($url) {
                                Redirect($url);

                                return true;
                            } else {
                                $error = Lang('payment_could_not_initialize');
                            }
                        } elseif ('stripe' == $this->GetValue('name')) {
                            echo '
                                <script>
                                $("#purchase_main").html(`
                                <link rel="stylesheet" href="assets/css/stripe-global.css" />
                                
                                 <center>
                                  <div class="sr-main">
                                    <h3>' . $package->GetValue('title') . '</h3>
                                    <h4>' . $price . ' ' . Settings::Get('settings_donations_currency_plain') . '</h4>
                                    <form id="payment-form" class="sr-payment-form">
                                      <div class="sr-combo-inputs-row">
                                        <div class="sr-input sr-card-element" id="card-element"></div>
                                      </div>
                                      <div class="sr-field-error" id="card-errors" role="alert"></div>
                                      <button id="submit">
                                        <div class="spinner hidden" id="spinner"></div>
                                        <span id="button-text">' . Lang('pay') . '</span><span id="order-amount"></span>
                                      </button>
                                    </form>
                                    <div class="sr-result hidden">
                                       <i style="color: green;" class="fa fa-check-circle fa-5x"></i>
                                    </div>
                                  </div>
                                </center>
                                
                                <script src="https://js.stripe.com/v3/"/>
                                <script src="assets/js/stripe.js"/>`);
       
                                startPayment("'.$payment_id.'", "' . $auth_user->GetValue('language') . '");
                                
                                </script>
                                ';

                            return true;
                        }
                    }
                }
            }

            echo '
    			<script>
    				$("#purchase_main").html("<b><big><i style=\"color: red;\" class=\"fa fa-times-circle-o\"></i> '.Lang('payment_problem').'</b><br><br>'.$error.'</big><br><br><a class=\"btn btn-primary\" onclick=\"window.history.back();\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('back').'</a>");
    			</script>
    		';
        }

        public static function GetAll()
        {
            $db = MysqliDb::getInstance();

            $gateways = array();

            $results = $db->get('gateways');

            foreach ($results as $result) {
                $gw = new Gateway($result['name'], $result);

                if ($gw->valid) {
                    $gateways[] = $gw;
                }
            }

            return $gateways;
        }

        public static function GetTypes()
        {
            return array(
                'paypal' => array(
                    'icon' => 'fa-paypal',
                    'settings' => array(
                        'email' => 'string',
                        'sandbox' => 'boolean',
                        'type' => array('select' => array('_xclick' => 'default', '_donations' => 'donation')),
                    ),
                ),
                'g2apay' => array(
                    'icon' => 'fa-star',
                    'settings' => array(
                        'apihash' => 'string',
                        'email' => 'string',
                        'sandbox' => 'boolean',
                        'secret' => 'string',
                    ),
                ),
                'paysafecard' => array(
                    'icon' => 'fa-credit-card',
                    'settings' => array(
                        'key' => 'string',
                        'sandbox' => 'boolean',
                    ),
                ),
                'payssion' => array(
                    'icon' => 'fa-globe',
                    'settings' => array(
                        'apikey' => 'string',
                        'secretkey' => 'string',
                        'sandbox' => 'boolean',
                        'gateways' => array('multiselect' => Payssion::GetPaymentMethods()),
                    ),
                ),
                'manually' => array(
                    'icon' => 'fa-key',
                    'settings' => array(
                        'min' => 'integer',
                    ),
                ),
            );
        }
    }
