<?php
    class Group extends DBTableClass
    {
        public function __construct($groupname, $data = null)
        {
            $this->Initialize('groups', $groupname, 'groupname', $data, array('permissions', 'settings', 'pagepermissions', 'ts3_servergroups', 'discord_role_ids'));
        }

        public function GetTs3Servergroup($bundle)
        {
            if (isset($this->data['ts3_servergroups'][$bundle]) && !empty($this->data['ts3_servergroups'][$bundle])) {
                return $this->data['ts3_servergroups'][$bundle];
            } else {
                return null;
            }
        }

        public function GetDiscordRole($bundle)
        {
            if (isset($this->data['discord_role_ids'][$bundle]) && !empty($this->data['discord_role_ids'][$bundle])) {
                return $this->data['discord_role_ids'][$bundle];
            } else {
                return '';
            }
        }

        public function GetSetting($key)
        {
            if (isset($this->data['settings'][$key])) {
                return $this->data['settings'][$key];
            } else {
                return false;
            }
        }

        public function AllowPages($pages)
        {
            $this->SetValue('pagepermissions', array_merge($this->GetValue('pagepermissions'), $pages));
        }

        public function SetSetting($key, $value)
        {
            $settings = $this->data['settings'];

            $settings[$key] = $value;

            $this->SetValue('settings', ToJson($settings));
        }

        public function GetMembers($bundle = false, $limit = null, $data = false)
        {
            $db = MysqliDb::getInstance();

            $default = false;

            if (Settings::Get('settings_general_defaultgroup') == $this->GetValue('groupname')) {
                $default = true;
            }

            $groupname = $this->data['groupname'];
            $groupname = str_replace('_', '\_', $groupname);
            $groupname = str_replace('%', '\%', $groupname);

            if (false === $bundle) {
                $db->where("`groups` LIKE CONCAT('%\"', ?, '\"%') ESCAPE '\\\'", array($groupname));
            } else {
                $db->where("`groups` LIKE CONCAT('%', '\"bundle_', ?, '\":\"', ?, '\"%') ESCAPE '\\\'", array($bundle, $groupname));
            }

            if ($default) {
                $db->orWhere("`groups` = '' OR groups = '{}' OR `groups` = '[]'");
            }

            if ($data) {
                $result = $db->get('users', $limit);
            } else {
                $result = $db->getValue('users', 'steamid64', $limit);
            }

            if (null === $result) {
                return array();
            }

            return $result;
        }

        public static function GetAll()
        {
            $db = MysqliDb::getInstance();
            $db->orderBy('level', 'Desc');
            $groups = $db->get('groups');
            $groups_deliver = array();

            foreach ($groups as $group) {
                $groups_deliver[$group['groupname']] = new Group($group['groupname'], $group);
            }

            return $groups_deliver;
        }

        public static function Create($data)
        {
            $db = MysqliDb::getInstance();

            $db->where('groupname', $data['groupname']);
            $groups = $db->get('groups');

            if ($db->count) {
                throw new Exception('GroupCreate_NameAlreadyInUseError');
            }

            $key = $db->insert('groups', $data);
            if ($db->count) {
                return $key;
            } else {
                throw new Exception('GroupCreate_UnknownError');
            }
        }

        public function Update($data)
        {
            $db = MysqliDb::getInstance();

            if (isset($data['groupname'])) {
                unset($data['groupname']);
            }

            $db->where('groupname', $this->GetValue('groupname'));

            if ($db->update('groups', $data)) {
                return true;
            } else {
                return false;
            }
        }

        public function Rename($newgroupname)
        {
            $db = MysqliDb::getInstance();

            $db->where('groupname', $newgroupname);
            $groupname = $db->getValue('groups', 'groupname');

            if (!$db->count || $groupname != $newgroupname) {
                $this->SetValue('groupname', $newgroupname);

                $data = array(
                    'groups' => $db->func('REPLACE(`groups`, ?, ?)', array('"'.$this->GetValue('groupname').'"', '"'.$newgroupname.'"')),
                );

                $db->update('users', $data);

                return true;
            } else {
                return false;
            }
        }

        public function Sync()
        {
            $count = 0;

            foreach (Serverbundle::GetAll(true) as $bundle) {
                $users = $this->GetMembers($bundle->GetValue('id'), null, true);

                foreach ($users as $userdata) {
                    $user = new User($userdata['steamid64'], $userdata);

                    if ($user->valid) {
                        $user->SetGroup($this->GetValue('groupname'), $bundle->GetValue('id'), true);
                        ++$count;
                    }
                }
            }

            return $count;
        }
    }
