<?php
    class LanguageManager extends FileManager
    {
        private $included = array();
        private $language_english = array();

        public function __construct($path)
        {
            parent::__construct($path, 'json');

            global $language;

            $language = array();
        }

        private function IncludeFiles($files)
        {
            global $language;

            foreach ($files as $file) {
                if (!in_array($file, $this->included)) {
                    $this->included[] = $file;

                    $content = file_get_contents($file);
                    $new_language = FromJson($content);

                    $language = array_merge($language, $new_language);
                }
            }
        }

        public function LoadCurrentFiles()
        {
            global $languageManager, $auth_user;

            $languagefiles_current = array();

            if ($auth_user) {
                if (strlen($auth_user->GetValue('language')) > 5) {
                    $auth_user->SetValue('language', Settings::Get('settings_general_defaultlanguage'));
                }

                if (isset($languageManager->files[$auth_user->GetValue('language')])) {
                    $languagefiles_current = $languageManager->files[$auth_user->GetValue('language')]['files'];
                }
            } else {
                if (isset($languageManager->files[Settings::Get('settings_general_defaultlanguage')])) {
                    $languagefiles_current = $languageManager->files[Settings::Get('settings_general_defaultlanguage')]['files'];
                }
            }

            $this->IncludeFiles($languagefiles_current);
        }

        public function GetTranslation($key)
        {
            global $language;

            if (isset($language[$key])) {
                return $language[$key];
            } else {
                if (isset($this->language_english[$key])) {
                    return $this->language_english[$key];
                } else {
                    return '<b><i>'.$key.'</i></b>';
                }
            }
        }

        public function LoadEnglishFiles()
        {
            global $languageManager;

            $languagefiles_english = $languageManager->files['en']['files'];

            $this->IncludeFiles($languagefiles_english);
        }

        public function GetLanguages()
        {
            $files = scandir('language/');
            $langfs = array();

            foreach ($files as $key => $val) {
                if ('.' == $val || '..' == $val) {
                } else {
                    if (FileHasExt($val, 'json') && 7 == strlen($val)) {
                        $lang = substr($val, 0, 2);

                        if (isset($GLOBALS['LANGUAGES'][$lang])) {
                            $langfs[] = $lang;
                        }
                    }
                }
            }

            return $langfs;
            //return array_keys($this->files);
        }

        public function Load()
        {
            foreach ($this->files as $key1 => $files) {
                foreach ($files['files'] as $key2 => $file) {
                    if (StartsWith($file, 'language/')) {
                        if (GetLinesInFile($file) >= 8) {
                            unset($this->files[$key1]['files'][$key2]);
                        }
                    }
                }
            }

            global $language;

            $this->LoadEnglishFiles();

            $this->language_english = $language;

            $this->LoadCurrentFiles();
        }

        public function GetAvailableLanguages()
        {
            $requester = new CURLRequester('https://customercenter.ibot3.de/api.php?t=languagecenter', 'GET', true);
            $availableLanguages = $requester->request(array('product' => 'gex', 'lang' => 'en', 'category' => 'main', 'action' => 'GetAvailableLanguages'), false, 2);

            if (is_array($availableLanguages) && !isset($availableLanguages['error'])) {
                return $availableLanguages;
            } else {
                return array();
            }
        }

        public function DownloadLanguage($lang)
        {
            $requester = new CURLRequester('https://customercenter.ibot3.de/api.php?t=languagecenter', 'GET', true);
            $translations = $requester->request(array('product' => 'gex', 'lang' => $lang, 'category' => 'main', 'action' => 'GetTranslations'), false, 2);

            if ($requester->code == 200 && is_array($translations) && (!in_array('error', array_keys($translations)) || sizeof($translations) > 10)) {
                file_put_contents('language/'.$lang.'.json', SaveCroc(ToJson($translations)));

                return true;
            } else {
                return false;
            }
        }

        public function UpdateLanguages()
        {
            foreach ($this->GetLanguages() as $lang) {
                if (GetLinesInFile('language/'.$lang.'.json') < 8) {
                    $this->DownloadLanguage($lang);
                }
            }
        }
    }
