<?php
    class News extends DBTableClass
    {
        public function __construct($id, $data = null)
        {
            $this->Initialize('news', $id, 'id', $data);
        }
        
        public static function GetAll($active_only = false)
        {
            $db = MysqliDb::getInstance();
            
            $db->orderBy("date", "Desc");
            
            if ($active_only) {
                $db->where("active", 1);
            }
            
            $data = $db->get("news");
            $deliver = array();
            
            foreach ($data as $d) {
                $deliver[$d['id']] = new News($d['id'], $d);
            }

            return $deliver;
        }
        
        public static function Create($title, $content, $active = true, $steamid64 = null)
        {
            $db = MysqliDb::getInstance();
            
            if ($steamid64 === null) {
                global $auth_user;
                
                if ($auth_user) {
                    $steamid64 = $auth_user->GetValue('steamid64');
                } else {
                    return false;
                }
            }
            
            $data = array(
                'title' => $title,
                'content' => $content,
                'active' => ($active ? 1 : 0),
                'steamid64' => $steamid64
            );
            
            $db->insert("news", $data);
            
            return ($db->count > 0);
        }
    }
