<?php
    class Notifications{
        public static function Send($steamid64, $lang, $values_insert, $url, $icon){
            $db = MysqliDb::getInstance();
            
            if($values_insert == null){
                $values_insert = array();
            }

            $data = array(
                'steamid64' => $steamid64,
                'lang' => $lang,
                'values_insert' => json_encode($values_insert),
                'url' => $url,
                'icon' => $icon,
                'seen' => 0,
                'status' => 0
            );
            
            $text = Lang($lang);

            foreach($values_insert as $key => $val){
                $text = str_replace('%' . $key . '%', $val, $text);
            }
            
            $id = $db->insert("notifications", $data);
            
            EmailQueue::Add($steamid64, 'GExtension Notification', Notifications::CreateEmailTemplate($text, $url . '&notification_clicked=' . $id));
        }
        
        public static function GetUnread($view){
            $db = MysqliDb::getInstance();
            
            $db->where("status", 0);
            $db->where("steamid64", $GLOBALS['auth_user']->GetValue("steamid64"));
            $db->orderBy("date", "Desc");
            
            $unread = $db->get("notifications");
            $deliver = array();
            
            foreach($unread as $notification){
                $text = Lang($notification['lang']);
                $values = json_decode($notification['values_insert']);
                
                if(!$values){
                    $values = array();
                }
                
                foreach($values as $key => $val){
                    $text = str_replace('%' . $key . '%', $val, $text);
                }
                
                $deliver[] = array('id' => $notification['id'], 'text' => $text, 'seen' => $notification['seen'], 'url' => $notification['url'], 'icon' => $notification['icon']);
                
                if($view && !$notification['seen']){
                    $data = array('seen' => 1);
                    
                    $db->where("steamid64", $GLOBALS['auth_user']->GetValue("steamid64"));
                    $db->update("notifications", $data);
                }
            }
            return $deliver;
        }
        
        public static function GetAll($results = 15, $page = 1){
            $db = MysqliDb::getInstance();
            
            $db->where("steamid64", $GLOBALS['auth_user']->GetValue("steamid64"));
            $db->orderBy("date", "Desc");
            $db->pageLimit = $results;
            
            $notifications = $db->arraybuilder()->paginate("notifications", $page);
            $deliver = array();
            
            foreach($notifications as $notification){
                $text = Lang($notification['lang']);
                $values = FromJson($notification['values_insert']);

                foreach($values as $key => $val){
                    $text = str_replace('%' . $key . '%', $val, $text);
                }
                
                $deliver[] = array('id' => $notification['id'], 'text' => $text, 'seen' => $notification['seen'], 'url' => $notification['url'], 'icon' => $notification['icon'], 'date' => $notification['date'], 'status' => $notification['status']);
            }
            
            return $deliver;
        }
        
        public static function MarkAllRead(){
            $db = MysqliDb::getInstance();
            
            $db->where("steamid64", $GLOBALS['auth_user']->GetValue("steamid64"));
            
            if($db->update("notifications", array('status' => 1))){
                return true;
            }else{
                return false;
            }
        }
        
        public static function CreateEmailTemplate($text, $url){
            return '<html>
                    <head>    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>Simples-Minimalistic Responsive Template</title><style type="text/css">
                             /* Client-specific Styles */
                             #outlook a {padding:0;} /* Force Outlook to provide a "view in browser" menu link. */
                             body{width:100% !important; -webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; margin:0; padding:0;}
                             /* Prevent Webkit and Windows Mobile platforms from changing default font sizes, while not breaking desktop design. */
                             .ExternalClass {width:100%;} /* Force Hotmail to display emails at full width */
                             .ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div {line-height: 100%;} /* Force Hotmail to display normal line spacing.*/
                             #backgroundTable {margin:0; padding:0; width:100% !important; line-height: 100% !important;}
                             img {outline:none; text-decoration:none;border:none; -ms-interpolation-mode: bicubic;}
                             a img {border:none;}
                             .image_fix {display:block;}
                             p {margin: 0px 0px !important;}
                             table td {border-collapse: collapse;}
                             table { border-collapse:collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; }
                             a {color: #0a8cce;text-decoration: none;text-decoration:none!important;}
                             /*STYLES*/
                             table[class=full] { width: 100%; clear: both; }
                             /*IPAD STYLES*/
                             @media only screen and (max-width: 640px) {
                             a[href^="tel"], a[href^="sms"] {
                             text-decoration: none;
                             color: #0a8cce; /* or whatever your want */
                             pointer-events: none;
                             cursor: default;
                             }
                             .mobile_link a[href^="tel"], .mobile_link a[href^="sms"] {
                             text-decoration: default;
                             color: #0a8cce !important;
                             pointer-events: auto;
                             cursor: default;
                             }
                             table[class=devicewidth] {width: 440px!important;text-align:center!important;}
                             table[class=devicewidthinner] {width: 420px!important;text-align:center!important;}
                             img[class=banner] {width: 440px!important;height:220px!important;}
                             img[class=colimg2] {width: 440px!important;height:220px!important;}
                             
                             
                             }
                             /*IPHONE STYLES*/
                             @media only screen and (max-width: 480px) {
                             a[href^="tel"], a[href^="sms"] {
                             text-decoration: none;
                             color: #0a8cce; /* or whatever your want */
                             pointer-events: none;
                             cursor: default;
                             }
                             .mobile_link a[href^="tel"], .mobile_link a[href^="sms"] {
                             text-decoration: default;
                             color: #0a8cce !important; 
                             pointer-events: auto;
                             cursor: default;
                             }
                             table[class=devicewidth] {width: 280px!important;text-align:center!important;}
                             table[class=devicewidthinner] {width: 260px!important;text-align:center!important;}
                             img[class=banner] {width: 280px!important;height:140px!important;}
                             img[class=colimg2] {width: 280px!important;height:140px!important;}
                             
                            
                             }
                          </style>
                    </head><body><!-- Start of preheader -->
                  
                    <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
                    	<tbody>
                    		<tr>
                    			<td>
                    				<div class="innerbg">
                    				</div>
                    				<table class="devicewidth" align="center" border="0" cellpadding="0" cellspacing="0" width="600">
                    					<tbody>
                    						<tr>
                    							<td width="100%">
                    								<table class="devicewidth" align="center" border="0" cellpadding="0" cellspacing="0" width="600">
                    									<tbody>
                    										<!-- Spacing -->
                    
                    										<tr>
                    											<td style="font-size:1px; line-height:1px; mso-line-height-rule: exactly;" height="20">
                    											</td>
                    										</tr>
                    										<!-- Spacing -->
                    
                    										<tr>
                    											<td>
                    												<table class="devicewidthinner" align="center" border="0" cellpadding="0" cellspacing="0" width="560">
                    													<tbody>
                    														<!-- Title -->
                    
                    														<tr>
                    															<td style="font-family: Helvetica, arial, sans-serif; font-size: 30px; color: #333333; text-align:center; line-height: 30px;">
                    																<p>
                    																	' . (tempty(Settings::Get('settings_general_community_name')) ? 'GExtension' : Settings::Get('settings_general_community_name')) . ' Notification
                    																</p>
                    															</td>
                    														</tr>
                    														
                    														<!-- End of Title -->
                    
                    														<!-- spacing -->
                    
                    														<tr>
                    															<td style="font-size:1px; line-height:1px; mso-line-height-rule: exactly;" height="20" width="100%">
                    															</td>
                    														</tr>
                    														<!-- End of spacing -->
                    
                    														<!-- content -->
                    
                    														<tr>
                    															<td style="font-family: Helvetica, arial, sans-serif; font-size: 16px; color: #666666; text-align:center; line-height: 30px;">
                    																<p>
                    																	You have a new notification.
                    																</p>
                    															</td>
                    														</tr>
                    														<!-- End of content -->
                    
                    													</tbody>
                    												</table>
                    											</td>
                    										</tr>
                    										<!-- Spacing -->
                    
                    										<tr>
                    											<td style="font-size:1px; line-height:1px; mso-line-height-rule: exactly;" height="20">
                    											</td>
                    										</tr>
                    										<!-- Spacing -->
                    
                    									</tbody>
                    								</table>
                    							</td>
                    						</tr>
                    					</tbody>
                    				</table>
                    			</td>
                    		</tr>
                    	</tbody>
                    </table>
                    <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
                    	<tbody>
                    		<tr>
                    			<td>
                    				<div class="innerbg">
                    				</div>
                    				<table class="devicewidth" align="center" border="0" cellpadding="0" cellspacing="0" width="600">
                    					<tbody>
                    						<tr>
                    							<td style="font-size:1px; line-height:1px;" height="30" align="center">
                    							</td>
                    						</tr>
                    						<tr>
                    							<td style="font-size:1px; line-height:1px;" height="1" align="center" bgcolor="#d1d1d1" width="550">
                    							</td>
                    						</tr>
                    						<tr>
                    							<td style="font-size:1px; line-height:1px;" height="30" align="center">
                    							</td>
                    						</tr>
                    					</tbody>
                    				</table>
                    			</td>
                    		</tr>
                    	</tbody>
                    </table>
                    <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
                    	<tbody>
                    		<tr>
                    			<td>
                    				<div class="innerbg">
                    				</div>
                    				<table class="devicewidth" align="center" border="0" cellpadding="0" cellspacing="0" width="600">
                    					<tbody>
                    						<tr>
                    							<td width="100%">
                    								<table class="devicewidth" align="center" border="0" cellpadding="0" cellspacing="0" width="600">
                    									<tbody>
                    										<tr>
                    											<td style="font-family: Helvetica, arial, sans-serif; font-size: 14px;color: #666666" align="center" valign="middle">
                    												<p>
                    													<a href="' . GetCurrentLocation() . $url . '">' . $text . '</a>
                    												</p>
                    											</td>
                    										</tr>
                    										<!-- Spacing -->
                    
                    									</tbody>
                    								</table>
                    							</td>
                    						</tr>
                    					</tbody>
                    				</table>
                    			</td>
                    		</tr>
                    	</tbody>
                    </table>
                    <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
                    	<tbody>
                    		<tr>
                    			<td>
                    				<div class="innerbg">
                    				</div>
                    				<table class="devicewidth" align="center" border="0" cellpadding="0" cellspacing="0" width="600">
                    					<tbody>
                    						<tr>
                    							<td style="font-size:1px; line-height:1px;" height="30" align="center">
                    							</td>
                    						</tr>
                    						<tr>
                    							<td style="font-size:1px; line-height:1px;" height="1" align="center" bgcolor="#d1d1d1" width="550">
                    							</td>
                    						</tr>
                    						<tr>
                    							<td style="font-size:1px; line-height:1px;" height="30" align="center">
                    							</td>
                    						</tr>
                    					</tbody>
                    				</table>
                    			</td>
                    		</tr>
                    	</tbody>
                    </table>
                    <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
                    	<tbody>
                    		<tr>
                    			<td>
                    				<div class="innerbg">
                    				</div>
                    				<table class="devicewidth" align="center" border="0" cellpadding="0" cellspacing="0" width="600">
                    					<tbody>
                    						<tr>
                    							<td width="100%">
                    								<table class="devicewidth" align="center" border="0" cellpadding="0" cellspacing="0" width="600">
                    									<tbody>
                    										<tr>
                    											<td style="font-family: Helvetica, arial, sans-serif; font-size: 10px;color: #666666" align="center" valign="middle">
                    												<p>
                    													GExtension by <a href="http://steamcommunity.com/id/ibot3/">ibot3</a> - Click <a href="' . GetCurrentLocation() . 'index.php?t=home' . '">here</a> to disable E-Mails
                    												</p>
                    											</td>
                    										</tr>
                    										<!-- Spacing -->
                    
                    										<tr>
                    											<td height="20" width="100%">
                    											</td>
                    										</tr>
                    										<!-- Spacing -->
                    
                    									</tbody>
                    								</table>
                    							</td>
                    						</tr>
                    					</tbody>
                    				</table>
                    			</td>
                    		</tr>
                    	</tbody>
                    </table></body>
                    </html>';
        }
        
        public static function Devaluate($id){
            global $auth_user;
            
            $db = MysqliDb::getInstance();
            
			$db->where("steamid64", $auth_user->GetValue('steamid64'));
			$db->where("id", $id);
			$db->update("notifications", array('status' => 1));
        }
    }
?>