<?php
    class Package extends DBTableClass
    {
        public $taxes;

        private function FixHTML()
        {
            $this->data['description'] = trim(preg_replace('/\s+/', ' ', $this->data['description']));
        }

        public function __construct($id, $data = null, $withdiscount = true, $user = null)
        {
            $this->Initialize('packages', $id, 'id', $data);

            if ($this->valid) {
                if ($withdiscount) {
                    $this->data['price'] = $this->GetPriceWithDiscount();
                }

                $this->taxes = GetTaxes($this->data['price'], (true == $this->GetValue('price_custom')), $user);

                $this->data['price'] = $this->taxes['total'];
            }
        }

        public function GetServerbundle()
        {
            $bundle = new Serverbundle($this->data['serverbundle']);

            return $bundle;
        }

        public static function GetAll()
        {
            $db = MysqliDb::getInstance();

            $datas = $db->get('packages');
            $deliver = array();

            foreach ($datas as $data) {
                $deliver[$data['id']] = new Package($data['id'], $data);
            }

            return $deliver;
        }

        public function GetPriceWithDiscount()
        {
            $serverbundle = new Serverbundle($this->GetValue('serverbundle'));

            if ($serverbundle->valid) {
                if ($serverbundle->GetValue('discount')) {
                    return FormatPrice($this->GetValue('price') * (1 - ($serverbundle->GetValue('discount') / 100)));
                }
            }

            return FormatPrice($this->GetValue('price'));
        }

        public function ActivateFor($for, $donationid, $days_custom = -1, $runonetimerewards = true, $import = false)
        {
            $db = MysqliDb::getInstance();

            $days = $this->GetValue('days');

            if ($days_custom >= 0) {
                $days = $days_custom;
            }

            $days_from_upgrade = 0;

            $upgrade_from = json_decode($this->GetValue('upgrade_from'));
            $disable = json_decode($this->GetValue('disable'));

            if (!$upgrade_from) {
                $upgrade_from = array();
            }

            if (!$disable) {
                $disable = array();
            }

            $packages_bought_active = $for->GetPackages(true);

            $todisable = array();

            foreach ($packages_bought_active as $key => $package) {
                if (in_array($package['package'], $upgrade_from)) {
                    $package_upgrade = new Package($package['package']);

                    if ($days > 0) {
                        if ($package['days'] <= 0) {
                            $days = 0;
                        } else {
                            $days_left = floor((strtotime($package['expires']) - time()) / (60 * 60 * 24));

                            $days_from_upgrade = $days_from_upgrade + $days_left;
                        }
                    }

                    if (!$import) {
                        Notifications::Send($for->GetValue('steamid64'), 'notification_package_upgraded', array('package' => $package_upgrade->GetValue('title'), 'package_new' => $this->GetValue('title')), 'index.php?t=home', 'level-up');
                    }

                    $todisable[] = $package['id'];

                    unset($packages_bought_active[$key]);
                }
            }

            foreach ($packages_bought_active as $key => $package) {
                if (in_array($package['package'], $disable)) {
                    $package_disable = new Package($package['package']);

                    if (!$import) {
                        Notifications::Send($for->GetValue('steamid64'), 'notification_package_disabled', array('package' => $package_disable->GetValue('title')), 'index.php?t=home', 'power-off');
                    }

                    $todisable[] = $package['id'];

                    unset($packages_bought_active[$key]);
                }
            }

            $days_total = $days;

            if ($days > 0) {
                $days_total = $days_total + $days_from_upgrade;
            } else {
                $days_from_upgrade = 0;
            }

            $expires = date('Y-m-d H:i:s', strtotime('+'.($days_total).' days'));

            if (!$days_total) {
                $expires = '2037-01-01 00:00:00';
            }

            $data = array(
                'donationid' => $donationid,
                'steamid64' => $for->GetValue('steamid64'),
                'package' => $this->GetValue('id'),
                'package_name' => $this->GetValue('title'),
                'expires' => $expires,
                'days' => $days,
                'days_from_upgrade' => $days_from_upgrade,
                'serverbundle' => $this->GetValue('serverbundle'),
                'status' => 1,
            );

            $package_bought = $db->insert('packages_bought', $data);

            //Set Actions
            $this->AssignRewards($for, $donationid, $expires, $package_bought, $runonetimerewards);

            foreach ($todisable as $pid) {
                Package::Disable($pid, true);
            }

            if (!$import) {
                Notifications::Send($for->GetValue('steamid64'), 'notification_package_activated', array('package' => $this->GetValue('title')), 'index.php?t=home', 'archive');
            }
        }

        public function Buyable($for, $print = false)
        {
            if (Settings::Get('settings_donations_taxes_unknown_block') && $this->taxes['unknown']) {
                if ($print) {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('package_country_notavailable').'", type: "error"');
                }

                return false;
            }

            if ($this->valid) {
                if ($this->GetValue('active')) {
                    $incompatible = FromJson($this->GetValue('incompatible'));
                    $required = FromJson($this->GetValue('required'));

                    if (!$incompatible) {
                        $incompatible = array();
                    }

                    foreach ($for->GetPackages() as $value) {
                        $already_bought = false;

                        if ($value['package'] == $this->GetValue('id')) {
                            if (!$this->GetValue('rebuyable')) {
                                $already_bought = true;
                            } elseif (1 == $this->GetValue('rebuyable')) {
                                if (1 == $value['status'] && strtotime($value['expires']) > time()) {
                                    $already_bought = true;
                                }
                            }
                        }

                        if ($already_bought) {
                            if ($print) {
                                DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('donate_already_bought').'", type: "error"');
                            }

                            return false;
                        }

                        if (1 == $value['status'] && strtotime($value['expires']) > time()) {
                            if (in_array($value['package'], $incompatible)) {
                                if ($print) {
                                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('donate_inompatible').'", type: "error"');
                                }

                                return false;
                            }

                            if (false !== ($key = array_search($value['package'], $required))) {
                                unset($required[$key]);
                            }
                        }
                    }

                    if (!empty($required)) {
                        if ($print) {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('donate_requirements_not_met').'", type: "error"');
                        }

                        return false;
                    }

                    return true;
                }
            }

            return false;
        }

        public function InsertReward($data)
        {
            $db = MysqliDb::getInstance();
            global $AssignRewards_runonetimerewards;

            if (0 == $data['once'] || $AssignRewards_runonetimerewards) {
                $db->insert('rewards', $data);
            }
        }

        private function AssignRewards($for, $donationid, $expires, $package_bought, $runonetimerewards = true)
        {
            $db = MysqliDb::getInstance();
            $GLOBALS['AssignRewards_runonetimerewards'] = $runonetimerewards;

            $donation = new Donation($donationid);

            $rewards = FromJson($this->GetValue('rewards'), true);

            $insert_template = array(
                'steamid64' => $for->GetValue('steamid64'),
                'donationid' => $donationid,
                'package' => $this->GetValue('id'),
                'package_bought' => $package_bought,
                'status' => 0,
                'expires' => $expires,
                'serverbundle' => $this->GetValue('serverbundle'),
                'once' => 0,
                'one_from_all' => 0,
                'executed_on' => '',
                'on_expire' => 0,
                'on_spawn' => 0,
                'on_connect' => 0,
            );

            Rewards::Assign($insert_template, $for, $runonetimerewards, $rewards);

            //Expire Notification
            $data = $insert_template;

            $data['type'] = 'notification_expired';
            $data['value'] = $this->GetValue('title');

            $data['on_expire'] = 1;
            $data['once'] = 1;

            Rewards::Create($data, $runonetimerewards);

            //Donated Message
            if ($donation->valid) {
                if (Settings::Get('settings_donations_donatedmessage') && $donation->GetValue('amount') > 0) {
                    $data = $insert_template;

                    $data['type'] = 'lua';
                    $data['value'] = 'GExtension:PrintToChat(GExtension:FormatString(GExtension:Lang("donations_donated"), {PLAYER:Nick(), [[%amount_donated% '.Settings::Get('settings_donations_currency_plain').']], [[%package_name%]]}))';
                    $data['one_from_all'] = 1;
                    $data['once'] = 1;

                    Rewards::Create($data, $runonetimerewards);
                }
            }
        }

        public static function GetBoughtPackages($limit = -1, $page = 1)
        {
            $db = MysqliDb::getInstance();

            $db->orderBy('activated', 'Desc');

            if ($limit == -1) {
                return $db->get('packages_bought');
            } else {
                $db->pageLimit = $limit;

                $packages_bought = $db->arraybuilder()->paginate('packages_bought', $page);

                return $packages_bought;
            }
        }

        public static function GetBoughtPackagesByUser($steamid64)
        {
            $db = MysqliDb::getInstance();

            $db->orderBy('activated', 'Desc');
            $db->where('steamid64', $steamid64);
            $packages_bought = $db->get('packages_bought');

            return $packages_bought;
        }

        public static function Disable($package_bought, $ignore_onetime)
        {
            $db = MysqliDb::getInstance();

            $db->where('id', $package_bought);
            $db->update('packages_bought', array('status' => 0));

            if ($ignore_onetime) {
                $db->where('package_bought = ? AND (once = 0 OR on_expire = 1)', array($package_bought));
            } else {
                $db->where('package_bought', $package_bought);
            }

            $db->update('rewards', array('status' => 2));

            return true;
        }

        public static function Enable($package_bought)
        {
            $db = MysqliDb::getInstance();

            $db->where('id', $package_bought);
            $db->update('packages_bought', array('status' => 1));

            $db->where('package_bought', $package_bought);
            $db->where('status', 2);
            $db->update('rewards', array('status' => 0));

            return true;
        }

        public static function Create($data)
        {
            $db = MysqliDb::getInstance();

            $key = $db->insert('packages', $data);
            if ($db->count) {
                return $key;
            } else {
                return false;
            }
        }

        public static function GetCategories($bundle = null)
        {
            $db = MysqliDb::getInstance();

            $categories = array();

            $result = $db->rawQuery("SELECT DISTINCT category FROM gex_packages WHERE category <> ''".($bundle ? ' AND serverbundle = '.$bundle : '').';');

            foreach ($result as $row) {
                $categories[] = $row['category'];
            }

            return $categories;
        }

        public static function GeneratePackageListForUser($user)
        {
            global $auth_user;

            $detailsAccess = Permissions::HasPagePermission('admin_donations') || (null != $auth_user && $auth_user->GetValue('steamid64') == $user->GetValue('steamid64'));

            $donations_data = array();

            $packages_bought = Package::GetBoughtPackagesByUser($user->GetValue('steamid64'));

            echo '<ul class="list-group" >';

            foreach ($packages_bought as $package_bought) {
                $donation = new Donation($package_bought['donationid']);

                $amount = 0;
                $gateway = '';
                $steamid64_buyer = '';
                $nick_buyer = '';
                $revoked = 0;
                $id = '';

                if ($donation->valid) {
                    $amount = $donation->GetValue('amount');

                    $gateway_obj = new Gateway($donation->GetValue('gateway'));

                    if ($gateway_obj->valid) {
                        $gateway = $gateway_obj->GetValue('name');
                    }

                    $id = $donation->GetValue('id');

                    $buyer = new User($donation->GetValue('steamid64_buyer'));

                    if ($buyer->valid) {
                        $steamid64_buyer = $buyer->GetValue('steamid64');
                        $nick_buyer = $buyer->GetValue('nick');
                    }

                    $revoked = $donation->GetValue('revoked');
                }

                $expired = false;

                if (strtotime($package_bought['expires']) < time()) {
                    $expired = true;
                }

                if ($package_bought) {
                    $serverbundle = new Serverbundle($package_bought['serverbundle']);

                    $serverbundle_name = '?';
                    $serverbundle_color = '#555';

                    if ($serverbundle->valid) {
                        $serverbundle_name = $serverbundle->GetValue('name');
                        $serverbundle_color = $serverbundle->GetValue('hexcolor');
                    } else {
                        $serverbundle_name = '('.$package_bought['serverbundle'].')';
                    }

                    $info = array(
                        'id' => $id,
                        'package_bought_id' => $package_bought['id'],
                        'amount' => FormatPrice($amount).' '.Settings::Get('settings_donations_currency_plain'),
                        'package' => $package_bought['package'],
                        'package_name' => RemoveQuotes($package_bought['package_name']),
                        'steamid64_buyer' => $steamid64_buyer,
                        'nick_buyer' => $nick_buyer,
                        'date' => FormatDate($package_bought['activated']),
                        'expires' => FormatDate($package_bought['expires']),
                        'expired' => $expired,
                        'days' => $package_bought['days'],
                        'days_from_upgrade' => $package_bought['days_from_upgrade'],
                        'serverbundle_name' => $serverbundle_name,
                        'serverbundle' => $package_bought['serverbundle'],
                        'gateway' => ucfirst($gateway),
                        'revoked' => $revoked,
                        'status' => $package_bought['status'],
                    );

                    if (!$detailsAccess) {
                        if (Settings::Get('settings_donations_details_not_public')) {
                            $info['gateway'] = '';
                            $info['amount'] = '';
                            $info['steamid64_buyer'] = '';
                            $info['nick_buyer'] = '';
                        }

                        if ($revoked) {
                            continue;
                        }
                    }

                    $class = '';

                    if (1 != $package_bought['status']) {
                        $class = 'striked';
                    }

                    $donations_data[$package_bought['id']] = $info;

                    echo '
						<li class="list-group-item clickable" onclick="class_package_details(donations_data['.$package_bought['id'].']);" style="border-radius: 0px;">
							<span class="'.$class.'">
						';
                    if ($revoked) {
                        echo '<font color="red"><i class="fa fa-exclamation-triangle"></i></font> ';
                    }

                    if ($expired && $package_bought['days']) {
                        echo '<font color="red">'.$package_bought['package_name'].'</font>';
                    } else {
                        echo $package_bought['package_name'];
                    }

                    echo '</span><span style="background-color: '.$serverbundle_color.';" class="badge">'.$serverbundle_name.'</span>

						</li>
					';
                }
            }

            echo '</ul>';

            echo '
  			    <!-- PackageDetails Modal -->
                <div class="modal fade" id="class_package_modal_details" tabindex="-1" role="dialog" aria-hidden="true">
                	<div class="modal-dialog">
                		<div class="modal-content">
                			<div class="modal-header">
                				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
                				<h4 class="modal-title"><i class="fa fa-archive"></i> &nbsp;'.Lang('package_details').'</h4>
                			</div>

                			<div class="modal-body">
                				<table class="table table-responsive table-bordered table-striped">
                					<tr>
                						<td>'.Lang('purchase_id').':</td>
                						<td id="class_package_modal_details_detail_id"></td>
                					</tr>
                					<tr>
                						<td>'.Lang('amount').':</td>
                						<td id="class_package_modal_details_detail_amount"></td>
                					</tr>
                					<tr>
                						<td>'.Lang('buyer').':</td>
                						<td id="class_package_modal_details_detail_buyer"></td>
                					</tr>
                					<tr>
                						<td>'.Lang('date').':</td>
                						<td id="class_package_modal_details_detail_date"></td>
                					</tr>
                					<tr>
                						<td>'.Lang('serverbundle').':</td>
                						<td id="class_package_modal_details_detail_serverbundle"></td>
                					</tr>
                					<tr>
                						<td>'.Lang('package').':</td>
                						<td id="class_package_modal_details_detail_package"></td>
                					</tr>
                					<tr>
                						<td>'.Lang('gateway').':</td>
                						<td id="class_package_modal_details_detail_gateway"></td>
                					</tr>
                					<tr>
                						<td>'.Lang('days').':</td>
                						<td id="class_package_modal_details_detail_days"></td>
                					</tr>
                					<tr>
                						<td>'.Lang('expires').':</td>
                						<td id="class_package_modal_details_detail_expires"></td>
                					</tr>
                				</table>

                				<div id="class_package_modal_details_revoked">

                				</div>
                			</div>

                			<div class="modal-footer" id="class_package_modal_details_footer">

                			</div>
                		</div>
                	</div>
                </div>
            ';

            echo '
                <script>
                var donations_data = {};
	        ';

            foreach ($donations_data as $key => $val) {
                echo 'donations_data['.$key.'] = '.ToJson($val).';';
            }

            echo "
                    function class_package_details(info){
                        $('#class_package_modal_details_detail_id').parent().show();
            			$('#class_package_modal_details_detail_amount').parent().show();
            			$('#class_package_modal_details_detail_gateway').parent().show();
            			$('#class_package_modal_details_detail_buyer').parent().show();
                    
                		if(info['gateway'] == ''){
                			$('#class_package_modal_details_detail_id').parent().hide();
                			$('#class_package_modal_details_detail_amount').parent().hide();
                			$('#class_package_modal_details_detail_gateway').parent().hide();
                			$('#class_package_modal_details_detail_buyer').parent().hide();
                		}else{
                			$('#class_package_modal_details_detail_id').html('<a target=\"_blank\" href=\"index.php?t=admin_donations&id=' + info['id'] + '\">#' + info['id'] + '</a>');
                		}
                		
                		if(info['id'] != ''){
                		    ".($detailsAccess && Settings::Get('settings_donations_invoices') ? "$('#class_package_modal_details_footer').html('<a target=\"_blank\" href=\"index.php?t=invoice&id=' + info['id'] + '\"><button class=\"btn btn-info btn-simple\"><i class=\"fa fa-file-pdf-o\"></i> ".Lang('invoice')."</button></a>');" : '')."
                        }else{
                            $('#class_package_modal_details_footer').html('');
                        }

                		$('#class_package_modal_details_detail_amount').html(info['amount']);
                		$('#class_package_modal_details_detail_date').html(info['date']);
                		$('#class_package_modal_details_detail_gateway').html(info['gateway']);
                		$('#class_package_modal_details_detail_serverbundle').html(info['serverbundle_name']);
                		$('#class_package_modal_details_detail_buyer').html('<a target=\"_blank\" href=\"index.php?t=user&id=' + info['steamid64_buyer'] + '\">' + info['nick_buyer'] + '</a>');
                		$('#class_package_modal_details_detail_package').html('<a target=\"_blank\" href=\"index.php?t=shop&bundle=' + info['serverbundle'] + '&package=' + info['package'] + '\">' + info['package_name'] + '</a>');

                		if(info['days'] > 0){
                			$('#class_package_modal_details_detail_days').html(info['days']);
                			if(info['days_from_upgrade'] > 0){
                				$('#class_package_modal_details_detail_days').append(' (+' + info['days_from_upgrade'] + ')');
                			}

                			$('#class_package_modal_details_detail_expires').html(info['expires']);

                			if(info['expired']){
                				$('#class_package_modal_details_detail_expires').append(' <font color=\"red\">(".Lang('reached').")</font>');
                			}
                		}else{
                			$('#class_package_modal_details_detail_days').html('<i class=\"text-muted\">".Lang('permanent')."</i>');
                			$('#class_package_modal_details_detail_expires').html('<i class=\"text-muted\">".Lang('permanent')."</i>');
                		}

                		if(info['revoked']){
                			$('#class_package_modal_details_revoked').html(`
                				<div class=\"alert alert-danger\" role=\"alert\">".Lang('donation_hasbeen_revoked')."</div>
                			`);
                		}else{
                			$('#class_package_modal_details_revoked').html(``);
                		}

                		$('#class_package_modal_details').modal('show');
                	}
                </script>
  			";
        }
    }
