<?php
    class Payment
    {
        public static function IsProblematic($gateway, $POST)
        {
            if ('paypal' == $gateway) {
                if ('Reversed' == $POST['payment_status']) {
                    $problematic_codes = array(
                        'refund',
                        'chargeback',
                        'unauthorized_claim',
                        'unauthorized_spoof',
                        'buyer-complaint',
                    );

                    return in_array($POST['reason_code'], $problematic_codes);
                }
            } elseif ('g2apay' == $gateway) {
                if ('refunded' == $POST['status'] || 'partial_refunded' == $POST['status']) {
                    return true;
                }
            } elseif ('payssion' == $gateway) {
                $state = $POST;

                $problematic_states = array(
                    'refunded',
                    'chargeback',
                );

                return in_array($state, $problematic_states);
            }

            return false;
        }

        public static function Finish($data, $buyer, $for, $package, $payment = false, $import = false, $runonetimerewards = true)
        {
            $db = MysqliDb::getInstance();

            $data['amount'] = FormatPrice($data['amount']);
            $data['revoked'] = 0;
            $data['country'] = $package->taxes['country'];
            $data['package_name'] = $package->GetValue('title');
            $data['tax_amount'] = 0;
            $data['tax_rate'] = 0;
            $data['price_custom'] = 0;
            $data['amount_net'] = $data['amount'];
            $data['tax_note'] = '';
            $data['invoice'] = '';
            $data['country'] = '';
            $data['api_notified'] = 0;

            if(!isset($data['email']) || $data['email'] === '') {
                $data['email'] = $buyer->GetValue('email');
            }

            if(isset($payment['country'])){
                $data['country'] = $payment['country'];
            }

            if(isset($payment['price_custom'])){
                $data['price_custom'] = $payment['price_custom'];
            }

            if ($payment) {
                if (isset($payment['tax_amount']) && isset($payment['tax_rate']) && isset($payment['amount_net'])) {
                    $data['tax_amount'] = $payment['tax_amount'];
                    $data['tax_rate'] = $payment['tax_rate'];
                    $data['tax_note'] = $payment['tax_note'];
                    $data['amount_net'] = $payment['amount_net'];
                }
            }

            $donationid = $db->insert('donations', $data);

            if ($db->getLastErrno() !== 0)
                Debug($db->getLastError());

            $package->ActivateFor($for, $donationid, -1, $runonetimerewards, $import);

            if (!$import) {
                foreach (Permissions::GetSteamIDsWithPermission(true, 'admin_donations') as $steamid64) {
                    Notifications::Send($steamid64, 'notification_new_donation', array('donator' => $buyer->GetValue('nick'), 'price' => Settings::Get('settings_donations_currency').$data['amount'], 'package' => $package->GetValue('title')), 'index.php?t=admin_donations&id='.$donationid, 'money');
                }
            }

            if (Settings::Get('settings_donations_email_enabled')) {
                $attachments = array();

                $attachments_raw = FromJson(Settings::Get('settings_donations_email_attachments'));

                $html = '<html><head><meta charset="utf-8"></head><body>%content%</body></html>';

                foreach ($attachments_raw as $attachment) {
                    if ('tos' == $attachment) {
                        $attachments[] = array('name' => Lang('tos').'.html', 'content' => str_replace('%content%', Settings::Get('settings_general_tos'), $html));
                    }

                    if ('cancellation_terms' == $attachment) {
                        $attachments[] = array('name' => Lang('cancellation_terms').'.html', 'content' => str_replace('%content%', Settings::Get('settings_donations_cancellation_terms'), $html));
                    }
                }

                $content = Settings::Get('settings_donations_email_content');

                $content = str_replace('%nick%', $buyer->GetValue('nick'), $content);
                $content = str_replace('%package_name%', $package->GetValue('title'), $content);
                $content = str_replace('%amount%', Settings::Get('settings_donations_currency').$data['amount'], $content);
                $content = str_replace('%invoice_url%', GetCurrentLocation() . 'index.php?t=invoice&id=' . $donationid, $content);

                EmailQueue::Add($buyer->GetValue('steamid64'), Settings::Get('settings_donations_email_subject'), $content, $attachments);
                //->SendEmail(Settings::Get('settings_donations_email_subject'), $content, $attachments);
            }

            $url = Settings::Get('settings_donations_invoice_api');

            if(!tempty($url)) {
                $donation = new Donation($donationid);

                if($donation->valid){
                    Debug('Trying to notify invoicing API about payment ' . $donationid);

                    if(Payment::NotifyInvoicingAPI($url, $donation->data, $buyer, $package) !== false){
                        $donation->SetValue('api_notified', 1);
                    }
                }
            }

            if ($donationid) {
                return true;
            } else {
                return false;
            }
        }

        public static function Validate($gateway, $args)
        {
            $db = MysqliDb::getInstance();

            if ('paypal' == $gateway) {
                $POST = $args[0];
                $package = $args[1];
                $price_should = $args[2];

                $success = 0;

                if (strtolower(Settings::Get('settings_donations_paypal_email')) == (strtolower($POST['receiver_email']) || strtolower($POST['business']))) {
                    if ('echeck' != $_POST['payment_type'] && $POST['mc_currency'] == Settings::Get('settings_donations_currency_plain') && 'Completed' == $POST['payment_status']) {
                        if (($POST['mc_gross'] == $price_should) || ($package->GetValue('price_custom') && $POST['mc_gross'] >= $package->GetValue('price'))) {
                            $success = 1;
                        }
                    }
                }

                $data = array(
                    'request' => json_encode($POST),
                    'price' => $POST['mc_gross'],
                    'price_should' => $price_should,
                    'price_custom' => $package->GetValue('price_custom'),
                    'success' => $success,
                );

                $db->insert('ipn_paypal', $data);

                if ($success) {
                    return true;
                } else {
                    return false;
                }
            } elseif ('paysafecard' == $gateway) {
                $response = $args[0];
                $package = $args[1];
                $price_should = $args[2];

                $success = 0;

                if ($response['currency'] == Settings::Get('settings_donations_currency_plain') && 'SUCCESS' == $response['status']) {
                    if (($response['amount'] == $price_should) || ($package->GetValue('price_custom') && $response['amount'] >= $package->GetValue('price'))) {
                        $success = 1;
                    }
                }

                $data = array(
                    'request' => ToJson($response),
                    'price' => $response['amount'],
                    'price_should' => $price_should,
                    'price_custom' => $package->GetValue('price_custom'),
                    'success' => $success,
                );

                $db->insert('ipn_paysafecard', $data);

                if ($success) {
                    return true;
                } else {
                    return false;
                }
            } elseif ('g2apay' == $gateway) {
                $POST = $args[0];
                $package = $args[1];
                $price_should = $args[2];

                $success = 0;

                if ('payment' == $POST['type']) {
                    if ($POST['currency'] == Settings::Get('settings_donations_currency_plain')) {
                        if ('complete' == $POST['status']) {
                            if (($POST['amount'] == $price_should) || ($package->GetValue('price_custom') && $POST['amount'] >= $package->GetValue('price'))) {
                                $success = 1;
                            }
                        }
                    }
                }

                $data = array(
                    'request' => ToJson($POST),
                    'amount' => $POST['amount'],
                    'price_should' => $price_should,
                    'price_custom' => $package->GetValue('price_custom'),
                    'success' => $success,
                );

                $db->insert('ipn_g2apay', $data);

                if ($success) {
                    return true;
                } else {
                    return false;
                }
            } elseif ('payssion' == $gateway) {
                //$amount, $currency, $state, $package, $price
                $amount = $args[0];
                $currency = $args[1];
                $state = $args[2];
                $package = $args[3];
                $price_should = $args[4];
                $POST = $args[5];

                if ($currency == Settings::Get('settings_donations_currency_plain')) {
                    if ('completed' == $state) {
                        if (($amount == $price_should) || ($package->GetValue('price_custom') && $amount >= $package->GetValue('price'))) {
                            $success = 1;
                        }
                    }
                }

                $data = array(
                    'request' => ToJson($POST),
                    'amount' => $amount,
                    'price_should' => $price_should,
                    'price_custom' => $package->GetValue('price_custom'),
                    'success' => $success,
                );

                $db->insert('ipn_payssion', $data);

                if ($success) {
                    return true;
                } else {
                    return false;
                }
            }

            return false;
        }

        public static function PreProcess($data)
        {
            $db = MysqliDb::getInstance();

            $data = json_encode($data);

            $hash = hash('sha1', $data.rand().time());

            $db->insert('payments', array('hash' => $hash, 'data' => $data));

            return $hash;
        }

        public static function PostProcess($hash)
        {
            $db = MysqliDb::getInstance();

            $db->where('hash', $hash);

            return FromJson($db->getValue('payments', 'data'));
        }

        public static function CouponRefund($for, $transaction_id, $amount)
        {
            $code = strtoupper($transaction_id);

            $coupon = new Coupon($code, true);

            if (!$coupon->valid) {
                if (Coupon::Create($code, $amount)) {
                    Notifications::Send($for->GetValue('steamid64'), 'notification_package_failed_coupon', array('coupon' => $code, 'amount' => Settings::Get('settings_donations_currency').FormatPrice($amount)), 'index.php?t=shop', 'times');
                }
            }
        }

        public static function NotifyInvoicingAPI($url, $donation, $buyer, $package, $timeout = 5){
            $data = array(
                'id' => $donation['id'],
                'date' => $donation['date'],
                'currency' => Settings::Get('settings_donations_currency_plain'),
                'payment' => array(
                    'amount_total' => $donation['amount'],
                    'amount_net' => $donation['amount_net'],
                    'gateway' => $donation['gateway'],
                    'transaction_id' => $donation['transactionid'],
                ),
                'buyer' => array(
                    'steamid64' => $buyer->GetValue('steamid64'),
                    'nick' => $buyer->GetValue('nick'),
                    'address' => $donation['name_buyer'],
                    'country' => $donation['country'],
                    'email' => $donation['email']
                ),
                'product' => array(
                    'id' => $package->GetValue('id'),
                    'serverbundle' => $package->GetValue('serverbundle'),
                    'name' => $package->GetValue('title'),
                    'days' => $package->GetValue('days'),
                ),
                'tax' => array(
                    'note' => $donation['tax_note'],
                    'rate' => $donation['tax_rate'],
                    'amount' => $donation['tax_amount'],
                )
            );

            $requester = new CURLRequester($url, 'POST', false, true);
            return $requester->request($data, false, $timeout);
        }
    }
