<?php
    class Permissions
    {
        public static function HasPagePermission($rawname, $target = null)
        {
            global $auth_user;

            if (!$auth_user && null == $target) {
                return false;
            }

            $group = null;

            if (null == $target) {
                $group = $auth_user->GetGroup();
            } elseif ('Group' == get_class($target)) {
                $group = $target;
            } elseif ('User' == get_class($target)) {
                $group = $target->GetGroup();
            }

            if ($group->valid) {
                if (Permissions::HasPermission('super', $group)) {
                    return true;
                }

                return in_array($rawname, $group->GetValue('pagepermissions'));
            } else {
                return false;
            }
        }

        public static function HasPermission($permission, $target = null)
        {
            global $auth_user;

            if (!$auth_user && null == $target) {
                return false;
            }

            Permissions::Add($permission);

            $group = null;

            if (null == $target) {
                $group = $auth_user->GetGroup();
            } elseif ('Group' == get_class($target)) {
                $group = $target;
            } elseif ('User' == get_class($target)) {
                $group = $target->GetGroup();
            }

            if ($group->valid) {
                if (in_array('super', $group->GetValue('permissions'))) {
                    return true;
                }

                return in_array($permission, $group->GetValue('permissions'));
            } else {
                return false;
            }
        }

        public static function GetAll()
        {
            $db = MysqliDb::getInstance();

            $db->orderBy('permission', 'asc');
            $result = $db->getValue('permissions', 'permission', null);

            if ($db->count) {
                return $result;
            } else {
                return array();
            }
        }

        public static function GetSteamIDsWithPermission($pagemermission, $permission)
        {
            $steamids_hasperm = array();

            foreach (Group::GetAll() as $group) {
                if ($pagemermission) {
                    if (Permissions::HasPagePermission($permission, $group)) {
                        $steamids = $group->GetMembers(0);

                        if ($steamids) {
                            $steamids_hasperm = array_merge($steamids_hasperm, $steamids);
                        }
                    }
                } else {
                    if (Permissions::HasPermission($permission, $group)) {
                        $steamids = $group->GetMembers(0);

                        if ($steamids) {
                            $steamids_hasperm = array_merge($steamids_hasperm, $steamids);
                        }
                    }
                }
            }

            return $steamids_hasperm;
        }

        public static function Add($permission)
        {
            $db = MysqliDb::getInstance();

            $db->where('permission', $permission);
            $db->get('permissions');

            if (0 === $db->count) {
                $db->insert('permissions', array('permission' => $permission));
            }
        }

        public static function Remove($permission)
        {
            $db = MysqliDb::getInstance();

            $db->where('permission', $permission);

            $db->delete('permissions');
        }

        public static function AllowPagesForEveryone()
        {
            foreach (Group::GetAll() as $group) {
                $group->AllowPages(func_get_args());
            }
        }
    }
