<?php
    class Product extends DBTableClass
    {
        public function __construct($name, $data = null)
        {
            $this->Initialize('products', $name, 'name', $data);
        }

        public function UpdateFiles()
        {
            $db = MysqliDb::getInstance();

            $success = false;

            $this->VerifyLicense();
            $this->RefreshAvailableVersion();

            CreateDirectory('updates');

            if ($this->GetValue('valid') && !$this->GetValue('noconnection') && strlen($this->GetValue('version_available')) <= 8) {
                $renew = false;

                if ($this->GetValue('version_available') == $this->GetValue('version_installed')) {
                    $renew = true;
                }

                $request = new CURLRequester(Settings::Get('settings_update_server'), 'GET', false);
                $response = $request->request(
                    array(
                        'action' => 'update',
                        'platform' => 'web',
                        'license' => $this->GetValue('license'),
                        'product' => $this->GetValue('name'),
                    )
                );

                if ($response) {
                    $path = 'updates/'.$this->GetValue('name').'_v'.$this->GetValue('version_available').'_web.zip';

                    $file = fopen($path, 'w+');
                    fputs($file, $response);
                    fclose($file);

                    $newfiles = new ZipArchive();
                    if (true === $newfiles->open($path)) {
                        if ($newfiles->extractTo('.')) {
                            $success = true;
                        }

                        $newfiles->close();
                    }
                }

                $todelete = glob('updates/*');
                foreach ($todelete as $todelete_file) {
                    if (is_file($todelete_file)) {
                        unlink($todelete_file);
                    }
                }
            }

            return $success;
        }

        public function FinishUpdate()
        {
            global $languageManager, $addonManager;

            $success = false;

            if ('gex' == $this->GetValue('name')) {
                if (function_exists('Install')) {
                    die('<br/><br/>ERROR!!! Can not update two addons/products in one request!');
                }

                if (file_exists('assets/php/gex_install.php')) {
                    include 'assets/php/gex_install.php';

                    if (function_exists('Install')) {
                        $success = Install();
                    }
                }
            } else {
                if ($addonManager && 'AddonManager' == get_class($languageManager)) {
                    $success = $addonManager->Install($this->GetValue('name'));
                }
            }

            if ($languageManager && 'LanguageManager' == get_class($languageManager)) {
                $languageManager->UpdateLanguages();
            }

            $this->SetValue('version_installed', $this->GetValue('version_available'));
            $this->SetValue('updatenotification_sent', 0);

            return $success;
        }

        public function GetLuaDownload()
        {
            return  Settings::Get('settings_update_server').'?action=update&platform=lua&license='.$this->GetValue('license').'&product='.$this->GetValue('name');
        }

        public function GetChangelogURL()
        {
            return  Settings::Get('settings_update_server').'?action=changelog&product='.$this->GetValue('name');
        }

        public function GetAgreementURL()
        {
            return  Settings::Get('settings_update_server').'?action=agreement&product='.$this->GetValue('name');
        }

        public function VerifyLicense()
        {
            $db = MysqliDb::getInstance();

            $request = new CURLRequester(Settings::Get('settings_update_server'), 'GET', true);
            $response = $request->request(
                array(
                    'action' => 'license',
                    'license' => $this->GetValue('license'),
                    'hostname' => GetCurrentLocation(),
                    'product' => $this->GetValue('name'),
                ),
                false,
                5
            );

            $noconnection = false;

            if ($response) {
                if (isset($response['success'])) {
                    ReloadProduct(true);

                    $this->SetValue('valid', 1);
                } elseif (isset($response['error'])) {
                    if ('invalid license' == $response['error']) {
                        $this->SetValue('valid', 0);
                    } else {
                        $noconnection = true;
                    }
                } else {
                    $noconnection = true;
                }
            }

            if ($noconnection) {
                $this->SetValue('noconnection', 1);
            } else {
                $this->SetValue('noconnection', 0);
            }
        }

        public function RegisterLicense()
        {
            $db = MysqliDb::getInstance();

            $request = new CURLRequester(Settings::Get('settings_update_server'), 'GET', true);
            $response = $request->request(
                array(
                    'action' => 'license_register',
                    'license' => $this->GetValue('license'),
                    'product' => $this->GetValue('name'),
                ),
                false,
                5
            );

            $noconnection = false;

            if ($response) {
                if (isset($response['success'])) {
                    ReloadProduct(true);

                    $this->SetValue('valid', 1);
                } elseif (isset($response['error'])) {
                    $this->SetValue('valid', 0);
                } else {
                    $noconnection = true;
                }
            }

            if ($noconnection) {
                $this->SetValue('noconnection', 1);
            } else {
                $this->SetValue('noconnection', 0);
            }
        }

        public function RefreshAvailableVersion()
        {
            $db = MysqliDb::getInstance();

            $request = new CURLRequester(Settings::Get('settings_update_server'), 'GET', false);
            $response = $request->request(
                array(
                    'action' => 'version',
                    'license' => $this->GetValue('license'),
                    'product' => $this->GetValue('name'),
                ),
                false,
                5
            );

            $checked = false;

            if ($response) {
                $version = $response;

                if (strlen($version) <= 8) {
                    $checked = true;
                    $this->SetValue('version_available', $version);
                }
            }

            if (!$checked) {
                $this->SetValue('noconnection', 1);
            } else {
                $this->SetValue('noconnection', 0);

                if (class_exists('Notifications')) {
                    if (!$this->GetValue('updatenotification_sent')) {
                        if (version_compare($this->GetValue('version_available'), $this->GetValue('version_installed'), '>')) {
                            foreach (Permissions::GetSteamIDsWithPermission(false, 'settings_update') as $steamid64) {
                                Notifications::Send($steamid64, 'notification_update_available', array('product' => $this->GetValue('name'), 'version_available' => $this->GetValue('version_available')), 'index.php?t=admin_settings&part=update', 'refresh');
                            }

                            $this->SetValue('updatenotification_sent', 1);
                        }
                    }
                }
            }
        }

        public static function Add($name, $license)
        {
            $db = MysqliDb::getInstance();

            $data = array(
                'name' => $name,
                'license' => $license,
                'version_installed' => 0,
                'version_available' => 0,
                'updatenotification_sent' => 0,
                'noconnection' => 1,
                'valid' => 0,
            );

            $db->insert('products', $data);

            $ok = false;

            $product = new Product($name);

            if ($product->valid) {
                $product->RegisterLicense();
                $product->VerifyLicense();
                $product->RefreshAvailableVersion();

                if ($product->GetValue('valid')) {
                    $ok = true;
                }
            }

            if (!$ok) {
                $db->where('name', $name);
                $db->delete('products');

                return false;
            } else {
                return true;
            }
        }

        public static function GetAll()
        {
            $db = MysqliDb::getInstance();

            $products = $db->get('products');
            $products_deliver = array();

            foreach ($products as $product) {
                $products_deliver[$product['name']] = new Product($product['name'], $product);
            }

            return $products_deliver;
        }
    }
