<?php
    class Rewards
    {
        public static function GetBySteamID($steamid)
        {
            $db = MysqliDb::getInstance();

            $db->where('steamid64', $steamid);
            $db->where('status', 0);

            return $db->get('rewards');
        }

        public static function SetExecuted($id)
        {
            $db = MysqliDb::getInstance();

            $data = array('status' => 1);

            $db->where('id', $id);
            $db->update('rewards', $data);
        }

        public static function GetUnexecuted()
        {
            $db = MysqliDb::getInstance();

            $db->where('status', 0);

            return $db->get('rewards');
        }

        public static function SetExecutedOn($id, $executedon)
        {
            $db = MysqliDb::getInstance();

            $data = array('executed_on' => $executedon);

            $db->where('id', $id);
            $db->update('rewards', $data);
        }

        public static function SetValue($id, $value)
        {
            $db = MysqliDb::getInstance();

            $data = array('value' => $value);

            $db->where('id', $id);
            $db->update('rewards', $data);
        }

        public static function Create($data, $runonetimereward = true)
        {
            $db = MysqliDb::getInstance();

            if (0 == $data['once'] || $runonetimereward) {
                $db->insert('rewards', $data);
            }

            return $db->count > 0;
        }

        public static function SetPermanent($id)
        {
            $db = MysqliDb::getInstance();

            $data = array('expires' => '2037-01-01 00:00:00');

            $db->where('id', $id);
            $db->update('rewards', $data);
        }

        public static function MakeReplaces($string, $rewarddata, $replaces)
        {
            $user = new User($rewarddata['steamid64']);

            if ($user->valid && !empty($rewarddata)) {
                foreach ($replaces as $replace) {
                    if ('steamid64' == $replace) {
                        $string = str_replace('%'.$replace.'%', $user->GetValue('steamid64'), $string);
                    } elseif ('steamid32' == $replace) {
                        $string = str_replace('%'.$replace.'%', $user->GetValue('steamid32'), $string);
                    } elseif ('uniqueid' == $replace) {
                        $string = str_replace('%'.$replace.'%', $user->GetValue('uniqueid'), $string);
                    } elseif ('nick' == $replace) {
                        $string = str_replace('%'.$replace.'%', $user->GetValue('nick'), $string);
                    } elseif ('package_id' == $replace) {
                        $string = str_replace('%'.$replace.'%', $rewarddata['package'], $string);
                    } elseif ('avatar' == $replace) {
                        $string = str_replace('%'.$replace.'%', $user->GetValue('avatar_large'), $string);
                    } elseif ('serverbundle_id' == $replace) {
                        $string = str_replace('%'.$replace.'%', $rewarddata['serverbundle'], $string);
                    }
                }
            }

            return $string;
        }

        public static function CheckForExecute()
        {
            $rewards = Rewards::GetUnexecuted();

            $rewards_to_handle = array('groups_return', 'ts3_servergroup', 'ts3_servergroup_remove', 'ts3_channel', 'ts3_channel_delete', 'ts3_channel_delete_warning', 'notification_expired', 'groups_expire', 'httpget', 'httpget', 'discord_role', 'discord_role_remove');

            Donations::ProcessRewards();

            foreach ($rewards as $reward) {
                $executed = false;
                if (in_array($reward['type'], $rewards_to_handle)) {
                    if (strtotime($reward['expires']) > time()) {
                        if ('ts3_servergroup' == $reward['type']) {
                            $user = new User($reward['steamid64']);

                            if ($user->valid) {
                                if (!tempty($user->GetValue('ts3uid'))) {
                                    if ($reward['executed_on'] != $user->GetValue('ts3uid')) {
                                        $ts3Worker = GetTS3Worker();

                                        if ($ts3Worker->valid) {
                                            if (!empty($reward['executed_on'])) {
                                                $ts3Worker->RemoveServergroup($reward['executed_on'], $reward['value']);
                                            }

                                            $ts3Worker->AssignServergroup($user->GetValue('ts3uid'), $reward['value']);

                                            Rewards::SetExecutedOn($reward['id'], $user->GetValue('ts3uid'));
                                        }
                                    }
                                } elseif (!empty($reward['executed_on'])) {
                                    $ts3Worker = GetTS3Worker();

                                    if ($ts3Worker->valid) {
                                        $ts3Worker->RemoveServergroup($reward['executed_on'], $reward['value']);
                                        Rewards::SetExecutedOn($reward['id'], '');
                                    }
                                }
                            }
                        } elseif ('discord_role' == $reward['type']) {
                            $user = new User($reward['steamid64']);

                            if ($user->valid) {
                                if (!tempty($user->GetValue('discord_user_id'))) {
                                    if ($reward['executed_on'] != $user->GetValue('discord_user_id')) {
                                        $discord = new Discord();

                                        if (!empty($reward['executed_on'])) {
                                            $discord->removeRoleFromUser($reward['executed_on'], $reward['value']);
                                        }

                                        $discord->addRoleToUser($user->GetValue('discord_user_id'), $reward['value']);

                                        Rewards::SetExecutedOn($reward['id'], $user->GetValue('discord_user_id'));
                                    }
                                } elseif (!empty($reward['executed_on'])) {
                                    $discord = new Discord();

                                    $discord->removeRoleFromUser($reward['executed_on'], $reward['value']);
                                    Rewards::SetExecutedOn($reward['id'], '');
                                }
                            }
                        } elseif ('ts3_channel' == $reward['type']) {
                            $user = new User($reward['steamid64']);

                            $info = FromJson($reward['value'], true);

                            if ($info && $user->valid) {
                                if (!tempty($user->GetValue('ts3uid'))) {
                                    $ts3Worker = GetTS3Worker();

                                    if ($ts3Worker->valid) {
                                        if ($info['id'] > -1) {
                                            if ($reward['executed_on'] != $user->GetValue('ts3uid')) {
                                                if (!empty($reward['executed_on'])) {
                                                    $ts3Worker->RemoveChannelgroup($reward['executed_on'], $info['channelgroup'], $info['id']);
                                                }

                                                $ts3Worker->AssignChannelgroup($user->GetValue('ts3uid'), $info['channelgroup'], $info['id']);

                                                Rewards::SetExecutedOn($reward['id'], $user->GetValue('ts3uid'));
                                            }
                                        } else {
                                            $channelid = $ts3Worker->CreateChannel((!isset($info['name']) ? $user->GetValue('nick')."'s Channel" : $info['name']), $info['parentchannel'], $user->GetValue('nick').' ('.$user->GetValue('steamid64').')', (isset($info['client_limit']) ? $info['client_limit'] : -1));

                                            if (is_numeric($channelid)) {
                                                $info['id'] = $channelid;

                                                Rewards::SetValue($reward['id'], ToJson($info));

                                                $ts3Worker->AssignChannelgroup($user->GetValue('ts3uid'), $info['channelgroup'], $channelid);

                                                Rewards::SetExecutedOn($reward['id'], $user->GetValue('ts3uid'));

                                                if ($info['delete']) {
                                                    $data = $reward;

                                                    $data['executed_on'] = '';
                                                    $data['type'] = 'ts3_channel_delete';
                                                    $data['value'] = $channelid;
                                                    $data['once'] = 1;
                                                    $data['on_expire'] = 1;
                                                    unset($data['created']);
                                                    unset($data['id']);

                                                    Rewards::Create($data);

                                                    $data = $reward;

                                                    $data['executed_on'] = '';
                                                    $data['type'] = 'ts3_channel_delete_warning';
                                                    $data['value'] = $channelid;
                                                    $data['once'] = 1;
                                                    $data['on_expire'] = 1;
                                                    $data['expires'] = date('Y-m-d H:i:s', strtotime($reward['expires']) - 864000);
                                                    unset($data['created']);
                                                    unset($data['id']);

                                                    Rewards::Create($data);
                                                } else {
                                                    Rewards::SetPermanent($reward['id']);
                                                }
                                            }
                                        }
                                    }
                                } elseif (!empty($reward['executed_on'])) {
                                    $ts3Worker = GetTS3Worker();

                                    if ($ts3Worker->valid) {
                                        $ts3Worker->RemoveChannelgroup($reward['executed_on'], $info['channelgroup'], $info['id']);
                                        Rewards::SetExecutedOn($reward['id'], '');
                                    }
                                }
                            }
                        } elseif ('httpget' == $reward['type']) {
                            $urls = FromJson($reward['value']);

                            foreach ($urls as $url) {
                                $url = Rewards::MakeReplaces($url, $reward, array('steamid64', 'steamid32', 'uniqueid', 'nick', 'package_id', 'avatar'));
                                $requester = new CURLRequester($url);
                                $requester->request(null, false, 3);
                            }

                            $executed = true;
                        }
                    } else {
                        if ($reward['on_expire'] && date('Y', strtotime($reward['expires'])) < 2036) {
                            $user = new User($reward['steamid64']);

                            if ($user->valid) {
                                if ('groups_return' == $reward['type']) {
                                    $groupchanges = FromJson($reward['value']);

                                    foreach ($groupchanges as $bundle => $groupchange) {
                                        if ($user->GetGroup($bundle)->GetValue('groupname') == $groupchange['from']) {
                                            $newgroup = new Group($groupchange['from']);

                                            if ($newgroup->valid) {
                                                $user->SetGroup($groupchange['to'], $bundle);
                                            }
                                        }
                                    }

                                    $executed = true;
                                } elseif ('notification_expired' == $reward['type']) {
                                    $bundle = new Serverbundle($reward['serverbundle']);

                                    if ($bundle->valid) {
                                        Notifications::Send($reward['steamid64'], 'notification_package_expired', array('package' => $reward['value'], 'bundle' => $bundle->GetValue('name')), 'index.php?t=shop&bundle='.$bundle->GetValue('id').'&package='.$reward['package'], 'clock-o');
                                    }

                                    $executed = true;
                                } elseif ('groups_expire' == $reward['type']) {
                                    $groups = FromJson(($reward['value']));

                                    foreach ($groups as $bundle => $groupname) {
                                        $newgroup = new Group($groupname);

                                        if ($newgroup->valid && is_numeric($bundle)) {
                                            $user->SetGroup($groupname, $bundle);
                                        }
                                    }

                                    $executed = true;
                                } elseif ('ts3_servergroup_remove' == $reward['type']) {
                                    if (!tempty($user->GetValue('ts3uid'))) {
                                        $ts3Worker = GetTS3Worker();

                                        if ($ts3Worker->valid) {
                                            $ts3Worker->RemoveServergroup($user->GetValue('ts3uid'), $reward['value']);
                                            $executed = true;
                                        }
                                    }
                                } elseif ('discord_role_remove' == $reward['type']) {
                                    if (!tempty($user->GetValue('discord_user_id'))) {
                                        $discord = new Discord();

                                        $discord->removeRoleFromUser($user->GetValue('discord_user_id'), $reward['value']);
                                        $executed = true;
                                    }
                                } elseif ('ts3_channel_delete' == $reward['type']) {
                                    if ($user->GetGroup()->GetSetting('teamspeak_disablechanneldeletion')) {
                                        $executed = true;
                                    } else {
                                        $ts3Worker = GetTS3Worker();

                                        if ($ts3Worker->valid) {
                                            $ts3Worker->DeleteChannel($reward['value']);
                                            $executed = true;
                                        }
                                    }
                                } elseif ('ts3_channel_delete_warning' == $reward['type']) {
                                    if ($user->GetGroup()->GetSetting('teamspeak_disablechanneldeletion')) {
                                        $executed = true;
                                    } else {
                                        $ts3Worker = GetTS3Worker();

                                        if ($ts3Worker->valid) {
                                            $ts3Worker->PrependDescription($reward['value'], '[COLOR=#ff0000][B]Warning:[/B]
This channel will be deleted in 10 days.
Make sure to save required data.
Visit [url='.GetCurrentLocation().'index.php?t=shop]this page[/url] to buy a new channel or to extend this one.
- '.FormatDate(date('Y-m-d H:i:s', time())).'[/COLOR]

');
                                            $executed = true;
                                        }
                                    }
                                } elseif ('httpget' == $reward['type']) {
                                    $urls = FromJson($reward['value']);

                                    foreach ($urls as $url) {
                                        $url = Rewards::MakeReplaces($url, $reward, array('steamid64', 'steamid32', 'uniqueid', 'nick', 'package_id', 'avatar'));
                                        $requester = new CURLRequester($url);
                                        $requester->request(null, false, 3);
                                    }

                                    $executed = true;
                                }
                            }
                        } else {
                            Rewards::SetExecuted($reward['id']);
                        }
                    }
                }

                if ($executed && $reward['once']) {
                    Rewards::SetExecuted($reward['id']);
                }
            }

            User::CheckForRewards();
        }

        public static function Assign($insert_template, $for, $rot, $rewards)
        {
            $db = MysqliDb::getInstance();

            // Pointshop 1

            if (isset($rewards['ps1_points'])) {
                if (!empty($rewards['ps1_points']) && is_numeric($rewards['ps1_points'])) {
                    $data = $insert_template;

                    $data['type'] = 'ps1_points';
                    $data['value'] = $rewards['ps1_points'];

                    $data['once'] = 1;

                    if (isset($rewards['ps1_mysql']) && $rewards['ps1_mysql']) {
                        $data['one_from_all'] = 1;
                    }

                    Rewards::Create($data, $rot);
                }
            }

            // Pointshp 2

            if (isset($rewards['ps2_points'])) {
                if (!empty($rewards['ps2_points']) && is_numeric($rewards['ps2_points'])) {
                    $data = $insert_template;

                    $data['type'] = 'ps2_points';
                    $data['value'] = $rewards['ps2_points'];

                    $data['once'] = 1;

                    if (isset($rewards['ps2_mysql']) && $rewards['ps2_mysql']) {
                        $data['one_from_all'] = 1;
                    }

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['ps2_premiumpoints']) && is_numeric($rewards['ps2_premiumpoints'])) {
                if (!empty($rewards['ps2_premiumpoints'])) {
                    $data = $insert_template;

                    $data['type'] = 'ps2_premiumpoints';
                    $data['value'] = $rewards['ps2_premiumpoints'];

                    $data['once'] = 1;

                    if (isset($rewards['ps2_mysql']) && $rewards['ps2_mysql']) {
                        $data['one_from_all'] = 1;
                    }

                    Rewards::Create($data, $rot);
                }
            }

            // SH Pointshop

            if (isset($rewards['shps_points'])) {
                if (!empty($rewards['shps_points']) && is_numeric($rewards['shps_points'])) {
                    $data = $insert_template;

                    $data['type'] = 'shps_points';
                    $data['value'] = $rewards['shps_points'];

                    $data['once'] = 1;

                    if (isset($rewards['shps_mysql']) && $rewards['shps_mysql']) {
                        $data['one_from_all'] = 1;
                    }

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['shps_premiumpoints']) && is_numeric($rewards['shps_premiumpoints'])) {
                if (!empty($rewards['shps_premiumpoints'])) {
                    $data = $insert_template;

                    $data['type'] = 'shps_premiumpoints';
                    $data['value'] = $rewards['shps_premiumpoints'];

                    $data['once'] = 1;

                    if (isset($rewards['shps_mysql']) && $rewards['shps_mysql']) {
                        $data['one_from_all'] = 1;
                    }

                    Rewards::Create($data, $rot);
                }
            }

            // Weapons

            if (isset($rewards['weapons_spawn'])) {
                if (!empty($rewards['weapons_spawn'])) {
                    $data = $insert_template;

                    $weapons = explode(',', trim($rewards['weapons_spawn']));

                    $data['type'] = 'weapons';
                    $data['value'] = json_encode($weapons);
                    $data['on_spawn'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            // DarkRP

            if (isset($rewards['darkrp_money'])) {
                if (!empty($rewards['darkrp_money']) && is_numeric($rewards['darkrp_money'])) {
                    $data = $insert_template;

                    $data['type'] = 'darkrp_money';
                    $data['value'] = $rewards['darkrp_money'];

                    $data['once'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['darkrp_levels'])) {
                if (!empty($rewards['darkrp_levels']) && is_numeric($rewards['darkrp_levels'])) {
                    $data = $insert_template;

                    $data['type'] = 'darkrp_levels';
                    $data['value'] = $rewards['darkrp_levels'];

                    $data['once'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            // DayZ

            if (isset($rewards['dayz_credits'])) {
                if (!empty($rewards['dayz_credits']) && is_numeric($rewards['dayz_credits'])) {
                    $data = $insert_template;

                    $data['type'] = 'dayz_credits';
                    $data['value'] = $rewards['dayz_credits'];

                    $data['once'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['dayz_items'])) {
                if (!empty($rewards['dayz_items'])) {
                    $data = $insert_template;

                    $weapons = explode(',', trim($rewards['dayz_items']));

                    $data['type'] = 'dayz_items';
                    $data['value'] = json_encode($weapons);

                    $data['once'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            //TTT

            if (isset($rewards['ttt_specprop']) && $rewards['ttt_specprop']) {
                $data = $insert_template;

                $data['type'] = 'ttt_specprop';
                $data['value'] = 1;

                $data['on_connect'] = 1;

                Rewards::Create($data, $rot);
            }

            if (isset($rewards['ttt_voicedrain']) && $rewards['ttt_voicedrain']) {
                $data = $insert_template;

                $data['type'] = 'ttt_voicedrain';
                $data['value'] = 1;

                $data['on_connect'] = 1;

                Rewards::Create($data, $rot);
            }

            //ReservedSlot

            if (isset($rewards['reservedslot']) && $rewards['reservedslot']) {
                $data = $insert_template;

                $data['type'] = 'reservedslot';
                $data['value'] = 1;

                $data['on_connect'] = 1;

                Rewards::Create($data, $rot);
            }

            //Lua

            if (isset($rewards['lua_expires'])) {
                if (!empty($rewards['lua_expires'])) {
                    $data = $insert_template;

                    $data['type'] = 'lua';
                    $data['value'] = $rewards['lua_expires'];
                    $data['on_expire'] = 1;
                    $data['once'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['lua_spawn'])) {
                if (!empty($rewards['lua_spawn'])) {
                    $data = $insert_template;

                    $data['type'] = 'lua';
                    $data['value'] = $rewards['lua_spawn'];
                    $data['on_spawn'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['lua_connect'])) {
                if (!empty($rewards['lua_connect'])) {
                    $data = $insert_template;

                    $data['type'] = 'lua';
                    $data['value'] = $rewards['lua_connect'];
                    $data['on_connect'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['lua_direct'])) {
                if (!empty($rewards['lua_direct'])) {
                    $data = $insert_template;

                    $data['type'] = 'lua';
                    $data['value'] = $rewards['lua_direct'];
                    $data['once'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['lua_direct_ofa'])) {
                if (!empty($rewards['lua_direct_ofa'])) {
                    $data = $insert_template;

                    $data['type'] = 'lua';
                    $data['value'] = $rewards['lua_direct_ofa'];
                    $data['once'] = 1;
                    $data['one_from_all'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            //ConCommands

            if (isset($rewards['concommands_expires'])) {
                if (!empty($rewards['concommands_expires'])) {
                    $data = $insert_template;

                    $concommands = explode(',', $rewards['concommands_expires']);

                    $data['type'] = 'concommands';
                    $data['value'] = ToJson($concommands);
                    $data['on_expire'] = 1;
                    $data['once'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['concommands_spawn'])) {
                if (!empty($rewards['concommands_spawn'])) {
                    $data = $insert_template;

                    $concommands = explode(',', $rewards['concommands_spawn']);

                    $data['type'] = 'concommands';
                    $data['value'] = ToJson($concommands);
                    $data['on_spawn'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['concommands_connect'])) {
                if (!empty($rewards['concommands_connect'])) {
                    $data = $insert_template;

                    $concommands = explode(',', $rewards['concommands_connect']);

                    $data['type'] = 'concommands';
                    $data['value'] = json_encode($concommands);
                    $data['on_connect'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['concommands_direct'])) {
                if (!empty($rewards['concommands_direct'])) {
                    $data = $insert_template;

                    $concommands = explode(',', $rewards['concommands_direct']);

                    $data['type'] = 'concommands';
                    $data['value'] = ToJson($concommands);
                    $data['once'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['concommands_direct_ofa'])) {
                if (!empty($rewards['concommands_direct_ofa'])) {
                    $data = $insert_template;

                    $concommands = explode(',', $rewards['concommands_direct_ofa']);

                    $data['type'] = 'concommands';
                    $data['value'] = ToJson($concommands);
                    $data['once'] = 1;
                    $data['one_from_all'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            //HTTP GET

            if (isset($rewards['httpget_direct'])) {
                if (!empty($rewards['httpget_direct'])) {
                    $data = $insert_template;

                    $concommands = explode('\r\n', $rewards['httpget_direct']);

                    $data['type'] = 'httpget';
                    $data['value'] = ToJson($concommands);
                    $data['once'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            if (isset($rewards['httpget_expire'])) {
                if (!empty($rewards['httpget_expire'])) {
                    $data = $insert_template;

                    $concommands = explode('\r\n', $rewards['httpget_expire']);

                    $data['type'] = 'httpget';
                    $data['value'] = ToJson($concommands);
                    $data['on_expire'] = 1;
                    $data['once'] = 1;

                    Rewards::Create($data, $rot);
                }
            }

            //TS3

            if (isset($rewards['ts3_parentchannel']) && isset($rewards['ts3_channelgroup'])) {
                if (!empty($rewards['ts3_parentchannel']) && !empty($rewards['ts3_channelgroup'])) {
                    $extended = false;

                    if (isset($rewards['ts3_channel_extend']) && $rewards['ts3_channel_extend']) {
                        $db->where('type', 'ts3_channel_delete');
                        $db->where('steamid64 = ? AND status = 0 AND expires > NOW()', array($for->GetValue('steamid64')));
                        $channeldelete = $db->getOne('rewards');

                        if ($db->count) {
                            $db->where('id', $channeldelete['id']);

                            $days = floor((strtotime($expires) - time()) / (60 * 60 * 24));

                            if (strtotime($expires) > 1893452400) {
                                $db->delete('rewards');
                            } else {
                                $db->update('rewards', array('expires' => $db->func('DATE_ADD(expires, INTERVAL ? DAY)', array($days))));
                            }

                            if ($db->count) {
                                $extended = true;
                            }

                            $db->where('type', 'ts3_channel_delete_warning');
                            $db->where('value', $channeldelete['id']);
                            $db->delete();
                        }
                    }

                    if (!$extended) {
                        if (!isset($rewards['ts3_clientlimit']) || !is_numeric($rewards['ts3_clientlimit'])) {
                            $rewards['ts3_clientlimit'] = -1;
                        }

                        if (!isset($rewards['ts3_channel_delete']) || tempty($rewards['ts3_channel_delete'])) {
                            $rewards['ts3_channel_delete'] = 0;
                        }

                        $data = $insert_template;

                        $data['type'] = 'ts3_channel';
                        $data['value'] = ToJson(array('parentchannel' => $rewards['ts3_parentchannel'], 'channelgroup' => $rewards['ts3_channelgroup'], 'id' => -1, 'client_limit' => $rewards['ts3_clientlimit'], 'delete' => isset($rewards['ts3_channel_delete'])));

                        Rewards::Create($data, $rot);
                    }
                }
            }

            if (isset($rewards['ts3_servergroup'])) {
                if (!empty($rewards['ts3_servergroup'])) {
                    $data = $insert_template;

                    $data['type'] = 'ts3_servergroup';
                    $data['value'] = $rewards['ts3_servergroup'];

                    Rewards::Create($data, $rot);

                    if (isset($rewards['ts3_servergroup_remove']) && $rewards['ts3_servergroup_remove']) {
                        $data = $insert_template;

                        $data['type'] = 'ts3_servergroup_remove';
                        $data['value'] = $rewards['ts3_servergroup'];
                        $data['once'] = 1;
                        $data['on_expire'] = 1;

                        Rewards::Create($data, $rot);
                    }
                }
            }

            //Discord
            if (isset($rewards['discord_role'])) {
                if (!empty($rewards['discord_role'])) {
                    $data = $insert_template;

                    $data['type'] = 'discord_role';
                    $data['value'] = $rewards['discord_role'];

                    Rewards::Create($data, $rot);

                    if (isset($rewards['discord_role_remove']) && $rewards['discord_role_remove']) {
                        $data = $insert_template;

                        $data['type'] = 'discord_role_remove';
                        $data['value'] = $rewards['discord_role'];
                        $data['once'] = 1;
                        $data['on_expire'] = 1;

                        Rewards::Create($data, $rot);
                    }
                }
            }

            //Groups

            $groups_return = array();
            $groups_expire = array();

            foreach ($rewards as $key => $value) {
                if (StartsWith($key, 'groups_expire_')) {
                    if ('0' != $value) {
                        $bundle = substr($key, 14);

                        if (is_numeric($bundle)) {
                            $group = new Group($value);

                            if ($group->valid) {
                                $groups_expire[$bundle] = $group->GetValue('groupname');
                            }
                        }
                    }
                } elseif (StartsWith($key, 'groups_')) {
                    if ('0' != $value) {
                        $bundle = substr($key, 7);

                        if (is_numeric($bundle)) {
                            $group = new Group($value);

                            if ($group->valid) {
                                if ($group->GetValue('level') >= $for->GetGroup($bundle)->GetValue('level')) {
                                    if (isset($rewards['groups_return']) && $rewards['groups_return']) {
                                        $groups_return[$bundle] = array('to' => $for->GetGroup($bundle)->GetValue('groupname'), 'from' => $group->GetValue('groupname'));
                                    }

                                    $for->SetGroup($value, $bundle);
                                }
                            }
                        }
                    }
                }
            }

            if (sizeof($groups_return)) {
                $data = $insert_template;

                $data['type'] = 'groups_return';
                $data['value'] = json_encode($groups_return);

                $data['on_expire'] = 1;
                $data['once'] = 1;

                Rewards::Create($data, $rot);
            } elseif (sizeof($groups_expire)) {
                $data = $insert_template;

                $data['type'] = 'groups_expire';
                $data['value'] = json_encode($groups_expire);

                $data['on_expire'] = 1;
                $data['once'] = 1;

                Rewards::Create($data, $rot);
            }

            //Player Refresh
            $data = $insert_template;

            $data['type'] = 'lua';
            $data['value'] = 'GExtension:RefreshPlayer(PLAYER)';
            $data['one_from_all'] = 1;
            $data['once'] = 1;

            Rewards::Create($data, $rot);
        }

        public static function GetSelectorCheckboxes()
        {
            return array(
                'rewardselector_ps1_mysql',
                'rewardselector_ps2_mysql',
                'rewardselector_groups_return',
                'rewardselector_ttt_specprop',
                'rewardselector_ttt_voicedrain',
                'rewardselector_reservedslot',
                'rewardselector_ts3_servergroup_remove',
                'rewardselector_ts3_channel_extend',
                'rewardselector_ts3_channel_delete',
                'rewardselector_shps_mysql',
                'rewardselector_discord_role_remove',
            );
        }

        public static function LoadSelector()
        {
            echo '
            	<div id="rewardselector">
	            	<!-- Pointshop 1 -->
	                <div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-money"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_ps1_collapse">
									Pointshop 1
								</a>
							</h4>
						</div>
						<div id="rewardselector_ps1_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('standard_points').'</label><br>
								<input class="form-control rewards-spin-100" name="rewardselector_ps1_points" placeholder="'.Lang('standard_points').'" />
								';
            CreateCheckbox('primary', 'rewardselector_ps1_mysql', 'rewardselector_checkbox', Lang('uses_mysql'));
            echo '
							</div>
						</div>
					</div>

					<!-- Pointshop 2 -->
	                <div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-money"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_ps2_collapse">
									Pointshop 2
								</a>
							</h4>
						</div>
						<div id="rewardselector_ps2_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('standard_points').'</label><br>
								<input class="form-control rewards-spin-100" name="rewardselector_ps2_points" placeholder="'.Lang('standard_points').'" /><br>
								<label>'.Lang('premium_points').'</label><br>
								<input class="form-control rewards-spin-100" name="rewardselector_ps2_premiumpoints" placeholder="'.Lang('premium_points').'" />
								';
            CreateCheckbox('primary', 'rewardselector_ps2_mysql', 'rewardselector_checkbox', Lang('uses_mysql'));
            echo '
							</div>
						</div>
					</div>
					
					<!-- SH Pointshop -->
	                <div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-money"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_shps_collapse">
									SH Pointshop
								</a>
							</h4>
						</div>
						<div id="rewardselector_shps_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('standard_points').'</label><br>
								<input class="form-control rewards-spin-100" name="rewardselector_shps_points" placeholder="'.Lang('standard_points').'" /><br>
								<label>'.Lang('premium_points').'</label><br>
								<input class="form-control rewards-spin-100" name="rewardselector_shps_premiumpoints" placeholder="'.Lang('premium_points').'" />
								';
            CreateCheckbox('primary', 'rewardselector_shps_mysql', 'rewardselector_checkbox', Lang('uses_mysql'));
            echo '
							</div>
						</div>
					</div>

					<!-- Group -->
	                <div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-users"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_group_collapse">
									'.Lang('groups').'
								</a>
							</h4>
						</div>
						<div id="rewardselector_group_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<table class="table table-responsive table-hover">
								    <tr>
								        <th>'.Lang('serverbundle').'</th>
								        <th style="width: 60%;">'.Lang('group').'<span class="pull-right">';
            CreateTooltip(Lang('upranks_only'), 'left');
            echo '</span></th>
								    </tr>

								    <tbody>
										';
            $groups = Group::GetAll();
            $groups_options = '';

            foreach ($groups as $group) {
                $groups_options .= '<option style="color: '.$group->GetValue('hexcolor').';">'.$group->GetValue('groupname').'</option>';
            }

            foreach (Serverbundle::GetAll(true) as $bundle) {
                echo '<tr>';
                echo '<td>';
                echo $bundle->GetValue('name');
                echo '</td>';
                echo '<td>';
                echo '
															<select class="form-control" name="rewardselector_groups_'.$bundle->GetValue('id').'">
																<option value="0"></option>';

                echo $groups_options;
                echo '</select>';
                echo '</td>';
                echo '</tr>';
            }
            echo '
									</tbody>
								</table>

								<label>'.Lang('on_expire').' ('.Lang('optional').')'.'</label><br>
								';
            CreateCheckbox('primary', 'rewardselector_groups_return', 'rewardselector_checkbox', Lang('groups_return'));
            echo '

								<center><b>'.Lang('or').'</b></center><br>

								<table class="table table-responsive table-hover">
								    <tr>
								        <th>'.Lang('serverbundle').'</th>
								        <th style="width: 60%;">'.Lang('group').'</th>
								    </tr>

								    <tbody>
	                                    ';
            $groups = Group::GetAll();
            $groups_options = '';

            foreach ($groups as $group) {
                $groups_options .= '<option style="color: '.$group->GetValue('hexcolor').';">'.$group->GetValue('groupname').'</option>';
            }

            foreach (Serverbundle::GetAll(true) as $bundle) {
                echo '<tr>';
                echo '<td>';
                echo $bundle->GetValue('name');
                echo '</td>';
                echo '<td>';
                echo '
															<select class="form-control" name="rewardselector_groups_expire_'.$bundle->GetValue('id').'">
																<option value="0"></option>';

                echo $groups_options;
                echo '</select>';
                echo '</td>';
                echo '</tr>';
            }
            echo '
									</tbody>
								</table>
							</div>
						</div>
					</div>

					<!-- Weapons -->
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-bomb"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_weapons_collapse">
									'.Lang('weapons').'
								</a>
							</h4>
						</div>
						<div id="rewardselector_weapons_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('weapons_spawn').'</label><br>
								<input class="form-control" name="rewardselector_weapons_spawn" placeholder="'.Lang('seperate_with_comma').'" />

								<!--<label>'.Lang('weapons_firstconnect').'</label><br>
								<input class="form-control" name="rewardselector_weapons_firstconnect" placeholder="'.Lang('seperate_with_comma').'" /><br>

								<label>'.Lang('weapons_connect').'</label><br>
								<input class="form-control" name="rewardselector_weapons_connect" placeholder="'.Lang('seperate_with_comma').'" /><br>

								 -->
							</div>
						</div>
					</div>

					<!-- DarkRP -->
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-square"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_darkrp_collapse">
									DarkRP
								</a>
							</h4>
						</div>
						<div id="rewardselector_darkrp_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('darkrp_money').'</label><br>
								<input class="form-control rewards-spin-100" name="rewardselector_darkrp_money" placeholder="'.Lang('darkrp_money').'" /><br>

								<label>'.Lang('darkrp_levels').'</label><br>
								<input class="form-control rewards-spin-1" name="rewardselector_darkrp_levels" placeholder="'.Lang('darkrp_levels').'" />
							</div>
						</div>
					</div>

					<!-- DayZ -->
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-crosshairs"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_dayz_collapse">
									DayZ
								</a>
							</h4>
						</div>
						<div id="rewardselector_dayz_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('dayz_credits').'</label><br>
								<input class="form-control rewards-spin-100" name="rewardselector_dayz_credits" placeholder="'.Lang('dayz_credits').' " /><br>

								<label>'.Lang('dayz_items').'</label><br>
								<input class="form-control rewards-spin-1" name="rewardselector_dayz_items" placeholder="'.Lang('dayz_items').' '.Lang('seperate_with_comma').' "/>
							</div>
						</div>
					</div>

					<!-- TTT -->
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-male"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_ttt_collapse">
									TTT
								</a>
							</h4>
						</div>
						<div id="rewardselector_ttt_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('ttt_specprop').'</label><br>
								';
            CreateCheckbox('primary', 'rewardselector_ttt_specprop', 'rewardselector_checkbox', Lang('ttt_specprop_infinite'));
            echo '

								<label>'.Lang('ttt_voicedrain').'</label><br>
								';
            CreateCheckbox('primary', 'rewardselector_ttt_voicedrain', 'rewardselector_checkbox', Lang('ttt_voicedrain_infinite'));
            echo '
							</div>
						</div>
					</div>

					<!-- Other -->
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-cog"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_other_collapse">
									'.Lang('other').'
								</a>
							</h4>
						</div>
						<div id="rewardselector_other_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('reservedslot').'</label><br>
								';
            CreateCheckbox('primary', 'rewardselector_reservedslot', 'rewardselector_checkbox', Lang('reservedslot_description'));
            echo '
							</div>
						</div>
					</div>

					<!-- Teamspeak 3 -->
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-microphone"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_ts3_collapse">
									'.Lang('ts3').'
								</a>
							</h4>
						</div>
						<div id="rewardselector_ts3_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('servergroup').'</label><br>
								<input class="form-control" name="rewardselector_ts3_servergroup" placeholder="'.Lang('ts3_servergroup').'" />
								';
            CreateCheckbox('primary', 'rewardselector_ts3_servergroup_remove', 'rewardselector_checkbox', Lang('remove_on_expire'));
            echo '<br>

								<label>'.Lang('channel').'</label><br>
								<input class="form-control" name="rewardselector_ts3_parentchannel" placeholder="'.Lang('ts3_channel_parent_id').' " />
								<input class="form-control" name="rewardselector_ts3_channelgroup" placeholder="'.Lang('ts3_channelgroup').' " /><br>
								<label><small>'.Lang('client_limit').'</small></label><br>
								<input class="form-control" name="rewardselector_ts3_clientlimit" placeholder="'.Lang('client_limit').' " />
								';
            CreateCheckbox('primary', 'rewardselector_ts3_channel_delete', 'rewardselector_checkbox', Lang('channel_delete_on_expire'));
            echo '
								';
            CreateCheckbox('primary', 'rewardselector_ts3_channel_extend', 'rewardselector_checkbox', Lang('channel_extend'));
            echo '
							</div>
						</div>
					</div>
					
					<!-- Discord -->
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-comments-o"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_discord_collapse">
									'.Lang('discord').'
								</a>
							</h4>
						</div>
						<div id="rewardselector_discord_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('role').'</label><br>
								<input class="form-control" name="rewardselector_discord_role" placeholder="'.Lang('discord_role_id').'" />
								';
            CreateCheckbox('primary', 'rewardselector_discord_role_remove', 'rewardselector_checkbox', Lang('remove_on_expire'));
            echo '<br>
							</div>
						</div>
					</div>

					<!-- Console Command -->
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-terminal"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_concommand_collapse">
									'.Lang('concommand').'
								</a>
								<span class="pull-right">';
            CreateTooltip(Lang('available').': %steamid64%, %steamid32%, %uniqueid%, %nick%, %package_id%, %package_name%, %amount_donated%', 'left');
            echo '</span>
							</h4>
						</div>
						<div id="rewardselector_concommand_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('concommands_direct').' ('.Lang('all_servers').')'.'</label><span class="pull-right">';
            CreateTooltip(Lang('direct_definition'), 'left');
            echo '</span><br>
								<input class="form-control" name="rewardselector_concommands_direct" placeholder="'.Lang('seperate_with_comma').'"/><br>

								<label>'.Lang('concommands_direct').' ('.Lang('one_server').')'.'</label><span class="pull-right">';
            CreateTooltip(Lang('direct_definition'), 'left');
            echo '</span><br>
								<input class="form-control" name="rewardselector_concommands_direct_ofa" placeholder="'.Lang('seperate_with_comma').'"/><br>

								<label>'.Lang('concommands_connect').'</label><br>
								<input class="form-control" name="rewardselector_concommands_connect" placeholder="'.Lang('seperate_with_comma').'" /><br>

								<label>'.Lang('concommands_spawn').'</label><br>
								<input class="form-control" name="rewardselector_concommands_spawn" placeholder="'.Lang('seperate_with_comma').'" />

								<hr>

								<label>'.Lang('concommands_expire').'</label><br>
								<input class="form-control" name="rewardselector_concommands_expires" placeholder="'.Lang('seperate_with_comma').'" />
							</div>
						</div>
					</div>

					<!-- Custom Lua -->
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-pencil-square-o"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_lua_collapse">
									'.Lang('custom_lua').'
								</a>
								<span class="pull-right">';
            CreateTooltip(Lang('available').': PLAYER, %package_id%, %package_name%, %amount_donated%', 'left');
            echo '</span></span>
							</h4>
						</div>
						<div id="rewardselector_lua_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('lua_direct').' ('.Lang('all_servers').')'.'</label><span class="pull-right">';
            CreateTooltip(Lang('direct_definition'), 'left');
            echo '</span><br>
								<textarea style="resize:vertical;" class="form-control" name="rewardselector_lua_direct" placeholder="Lua"></textarea><br>

								<label>'.Lang('lua_direct').' ('.Lang('one_server').')'.'</label><span class="pull-right">';
            CreateTooltip(Lang('direct_definition'), 'left');
            echo '</span><br>
								<textarea style="resize:vertical;" class="form-control" name="rewardselector_lua_direct_ofa" placeholder="Lua"></textarea><br>

								<label>'.Lang('lua_connect').'</label><br>
								<textarea style="resize:vertical;" class="form-control" name="rewardselector_lua_connect" placeholder="Lua" ></textarea><br>

								<label>'.Lang('lua_spawn').'</label><br>
								<textarea style="resize:vertical;" class="form-control" name="rewardselector_lua_spawn" placeholder="Lua" ></textarea>

								<hr>

								<label>'.Lang('lua_expire').'</label><br>
								<textarea style="resize:vertical;" class="form-control" name="rewardselector_lua_expires" placeholder="Lua" > </textarea>
							</div>
						</div>
					</div>

					<!-- HTTP -->
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-code"></i>
								<a role="button" data-toggle="collapse" href="#rewardselector_httpget_collapse">
									'.Lang('htttpgetrequest').'
								</a>
								<span class="pull-right">';
            CreateTooltip(Lang('available').': %steamid64%, %steamid32%, %uniqueid%, %nick%, %package_id%, %avatar%', 'left');
            echo '</span></span>
							</h4>
						</div>
						<div id="rewardselector_httpget_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>'.Lang('httpget_direct').'</label><br>
								<textarea style="resize:vertical;" class="form-control" name="rewardselector_httpget_direct" placeholder="https://www.example.tld/api/test/%steamid64%
..."></textarea>

								<hr>

								<label>'.Lang('httpget_expire').'</label><br>
								<textarea style="resize:vertical;" class="form-control" name="rewardselector_httpget_expire" placeholder="https://www.example.tld/api/test/%steamid64%
..."></textarea>
							</div>
						</div>
					</div>
				</div>


				<script>
				    function rewardselector_reset(){
						$("#rewardselector").find("input").val("");
						$("#rewardselector").find("textarea").val("");
						$("#rewardselector").find("input[type=\'checkbox\']").prop("checked", false);
						$("#rewardselector").find("select").prop("selectedIndex", 0);
				    }

				    function rewardselector_load(rewards){
						var checkboxes = ["ps1_mysql", "ps2_mysql", "rewardselector_shps_mysql", "groups_return", "ttt_specprop", "ttt_voicedrain", "reservedslot", "ts3_servergroup_remove", "ts3_channel_delete", "ts3_channel_extend", "discord_role_remove"];

				    	$(".rewardselector_checkbox").each(function(i, checkbox){
				    		var checked = false;

				    		if(rewards.hasOwnProperty($(checkbox).prop("id").substr(15))){
								if(rewards[$(checkbox).prop("id").substr(15)] == 1){
									checked = true;
								}
				    		}

				    		$(checkbox).prop("checked", checked);
				    	});

				    	for (var k in rewards){
						    if (rewards.hasOwnProperty(k)) {
						    	if(k.startsWith("groups_") && rewards[k] != 0){
						    		$("select[name=\'rewardselector_"+k+"\']").val(rewards[k]);
						    	}else if(k.startsWith("lua_") || k.startsWith("httpget_")){
						    		$("textarea[name=\'rewardselector_"+k+"\']").val(rewards[k]);
						    	}else{
						    		if(!checkboxes.hasOwnProperty(k)){
							    		$("input[name=\'rewardselector_"+k+"\']").val(rewards[k]);
							    	}
						    	}
						    }
						}
				    }
				    
				    $("input[name=\'rewardselector_ps1_points\']").TouchSpin({
                        min: 0,
                        max: 2000000000,
                        step: 1000,
                        forcestepdivisibility: \'none\',
                        verticalbuttons: true,
                        postfix: \''.Lang('points').'\'
                    });
                
                    $("input[name=\'rewardselector_ps2_points\']").TouchSpin({
                        min: 0,
                        max: 2000000000,
                        step: 1000,
                        forcestepdivisibility: \'none\',
                        verticalbuttons: true,
                        postfix: \''.Lang('points').'\'
                    });
                
                    $("input[name=\'rewardselector_ps2_premiumpoints\']").TouchSpin({
                        min: 0,
                        max: 2000000000,
                        step: 1000,
                        forcestepdivisibility: \'none\',
                        verticalbuttons: true,
                        postfix: \''.Lang('points').'\'
                    });
                    
                    $("input[name=\'rewardselector_shps_points\']").TouchSpin({
                        min: 0,
                        max: 2000000000,
                        step: 1000,
                        forcestepdivisibility: \'none\',
                        verticalbuttons: true,
                        postfix: \''.Lang('points').'\'
                    });
                    
                    $("input[name=\'rewardselector_shps_premiumpoints\']").TouchSpin({
                        min: 0,
                        max: 2000000000,
                        step: 1000,
                        forcestepdivisibility: \'none\',
                        verticalbuttons: true,
                        postfix: \''.Lang('points').'\'
                    });
                
                    $("input[name=\'rewardselector_darkrp_money\']").TouchSpin({
                        min: 0,
                        max: 2000000000,
                        step: 100,
                        forcestepdivisibility: \'none\',
                        verticalbuttons: true
                    });
                
                    $("input[name=\'rewardselector_darkrp_levels\']").TouchSpin({
                        min: 0,
                        max: 2000000000,
                        step: 1,
                        forcestepdivisibility: \'none\',
                        verticalbuttons: true
                    });
                
                    $("input[name=\'rewardselector_dayz_credits\']").TouchSpin({
                        min: 0,
                        max: 2000000000,
                        step: 100,
                        forcestepdivisibility: \'none\',
                        verticalbuttons: true
                    });
			    </script>
            ';
        }
    }
