<?php
    class Server extends DBTableClass
    {
        public function __construct($id, $data = null)
        {
            $this->Initialize('servers', $id, 'id', $data, array('users_online'));
        }
        
        public function GetLog($timeframe = 0)
        {
            $db = MysqliDb::getInstance();
            
            $db->where("server", $this->GetValue('id'));
            $db->orderBy("created", "Desc");
            $logs = $db->getValue("console", "log", null);
            
            $log = "";
            
            if ($db->count) {
                if (isset($logs[$timeframe])) {
                    $log = $logs[$timeframe];
                } else {
                    if (isset($logs[0])) {
                        $log = $logs[0];
                    }
                }
            }
            
            $log = nl2br(htmlspecialchars($log));

            return $log;
        }
        
        public function GetTimeframes()
        {
            $db = MysqliDb::getInstance();
            
            $db->where("server", $this->GetValue('id'));
            $db->orderBy("created", "Desc");
            $logs = $db->get("console");
            
            $timeframes = array();
            
            foreach ($logs as $log) {
                $timeframes[] = FormatDate($log['created']) . ' - ' . FormatDate($log['updated']);
            }
            
            return $timeframes;
        }
        
        public static function GetAll()
        {
            $db = MysqliDb::getInstance();
            
            $servers = $db->get("servers");
            
            $ret = array();
            
            foreach ($servers as $server) {
                $server['users_online'] = FromJson($server['users_online']);
                $ret[] = new Server($server['id'], $server);
            }
            
            return $ret;
        }
    }
