<?php
    class Serverbundle extends DBTableClass{
        public function __construct($id, $data = null){
            $this->Initialize('serverbundles', $id, 'id', $data);
        }
        
        public static function GetAll($web = false){
            $db = MysqliDb::getInstance();
            
            $bundles = $db->get("serverbundles");
            $bundles_deliver = array();
            
            foreach($bundles as $bundle){
                $bundle['servers'] = FromJson($bundle['servers']);
                $bundles_deliver[$bundle['id']] = new Serverbundle($bundle['id'], $bundle);
            }
            
            if(!$web){
                unset($bundles_deliver[0]);
            }
            
            return $bundles_deliver;
        }
        
        public function GetServers(){
            $ret = array();
    		
    		foreach($this->GetValue('servers') as $server){
    		    $newserver = new Server($server);
    		    
    		    if($newserver->valid){
    		        $ret[] = $newserver;
    		    }
    		}
    		
    		return $ret;
        }
        
        public static function GetByServer($serverid){
            $bundles = Serverbundle::GetAll();
            $searched = false;
            
            foreach(Serverbundle::GetAll() as $bundle){
                if(in_array($serverid, $bundle->GetValue('servers'))){
                    $searched = $bundle;
                }
            }
            
            return $searched;
        }
        
        public static function Create($data){
            $db = MysqliDb::getInstance();
            
            $key = $db->insert("serverbundles", $data);
    		if($db->count){
    		    return $key;
    		}else{
    		    return false;
    		}
        }
    }
?>