<?php
    class Statistics
    {
        private $user;

        public function __construct($user)
        {
            $this->user = $user;
        }

        public function GetTimeForPeriod($days)
        {
            $db = MysqliDb::getInstance();

            $db->where("steamid64", $this->user->GetValue('steamid64'));
            $db->where("serverbundle", $bundle->GetValue('id'));
            $time = FromJson($db->getValue("time"));

            if ($db->count) {
                foreach ($time as $key => $value) {
                    if (strtotime($key) < (time() - ($days * 86400))) {
                        unset($time[$Key]);
                    }
                }
            }

            return $time;
        }

        public function GetTimeStatistics($bundle)
        {
            $result = array();

            if (Settings::Get('settings_demo')) {
                $result = array(
                    'serverbundle' => 1,
                    'time' => ToJson(array(
                        date('d-m-Y', strtotime('-16 day')) => 120,
                        date('d-m-Y', strtotime('-15 day')) => 180,
                        date('d-m-Y', strtotime('-14 day')) => 60,
                        date('d-m-Y', strtotime('-13 day')) => 300,
                        date('d-m-Y', strtotime('-12 day')) => 410,
                        date('d-m-Y', strtotime('-11 day')) => 240,
                        date('d-m-Y', strtotime('-6 day')) => 60,
                        date('d-m-Y', strtotime('-4 day')) => 120,
                        date('d-m-Y', strtotime('-3 day')) => 180,
                        date('d-m-Y', strtotime('-2 day')) => 60,
                    )),
                    'created' => date('d-m-Y', strtotime('-20 day'))
                );
            } else {
                $GLOBALS['db']->where("steamid64", $this->user->GetValue('steamid64'));
                $GLOBALS['db']->where("serverbundle", $bundle->GetValue('id'));
                $result = $GLOBALS['db']->getOne("statistics");
            }


            if (!empty($result)) {
                $time = array();

                $jsontime = $result['time'];
                $jsontime = json_decode($jsontime, true);

                $timebegin = strtotime($result['created']);
                $days = ceil((time() - $timebegin)/(60*60*24)) + 1;

                for ($i = 0; $i < $days; $i++) {
                    $timeminus = date("d-m-Y", strtotime('+'.$i.' days', $timebegin));

                    if (isset($jsontime[$timeminus])) {
                        array_push($time, array(strtotime($timeminus) . '000', round($jsontime[$timeminus]/60)));
                    } else {
                        array_push($time, array(strtotime($timeminus) . '000', 0));
                    }
                }

                return $time;
            } else {
                return array();
            }
        }

        public function GetTotalTime($bundle)
        {
            $db = MysqliDb::getInstance();

            if (!Settings::Get('settings_demo')) {
                $db->where("steamid64", $this->user->GetValue('steamid64'));
                $db->where("serverbundle", $bundle->GetValue('id'));
                $result = $db->getOne("statistics");

                if ($db->count) {
                    $jsontime = $result['time'];
                    $jsontime = (array) json_decode($jsontime);

                    return round(array_sum($jsontime)/60);
                } else {
                    return 0;
                }
            } else {
                return 28;
            }
        }
    }
