<?php
    class SteamAPI
    {
        public static function FinishLogin()
        {
            global $login_messages;

            try {
                $openid = new OpenID(Hostname());

                if (!$openid->mode) {
                } elseif ('cancel' == $openid->mode) {
                    $login_messages[] = '<i style="color:red;" class="fa fa-times-circle-o"></i> authentification failed.';
                //Redirect('index.php', true);
                } else {
                    if ($openid->validate()) {
                        $id = $openid->identity;
                        $ptn = "/^https:\/\/steamcommunity\.com\/openid\/id\/(7[0-9]{15,25}+)$/";
                        preg_match($ptn, $id, $matches);

                        $_SESSION['gex_steamid64'] = $matches[1];
                        $_SESSION['gex_loggingin'] = true;

                        $login_messages[] = '<i style="color:green;" class="fa fa-check"></i> Success.';

                        if (isset($_SESSION['gex_login_get'])) {
                            if (is_array($_SESSION['gex_login_get'])) {
                                foreach ($_SESSION['gex_login_get'] as $key => $val) {
                                    $_GET[$key] = $val;
                                }
                            }
                        }

                        //Redirect('index.php', true);
                    } else {
                        $login_messages[] = '<i style="color:red;" class="fa fa-times-circle-o"></i> authentification failed.';
                        //Redirect('index.php', true);
                    }
                }
            } catch (ErrorException $e) {
                $login_messages[] = $e->getMessage();
            }
        }

        public static function StartLogin($page)
        {
            global $login_messages;

            try {
                $openid = new OpenID(Hostname());

                $return_url = GetCurrentLocation().'index.php?login_started=true';

                if ($page !== null){
                    $return_url .= sprintf('&t=%s', $page);
                }

                $openid->returnUrl = $return_url;

                if (!$openid->mode) {
                    //$login_messages[] = '<big><i class="fa fa-spinner fa-pulse"></i> Redirecting to Steam...</big>';
                    $openid->identity = 'https://steamcommunity.com/openid/';

                    return $openid->authUrl();
                    //Redirect($openid->authUrl(), true);
                }
            } catch (ErrorException $e) {
                $login_messages[] = $e->getMessage();
            }

            return null;
        }

        public static function GetUserData($steamid64)
        {
            $url = 'https://api.steampowered.com/ISteamUser/GetPlayerSummaries/v0002/?'.http_build_query(array('key' => Config::Get('steamapikey'), 'steamids' => $steamid64));

            $request = new CURLRequester($url, 'GET', true);
            $data = $request->request(null, false, 5);

            if ($data) {
                if (!isset($data['response']['players'][0]['steamid'])) {
                    return false;
                } else {
                    $steamprofile = array();
                    foreach ($data['response']['players'][0] as $key => $val) {
                        if ('steamid' == $key) {
                            $key = 'steamid64';
                        }

                        $steamprofile[$key] = $val;
                    }

                    $steamprofile['personaname'] = htmlspecialchars($steamprofile['personaname']);

                    $steamprofile['steamid32'] = SteamIDFrom64($steamprofile['steamid64']);

                    return $steamprofile;
                }
            } else {
                return false;
            }
        }
    }
