<?php
    class Ticket extends DBTableClass
    {
        public function __construct($id, $data = null)
        {
            $this->Initialize('tickets', $id, 'id', $data);
        }

        public function RefreshData()
        {
            $db = MysqliDb::getInstance();

            $db->where("id", $this->data['id']);
            $result = $db->getOne("tickets");

            if ($db->count > 0) {
                $this->valid = true;
                $this->data = $result;
                $this->data['conversation'] = FromJson($this->data['conversation']);
            } else {
                $this->valid = false;
            }
        }

        public function GetValue($key)
        {
            return $this->data[$key];
        }

        public function SetValue($key, $value)
        {
            $db = MysqliDb::getInstance();

            $data = array($key => $value);
            $db->where("id", $this->data['id']);
            $this->data[$key] = $value;

            if ($db->update("tickets", $data)) {
                $this->RefreshData();
                return true;
            } else {
                return false;
            }
        }

        public static function Create($subject, $text, $category)
        {
            $db = MysqliDb::getInstance();
            global $auth_user;

            if(!in_array($category, Ticket::GetCategories(true))){
                $category = '';
            }

            $text = ValidateHTML($text, array(), true);

            $data = array(
                'steamid64' => $GLOBALS['auth_user']->GetValue('steamid64'),
                'subject' => htmlspecialchars($subject),
                'conversation' => ToJson(array(array('steamid64' => $GLOBALS['auth_user']->GetValue('steamid64'), 'text' => $text, 'date' => time()))),
                'updated' => $db->now(),
                'seen_user' => 1,
                'seen_admin' => 0,
                'steamid64_admin' => '',
                'category' => htmlspecialchars($category),
                'status' => 0
            );

            $id = $db->insert('tickets', $data);

            foreach (Permissions::GetSteamIDsWithPermission(false, 'tickets_admin') as $steamid64_admin) {
                Notifications::Send($steamid64_admin, 'notification_ticket_new', array('nick' => $GLOBALS['auth_user']->GetValue('nick'), 'id' => $id), 'index.php?t=tickets&id=' . $id, 'ticket');
            }

            return $id;
        }

        public function Reply($text)
        {
            $db = MysqliDb::getInstance();

            $text = ValidateHTML($text);

            $conversation = $this->GetValue('conversation');

            if ($this->GetValue('steamid64') != $GLOBALS['auth_user']->GetValue('steamid64')) {
                if(tempty($this->GetValue('steamid64_admin')) || Permissions::HasPermission('tickets_admin_takeover')){
                    $this->SetValue('steamid64_admin', $GLOBALS['auth_user']->GetValue('steamid64'));
                }
            }

            if ($this->GetValue('status') == 1) {
                $this->SetValue('status', 0);
                $conversation[] = array('steamid64' => $GLOBALS['auth_user']->GetValue('steamid64'), 'text' => Lang('ticket_reopened'), 'date' => time());
            }

            $conversation[] = array('steamid64' => $GLOBALS['auth_user']->GetValue('steamid64'), 'text' => $text, 'date' => time());

            $this->SetValue('conversation', json_encode($conversation));
            $this->SetValue('updated', $db->now());

            if ($this->GetValue('steamid64') == $GLOBALS['auth_user']->GetValue('steamid64')) {
                if (!tempty($this->GetValue('steamid64_admin'))) {
                    Notifications::Send($this->GetValue('steamid64_admin'), 'notification_ticket_answered', array('nick' => $GLOBALS['auth_user']->GetValue('nick'), 'id' => $this->GetValue('id')), 'index.php?t=tickets&id=' . $this->GetValue('id'), 'ticket');
                } else {
                    foreach (Permissions::GetSteamIDsWithPermission(false, 'tickets_admin') as $steamid64_admin) {
                        Notifications::Send($steamid64_admin, 'notification_ticket_answered', array('nick' => $GLOBALS['auth_user']->GetValue('nick'), 'id' => $this->GetValue('id')), 'index.php?t=tickets&id=' . $this->GetValue('id'), 'ticket');
                    }
                }

                $this->SetValue('seen_admin', 0);
            } else {
                Notifications::Send($this->GetValue('steamid64'), 'notification_ticket_answered', array('nick' => $GLOBALS['auth_user']->GetValue('nick'), 'id' => $this->GetValue('id')), 'index.php?t=tickets&id=' . $this->GetValue('id'), 'ticket');
                $this->SetValue('seen_user', 0);
            }
        }

        public function Close()
        {
            $db = MysqliDb::getInstance();

            if ($this->GetValue('status') == 0) {
                $conversation = $this->GetValue('conversation');

                $conversation[] = array('steamid64' => $GLOBALS['auth_user']->GetValue('steamid64'), 'text' => Lang('ticket_closed'), 'date' => time());

                $this->SetValue('conversation', json_encode($conversation));
                $this->SetValue('status', 1);
                $this->SetValue('updated', $db->now());

                Notifications::Send($this->GetValue('steamid64'), 'notification_ticket_closed', array('nick' => $GLOBALS['auth_user']->GetValue('nick'), 'id' => $this->GetValue('id')), 'index.php?t=tickets&id=' . $this->GetValue('id'), 'ticket');
            }
        }

        public static function GetUserTickets($limit, $page)
        {
            $db = MysqliDb::getInstance();

            $db->pageLimit = $limit;

            if (!Permissions::HasPermission('tickets_admin')) {
                $db->where('steamid64', $GLOBALS['auth_user']->GetValue('steamid64'));
            }

            $db->orderBy('updated', 'Desc');
            $tickets = $db->arraybuilder()->paginate("tickets", $page);

            $ret = array();

            foreach ($tickets as $ticketdata) {
                $ticketdata['conversation'] = FromJson($ticketdata['conversation']);
                $ret[] = new Ticket($ticketdata['id'], $ticketdata);
            }

            return $ret;
        }

        public static function GetCategories($val = false)
        {
            $db = MysqliDb::getInstance();

            if($val){
                return $db->getValue('tickets_categories', 'name', null);
            }

            return $db->get("tickets_categories");
        }

        public static function GetCategory($id)
        {
            $db = MysqliDb::getInstance();

            $db->where("id", $id);

            $category = $db->getOne("tickets_categories");

            if ($db->count) {
                return $category;
            } else {
                return array('id' => $id, 'name' => Lang('unknown'));
            }
        }

        public static function CreateCategory($name)
        {
            $db = MysqliDb::getInstance();

            $db->insert("tickets_categories", array('name' => $name));

            if ($db->count) {
                return true;
            } else {
                return false;
            }
        }

        public static function DeleteCategory($id)
        {
            $db = MysqliDb::getInstance();

            $db->where("id", $id);

            if ($db->delete("tickets_categories")) {
                return true;
            } else {
                return false;
            }
        }
    }
