<?php
    class TS3Worker
    {
        public $worker;
        public $valid;

        public function __construct()
        {
            $ip = Settings::Get('settings_teamspeak_ip');
            $port = Settings::Get('settings_teamspeak_port');
            $query_login = Settings::Get('settings_teamspeak_query_login');
            $query_password = Settings::Get('settings_teamspeak_query_password');
            $query_port = Settings::Get('settings_teamspeak_query_port');

            try {
                $querystring = 'serverquery://'.$query_login.':'.$query_password.'@'.$ip.':'.$query_port.'/?server_port='.$port.'&nickname='.(tempty(Settings::Get('settings_teamspeak_displayname')) ? 'GExtensionQuery-' : Settings::Get('settings_teamspeak_displayname')).substr(time(), -2).rand(0, 99);
                $this->worker = TeamSpeak3::factory($querystring);
                $this->valid = true;
            } catch (Exception $e) {
                //Log Error
                $this->valid = false;
                Debug($e->__toString());
            }
        }

        public function AssignServergroup($uid, $groupname)
        {
            try {
                $cldbids = $this->worker->clientFindDb($uid, TRUE);

                $group = $this->worker->serverGroupGetByName($groupname);

                $this->worker->serverGroupClientAdd($group->getId(), $cldbids[0]);

                try{
                    $client = $this->worker->clientGetByUid($uid);
                    $client->message('You have been added to the servergroup "[b]'.$groupname.'[/b]".');
                } catch (Exception $e){

                }
            } catch (Exception $e) {
                Debug($e->__toString());
            }
        }

        public function RemoveServergroup($uid, $groupname)
        {
            try {
                $cldbids = $this->worker->clientFindDb($uid, TRUE);

                $group = $this->worker->serverGroupGetByName($groupname);

                $this->worker->serverGroupClientDel($group->getId(), $cldbids[0]);

                try{
                    $client = $this->worker->clientGetByUid($uid);
                    // $client->remServerGroup($group->getId());
                    $client->message('You have been removed from the servergroup "[b]'.$groupname.'[/b]".');
                } catch (Exception $e){

                }
            } catch (Exception $e) {
                Debug($e->__toString());
            }
        }

        public function RemoveChannelgroup($uid, $groupname, $channelid)
        {
            try {
                $group = $this->worker->channelGroupGetByName($groupname);

                $client = $this->worker->clientGetByUid($uid);
                $client->setChannelGroup($channelid, $this->worker['virtualserver_default_channel_group']);
            } catch (Exception $e) {
                Debug($e->__toString());
            }
        }

        public function AssignChannelgroup($uid, $groupname, $channelid)
        {
            try {
                $group = $this->worker->channelGroupGetByName($groupname);

                $client = $this->worker->clientGetByUid($uid);
                $client->setChannelGroup($channelid, $group->getId());

                $client->message('You now have permissions in your channel.');
            } catch (Exception $e) {
                Debug($e->__toString());
            }
        }

        public function PrependDescription($id, $text)
        {
            try {
                $channel = $this->worker->channelGetById($id);

                $desc = $channel->getProperty('channel_description');

                if ($desc) {
                    $channel->modify(array('channel_description' => $text.$desc));

                    return true;
                } else {
                    return false;
                }
            } catch (Exception $e) {
                Debug($e->__toString());
            }
        }

        public function CreateChannel($name, $parent, $topic, $maxclients = -1)
        {
            try {
                $this->worker->channelCreate(array(
                    'cpid' => $parent,
                    'channel_name' => $name,
                    'channel_topic' => $topic,
                    'channel_codec' => TeamSpeak3::CODEC_OPUS_VOICE,
                    'channel_flag_maxclients_unlimited' => ($maxclients == -1),
                    'channel_flag_maxfamilyclients_unlimited' => true,
                    'channel_flag_permanent' => true,
                    'channel_maxclients' => $maxclients,
                ));

                $createdChannel = $this->worker->channelGetByName($name);

                return $createdChannel->getId();
            } catch (Exception $e) {
                Debug($e->__toString());
            }
        }

        public function DeleteChannel($id)
        {
            try {
                $channel = $this->worker->channelGetById($id);

                $channel->delete(true);

                return true;
            } catch (Exception $e) {
                Debug($e->__toString());
            }
        }

        public function Close()
        {
            //$this->worker->request('quit');
        }

        public static function GetClientCount()
        {
            try {
                $cache = new Cache('ts3_clientcount', 60, true);

                if($cache->Get() == null){
                    $worker = GetTS3Worker();

                    if($worker->valid) {
                        $clients = $worker->worker->virtualserver_clientsonline;
                        $clients = $clients - 1;

                        $maxclients = $worker->worker->virtualserver_maxclients;

                        $cache->Set(array('online' => $clients, 'max' => $maxclients));
                    }
                }

                return $cache->Get();
            } catch (Exception $e) {
                Debug($e->__toString());
            }

            return array('online' => 0, 'max' => 0);
        }

        public static function GetHostname()
        {
            try {
                $cache = new Cache('ts3_hostname', 60);

                if($cache->Get() == null){
                    $worker = GetTS3Worker();

                    if($worker->valid) {
                        $hostname = $worker->worker->virtualserver_name->toString();
                        $cache->Set($hostname);
                    }
                }

                return $cache->Get();
            } catch (Exception $e) {
                Debug($e->__toString());
            }

            return 'Error';
        }

        public static function GetViewer()
        {
            try{
                $cache = new Cache('ts3_viewer', 60);

                if($cache->Get() == null){
                    $worker = GetTS3Worker();

                    if($worker->valid) {
                        $viewer = $worker->worker->getViewer(new TeamSpeak3_Viewer_Html('assets/img/teamspeak_viewer/', null, 'data:image'));

                        $cache->Set($viewer);
                    }
                }

                return $cache->Get();
            } catch (Exception $e) {
                Debug($e->__toString());
            }

            return $e->__toString();
        }
    }
