<?php
    class Warnings
    {
        public static function GetByUser($steamid64)
        {
            $db = MysqliDb::getInstance();
            
            $db->where("steamid64", $steamid64);
            $db->where("status < 2");
            $db->orderBy("date", "Desc");
            
            return $db->get("warnings");
        }
        
        public static function GetActiveWarnings($steamid64)
        {
            $warnings = Warnings::GetByUser($steamid64);
            
            foreach ($warnings as $i => $warning) {
                if ($warning['status'] > 0 || (strtotime($warning['date']) + (Settings::Get('settings_warnings_decay') * 60)) < time()) {
                    unset($warnings[$i]);
                }
            }
            
            return $warnings;
        }
        
        public static function Warn($steamid64, $reason, $bundle)
        {
            global $auth_user;
            
            $db = MysqliDb::getInstance();
            
            $data = array(
                'steamid64' => $steamid64,
                'reason' => $reason,
                'serverbundle' => $bundle,
                'steamid64_admin' => $auth_user->GetValue('steamid64'),
                'status' => 0
            );
            
            $db->insert("warnings", $data);
            
            if ($db->count) {
                $active = Warnings::GetActiveWarnings($steamid64);
                
                if (sizeof($active) >= Settings::Get('settings_warnings_ban_threshold') && Settings::Get('settings_warnings_ban')) {
                    Bans::Add($steamid64, Settings::Get('settings_warnings_ban_length'), '[Warn] ' . $reason, $auth_user->GetValue('steamid64'), $bundle, 0);
                }
                
                return true;
            } else {
                return false;
            }
        }
        
        public static function GetAll($limit = false, $page = 1)
        {
            $db = MysqliDb::getInstance();

            $db->where("status < 2");
            $db->orderBy("date", "Desc");
            
            if ($limit) {
                $db->pageLimit = $limit;
                return $db->arraybuilder()->paginate("warnings", $page);
            } else {
                return $db->get("warnings");
            }
        }
        
        public static function SetInactive($id)
        {
            $db = MysqliDb::getInstance();
            
            $db->where("id", $id);
            
            $db->update("warnings", array('status' => 1));
        }
        
        public static function Delete($id)
        {
            $db = MysqliDb::getInstance();
            
            $db->where("id", $id);
            
            $db->update("warnings", array('status' => 2));
        }
    }
