<?php
function Install()
{
    $db = MysqliDb::getInstance();

    $version_installed = '0.0.0';

    $gex = new Product('gex');

    if (!$gex->valid) {
        Error('Product "gex" not found!');
    }


    if (version_compare($gex->GetValue('version_installed'), '2.7.0', '<')) {
        //0.1.0
        Permissions::Add('super');
        Permissions::Add('bans_add');
        Permissions::Add('bans_delete');
        Permissions::Add('bans_edit');
        Permissions::Add('bans_unban');
        Permissions::Add('chat_admin');
        Permissions::Add('console');
        Permissions::Add('console_command');
        Permissions::Add('donations_coupons');
        Permissions::Add('donations_package');
        Permissions::Add('donations_paysafecard');
        Permissions::Add('donations_revoke');
        Permissions::Add('settings_donations');
        Permissions::Add('settings_general');
        Permissions::Add('settings_groups');
        Permissions::Add('settings_groups_delete');
        Permissions::Add('settings_groups_editadd');
        Permissions::Add('settings_bans');
        Permissions::Add('settings_design');
        Permissions::Add('settings_teamspeak');
        Permissions::Add('settings_servers');
        Permissions::Add('settings_update');
        Permissions::Add('settings_warnings');
        Permissions::Add('tickets_admin');
        Permissions::Add('user_edit');
        Permissions::Add('user_packages');
        Permissions::Add('warnings_add');
        Permissions::Add('warnings_delete');

        //0.1.1
        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_faq'"))) {
            $db->rawQuery('
                CREATE TABLE IF NOT EXISTS `gex_faq` (
                  `id` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
                  `question` text NOT NULL,
                  `answer` text NOT NULL,
                  `date` timestamp  NOT NULL DEFAULT CURRENT_TIMESTAMP
                ) DEFAULT CHARSET=latin1;
            ');
        }

        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_ipn_paysafecard'"))) {
            $db->rawQuery('
                CREATE TABLE IF NOT EXISTS `gex_ipn_paysafecard` (
                  `id` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
                  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                  `request` text NOT NULL,
                  `price` float NOT NULL,
                  `price_should` float NOT NULL,
                  `price_custom` tinyint(1) NOT NULL,
                  `success` tinyint(1) NOT NULL
                ) DEFAULT CHARSET=latin1;
            ');
        }

        if (sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_paypal'"))) {
            $db->rawQuery('RENAME TABLE `gex_paypal` TO `gex_payments`;');
        }

        if (sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_ipn'"))) {
            $db->rawQuery('RENAME TABLE `gex_ipn` TO `gex_ipn_paypal`;');
        }

        if ('TEST' != Settings::Get('settings_donations_paysafecard_environment') && 'PRODUCTION' != Settings::Get('settings_donations_paysafecard_environment')) {
            Settings::Set('settings_donations_paysafecard_environment', 'TEST');
        }

        //0.1.2
        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_packages_bought', 'date')))) {
            $db->rawQuery("ALTER TABLE `gex_packages_bought` ADD `date` TIMESTAMP NOT NULL DEFAULT '1980-01-01 01:00:00' AFTER `status`;");
        }

        //0.1.3
        Permissions::Remove('warnings_settings');

        if ('' == Settings::Get('settings_design_banner_default')) {
            Settings::Set('settings_design_banner_default', 1);
        }

        if (file_exists('assets/img/gmodwebbanner.png')) {
            unlink('assets/img/gmodwebbanner.png');
        }

        //0.1.4
        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_groups', 'displayname')))) {
            $db->rawQuery('ALTER TABLE `gex_groups` ADD `displayname` text NOT NULL AFTER `groupname`;');
            $db->rawQuery("UPDATE gex_groups SET displayname = 'User' WHERE groupname = 'user';");
            $db->rawQuery("UPDATE gex_groups SET displayname = 'Superadmin' WHERE groupname = 'superadmin';");
        }

        if (!sizeof($db->rawQuery('SELECT steamid64 FROM gex_users WHERE steamid64 = 0;'))) {
            $data = array(
                'steamid64' => 0,
                'steamid32' => 'STEAM_ID_SERVER',
                'uniqueid' => '',
                'groups' => '',
                'ips' => '',
                'language' => '',
                'email' => '',
                'ts3uid' => '',
                'emailnotifications' => 0,
                'random' => random_string(25),
                'nick' => 'Console',
                'avatar_large' => 'https://i.imgur.com/v9dZs77.jpg',
                'avatar_medium' => 'https://i.imgur.com/zQXfxfs.jpg',
                'avatar_small' => 'https://i.imgur.com/7oFgPss.jpg',
            );

            $db->insert('users', $data);
        }

        //0.1.6
        if ('' == Settings::Get('settings_adverts_interval')) {
            Settings::Set('settings_adverts_interval', 1);
        }

        if ('' == Settings::Get('settings_adverts_tag')) {
            Settings::Set('settings_adverts_tag', 1);
        }

        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_adverts'"))) {
            $db->rawQuery('
                CREATE TABLE IF NOT EXISTS `gex_adverts` (
                  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                  `title` text NOT NULL,
                  `content` text NOT NULL,
                  `color` text NOT NULL,
                  `serverbundles` text NOT NULL,
                  `active` tinyint(1) NOT NULL,
                  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
                ) DEFAULT CHARSET=latin1;
            ');
        }

        //0.1.7
        $data = $db->rawQuery("SHOW TABLE STATUS LIKE 'gex_warnings';");
        if ($db->count > 0) {
            if (isset($data[0])) {
                if (isset($data[0]['Collation'])) {
                    if ($data[0]['Collation'] != 'latin1_swedish_ci') {
                        $db->rawQuery('ALTER TABLE gex_adverts CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_bans CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_bans_protests CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_chat CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_commands CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_console CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_coupons CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_debug CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_directnotifications CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_donations CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_emailqueue CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_faq CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_groups CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_ipn_paysafecard CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_ipn_paypal CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_log CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_notifications CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_packages CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_packages_bought CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_payments CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_paypal CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_paysafecard CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_permissions CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_products CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_rewards CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_serverbundles CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_servers CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_sessions CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_settings CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_statistics CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_tickets CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_users CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                        $db->rawQuery('ALTER TABLE gex_warnings CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;');
                    }
                }
            }
        }

        Permissions::Add('settings_adverts');

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_faq', 'category')))) {
            $db->rawQuery('ALTER TABLE `gex_faq` ADD `category` text NOT NULL AFTER `answer`;');
        }

        //0.1.8
        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_rewards', 'package_bought')))) {
            $db->rawQuery('ALTER TABLE `gex_rewards` ADD `package_bought` INT NOT NULL AFTER `donationid`;');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_faq', 'orderid')))) {
            $db->rawQuery('ALTER TABLE `gex_faq` ADD `orderid` INT  NOT NULL AFTER `id`;');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_adverts', 'orderid')))) {
            $db->rawQuery('ALTER TABLE `gex_adverts` ADD `orderid` INT  NOT NULL AFTER `id`;');
        }

        //0.1.9
        Permissions::Add('user_ips');

        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_actions'"))) {
            $db->rawQuery('
                CREATE TABLE `gex_actions` (
                  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                  `command` text NOT NULL,
                  `title` text NOT NULL
                ) DEFAULT CHARSET=latin1;
            ');
        }

        //1.0.2
        if (file_exists('login.php')) {
            unlink('login.php');
        }

        if (file_exists('request/main_rewards.php')) {
            unlink('request/main_rewards.php');
        }

        if (file_exists('request/main_emailqueue.php')) {
            unlink('request/main_emailqueue.php');
        }

        //01.0.3
        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_externalurls'"))) {
            $db->rawQuery('
                CREATE TABLE `gex_externalurls` (
                  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                  `title` text NOT NULL,
                  `icon` text NOT NULL,
                  `position` int NOT NULL,
                  `place` text NOT NULL,
                  `url` text NOT NULL
                ) DEFAULT CHARSET=latin1;
            ');
        }

        //1.0.5
        $db->where('steamid64', 0);
        $console = $db->getOne('users');

        if ($db->count) {
            if (!isset($console['email'])) {
                $db->where('steamid64', 0);
                $db->delete('users');
            }
        }

        if (!sizeof($db->rawQuery('SELECT steamid64 FROM gex_users WHERE steamid64 = 0;'))) {
            $data = array(
                'steamid64' => 0,
                'steamid32' => 'STEAM_ID_SERVER',
                'uniqueid' => '',
                'groups' => '',
                'ips' => '',
                'language' => '',
                'email' => '',
                'ts3uid' => '',
                'emailnotifications' => 0,
                'random' => random_string(25),
                'nick' => 'Console',
                'avatar_large' => 'https://i.imgur.com/v9dZs77.jpg',
                'avatar_medium' => 'https://i.imgur.com/zQXfxfs.jpg',
                'avatar_small' => 'https://i.imgur.com/7oFgPss.jpg',
            );

            $db->insert('users', $data);
        }

        //1.0.8
        if ('' == Settings::Get('settings_donations_donatedmessage')) {
            Settings::Set('settings_donations_donatedmessage', 1);
        }

        //1.0.10
        if (tempty(Settings::Get('settings_api_key'))) {
            Settings::Set('settings_api_key', date('d') . random_string(50));
        }

        //1.1.0
        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_ipn_g2apay'"))) {
            $db->rawQuery('
                CREATE TABLE IF NOT EXISTS `gex_ipn_g2apay` (
                  `id` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
                  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                  `request` text NOT NULL,
                  `amount` float NOT NULL,
                  `price_should` float NOT NULL,
                  `price_custom` tinyint(1) NOT NULL,
                  `success` tinyint(1) NOT NULL
                ) DEFAULT CHARSET=latin1;
            ');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_sessions', 'expires')))) {
            $db->rawQuery("ALTER TABLE `gex_sessions` ADD `expires` timestamp NOT NULL DEFAULT '1980-01-01 01:00:00' AFTER `useragent`;");
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_sessions', 'date')))) {
            $db->rawQuery('ALTER TABLE `gex_sessions` ADD `date` timestamp NOT NULL DEFAULt CURRENT_TIMESTAMP AFTER `expires`;');
        }

        Permissions::Add('bans_global');

        if (!sizeof($db->rawQuery("SHOW INDEXES FROM gex_users WHERE Column_name = 'steamid32' AND NOT Non_unique;"))) {
            $db->rawQuery('ALTER TABLE `gex_users` CHANGE `steamid32` `steamid32` VARCHAR(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL;');
            $db->rawQuery('ALTER TABLE `gex_users`ADD UNIQUE KEY `steamid32` (`steamid32`);');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_packages', 'category')))) {
            $db->rawQuery('ALTER TABLE `gex_packages`  ADD `category` TEXT NOT NULL AFTER `serverbundle`;');
        }

        if (file_exists('login.php')) {
            unlink('login.php');
        }

        if (file_exists('assets/php/classes/pagesmanager.class.php')) {
            unlink('assets/php/classes/pagesmanager.class.php');
        }

        if (file_exists('assets/php/classes/settingpagesmanager.class.php')) {
            unlink('assets/php/classes/settingpagesmanager.class.php');
        }

        if (file_exists('assets/img/font-awesome/home.ico')) {
            $files = scandir('assets/img/font-awesome/');
            foreach ($files as $file) {
                if (is_file($file)) {
                    unlink($file);
                }
            }
        }

        if (file_exists('pages/settings/')) {
            DeleteTarget('pages/settings/');
        }

        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_gateways'"))) {
            $db->rawQuery('
                CREATE TABLE `gex_gateways` (
                  `name` varchar(128) NOT NULL PRIMARY KEY,
                  `color` varchar(128) NOT NULL,
                  `color_hex` varchar(128) NOT NULL,
                  `icon` varchar(128) NOT NULL,
                  `text_display` varchar(128) NOT NULL,
                  `enabled` tinyint(1) NOT NULL
                ) DEFAULT CHARSET=latin1;
            ');

            $gateways = FromJson(Settings::Get('settings_donations_gateways'));

            if ($gateways) {
                $gateways[] = array(
                    'name' => 'g2apay',
                    'color' => 'primary',
                    'color_hex' => '#337AB7',
                    'icon' => 'star',
                    'text_display' => 'G2A Pay',
                    'enabled' => 0,
                );

                foreach ($gateways as $gateway) {
                    $db->insert('gateways', $gateway);
                }
            }
        }

        if ('' == Settings::Get('settings_donations_g2apay_sandbox')) {
            Settings::Set('settings_donations_g2apay_sandbox', 0);
        }

        if ('' == Settings::Get('settings_donations_footerlogos')) {
            Settings::Set('settings_donations_footerlogos', 0);
        }

        //1.2.0
        if (sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_packages', 'price_custom_min')))) {
            $db->rawQuery('ALTER TABLE `gex_packages` DROP COLUMN `price_custom_min`;');
        }

        if (file_exists('assets/php/classes/groupmanager.class.php')) {
            unlink('assets/php/classes/groupmanager.class.php');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_serverbundles', 'icon')))) {
            $db->rawQuery('ALTER TABLE `gex_serverbundles` ADD `icon` TEXT NOT NULL;');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM gex_serverbundles WHERE id = ?', array(0)))) {
            $db->insert('serverbundles', array(
                'id' => -1,
                'name' => 'Web',
                'servers' => '',
                'image' => '',
                'donations' => '0',
                'description' => '',
                'hexcolor' => '#337AB7',
                'icon' => 'fa-globe',
            ));

            $db->where('id', -1);
            $db->update('serverbundles', array('id' => 0));
        }

        $db->where('icon', '');
        $db->update('serverbundles', array('icon' => 'fa-server'));

        DeleteTarget('assets/php/jbbcode');

        if ('' == Settings::Get('settings_donations_shop')) {
            Settings::Set('settings_donations_shop', 0);
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_debug', 'trace')))) {
            $db->rawQuery('ALTER TABLE `gex_debug` ADD `trace` TEXT NOT NULL;');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM gex_gateways WHERE name = ?', array('payssion')))) {
            $db->insert('gateways', array(
                'name' => 'payssion',
                'color' => 'primary',
                'color_hex' => '#337AB7',
                'icon' => 'globe',
                'text_display' => 'Payssion',
                'enabled' => 0,
            ));
        }

        if (sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_gateways', 'color')))) {
            $db->rawQuery('ALTER TABLE `gex_gateways` DROP COLUMN `color`;');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_gateways', 'type')))) {
            $db->rawQuery('ALTER TABLE `gex_gateways` ADD `type` TEXT NOT NULL;');
        }

        if ('int' != strtolower($db->rawQuery('SELECT DATA_TYPE FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_packages', 'rebuyable'))[0]['DATA_TYPE'])) {
            $db->rawQuery("ALTER TABLE `gex_packages` MODIFY `rebuyable` INTEGER COMMENT '0: not;1: if expired; 2: also if active';");

            $db->where('rebuyable', 1);
            $db->update('packages', array('rebuyable' => 2));
        }

        if ('' == Settings::Get('settings_donations_statistics')) {
            Settings::Set('settings_donations_statistics', 1);
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_externalurls', 'newtab')))) {
            $db->rawQuery('ALTER TABLE `gex_externalurls` ADD `newtab` TINYINT NOT NULL DEFAULT 1;');
        }

        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_ipn_payssion'"))) {
            $db->rawQuery('
                CREATE TABLE IF NOT EXISTS `gex_ipn_payssion` (
                  `id` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
                  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                  `request` text NOT NULL,
                  `amount` float NOT NULL,
                  `price_should` float NOT NULL,
                  `price_custom` tinyint(1) NOT NULL,
                  `success` tinyint(1) NOT NULL
                ) DEFAULT CHARSET=latin1;
            ');
        }

        if ('' == Settings::Get('settings_general_shoutbox')) {
            Settings::Set('settings_general_shoutbox', 1);
        }

        Permissions::Add('donations_delete');
        Permissions::Add('donations_package_delete');

        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_tickets_categories'"))) {
            $db->rawQuery('
                CREATE TABLE `gex_tickets_categories` (
                  `id` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
                  `name` text NOT NULL
                ) DEFAULT CHARSET=latin1;
            ');

            Ticket::CreateCategory('Other');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_tickets', 'category')))) {
            $db->rawQuery('ALTER TABLE `gex_tickets` ADD `category` TEXT NOT NULL;');
        }

        if ('' == Settings::Get('settings_design_color')) {
            Settings::Set('settings_design_color', '#337AB7');
        }

        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_news'"))) {
            $db->rawQuery('
                CREATE TABLE `gex_news` (
                    `id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
                    `steamid64` TEXT NOT NULL,
                    `title` TEXT NOT NULL,
                    `content` TEXT NOT NULL,
                    `date` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
                    `active` BOOLEAN NOT NULL DEFAULT 1
                ) DEFAULT CHARSET=latin1;
            ');

            if ('' == Settings::Get('settings_general_motd')) {
                Settings::Set('settings_general_motd', '<div align="center"><h2>Welcome to GExtension<br></h2></div><br>');
            }

            DeleteTarget('pages/bans.php');
        }

        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_comments'"))) {
            $db->rawQuery('
                CREATE TABLE `gex_comments` (
                  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                  `foreign_id` int(11) NOT NULL,
                  `steamid64` text NOT NULL,
                  `content` text NOT NULL,
                  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                  `application` text NOT NULL
                ) DEFAULT CHARSET=latin1;
            ');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_servers', 'users_online')))) {
            $db->rawQuery('ALTER TABLE `gex_servers` ADD `users_online` text NOT NULL;');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_servers', 'map')))) {
            $db->rawQuery('ALTER TABLE `gex_servers` ADD `map` text NOT NULL;');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_servers', 'slots')))) {
            $db->rawQuery('ALTER TABLE `gex_servers` ADD `slots` INT NOT NULL;');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_servers', 'slots_max')))) {
            $db->rawQuery('ALTER TABLE `gex_servers` ADD `date_refreshed` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP;');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_serverbundles', 'discount')))) {
            $db->rawQuery('ALTER TABLE `gex_serverbundles` ADD `discount` INT NOT NULL DEFAULT 0');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_packages', 'subtitle')))) {
            $db->rawQuery('ALTER TABLE `gex_packages` ADD `subtitle` TEXT NOT NULL');

            $q5 = fopen(base64_decode('YXNzZXRzL2Nzcy9fc3R5bGVpbmZvLmNzcw=='), base64_decode('dw=='));
            fclose($q5);
        }

        if ('' == Settings::Get('settings_design_theme')) {
            Settings::Set('settings_design_theme', 'default.css');
        }

        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_noauthfiles'"))) {
            $db->rawQuery('
                CREATE TABLE `gex_noauthfiles` (
                  `name` varchar(128) NOT NULL,
                  `application` varchar(128) NOT NULL,
                  PRIMARY KEY (name, application)
                ) DEFAULT CHARSET=latin1;
            ');

            Permissions::AllowPagesForEveryone('news', 'privacy_policy', 'violations');
        }

        NoAuthFiles::Add('request', 'ipn_paypal');
        NoAuthFiles::Add('request', 'ipn_paysafecard');
        NoAuthFiles::Add('request', 'ipn_g2apay');
        NoAuthFiles::Add('request', 'ipn_payssion');
        NoAuthFiles::Add('request', 'user');
        NoAuthFiles::Add('request', 'main_paysafecard_success');
        NoAuthFiles::Add('request', 'main');
        NoAuthFiles::Add('request', 'donate');
        NoAuthFiles::Add('request', 'main_loginredirect');
        NoAuthFiles::Add('request', 'search');
        NoAuthFiles::Add('request', 'servers');
        NoAuthFiles::Add('request', 'main_chat');
        NoAuthFiles::Add('api', 'timezone');

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_gateways', 'icon')))) {
            $db->rawQuery('ALTER TABLE `gex_gateways` ADD `icon` TEXT NOT NULL;');

            $db->where('name', 'coupon');
            $db->update('gateways', array('icon' => 'ticket'));

            $db->where('name', 'g2apay');
            $db->update('gateways', array('icon' => 'star'));

            $db->where('name', 'paypal');
            $db->update('gateways', array('icon' => 'paypal'));

            $db->where('name', 'paysafecard');
            $db->update('gateways', array('icon' => 'credit-card-alt'));

            $db->where('name', 'payssion');
            $db->update('gateways', array('icon' => 'globe'));
        }

        Permissions::Add('settings_addons');
        Permissions::Add('settings_tickets');

        if ('' == Settings::Get('settings_general_startpage')) {
            Settings::Set('settings_general_startpage', 'news');
        }

        DeleteTarget('assets/php/ipnlistener.class.php');

        //1.3.0
        if ('' == Settings::Get('settings_donations_taxes_euvat')) {
            Settings::Set('settings_donations_taxes_euvat', 0);
        }

        if ('' == Settings::Get('settings_donations_taxes_unknown_block')) {
            Settings::Set('settings_donations_taxes_unknown_block', 0);
        }

        if ('' == Settings::Get('settings_donations_taxes_add')) {
            Settings::Set('settings_donations_taxes_add', 0);
        }

        if ('' == Settings::Get('settings_donations_invoices')) {
            Settings::Set('settings_donations_invoices', 1);
        }

        if ('' == Settings::Get('languages_lastupdate')) {
            DeleteTarget('language/de.php');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_donations', 'tax_amount')))) {
            $db->rawQuery('ALTER TABLE `gex_donations` ADD `invoice` BLOB NOT NULL');
            $db->rawQuery('ALTER TABLE `gex_donations` ADD `tax_amount` DECIMAL(10, 2) NOT NULL');
            $db->rawQuery('ALTER TABLE `gex_donations` ADD `amount_net` DECIMAL(10, 2) NOT NULL');
            $db->rawQuery('ALTER TABLE `gex_donations` ADD `price_custom` TINYINT(1) NOT NULL');
            $db->rawQuery('ALTER TABLE `gex_donations` ADD `tax_rate` INT NOT NULL');
            $db->rawQuery('ALTER TABLE `gex_donations` ADD `tax_note` TEXT NOT NULL');
            $db->rawQuery('ALTER TABLE `gex_donations` ADD `country` TEXT NOT NULL');
            $db->rawQuery('ALTER TABLE `gex_donations` MODIFY `amount` DECIMAL(10,2) NOT NULL');
            $db->rawQuery('ALTER TABLE `gex_coupons` MODIFY `amount` DECIMAL(10,2) NOT NULL');
            $db->rawQuery('ALTER TABLE `gex_coupons` MODIFY `amount_left` DECIMAL(10,2) NOT NULL');
            $db->rawQuery('ALTER TABLE `gex_packages` MODIFY `price` DECIMAL(10,2) NOT NULL');
            $db->rawQuery('UPDATE gex_donations SET amount_net = amount WHERE amount > 0 and amount_net = 0');
        }

        //1.3.1
        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_users', 'ipdetails')))) {
            $db->rawQuery('ALTER TABLE `gex_users` ADD `ipdetails` TEXT NOT NULL');
        }

        //1.3.6
        DeleteTarget('assets/img/white.png');
        DeleteTarget('themes/default.css.map');

        //1.3.7
        DeleteTarget('themes/umbra.css.php');

        //1.3.8
        DeleteTarget('assets/php/classes/gex__update.class.php');

        Permissions::Add('tickets_admin_takeover');
        Permissions::Add('tickets_delete');

        NoAuthFiles::Add('request', 'main_debug');

        DeleteRecursively('./', '.php_cs.cache');
        DeleteRecursively('./', '*.log');

        if (sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_gateways', 'type')))) {
            $db->rawQuery('ALTER TABLE `gex_gateways` DROP COLUMN `type`;');
        }

        //1.3.10
        if (!sizeof($db->rawQuery('SELECT * FROM gex_gateways WHERE name = ?', array('stripe')))) {
            $db->insert('gateways', array(
                'name' => 'stripe',
                'color_hex' => '#73F2DB',
                'icon' => 'cc-stripe',
                'text_display' => 'Stripe',
                'enabled' => 0,
            ));
        }

        //1.3.11
        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_groups', 'webgroup')))) {
            $db->rawQuery('ALTER TABLE `gex_groups` ADD `webgroup` TEXT NOT NULL');
        }

        //2.4.0
        if ('' == Settings::Get('settings_donations_details_not_public')) {
            Settings::Set('settings_donations_details_not_public', 0);

            Permissions::AllowPagesForEveryone('team');
        }

        NoAuthFiles::Add('request', 'main_testlogin');

        //2.4.1
        NoAuthFiles::Add('request', 'main_login');

        //2.4.4
        if (version_compare($gex->GetValue('version_installed'), '2.4.4', '<')) {
            Cleanup::CleanDebug();
        }

        //2.4.5
        if ('' != Settings::Get('settings_general_privacy_policy') && '' == Settings::Get('settings_privacy_policy')) {
            Settings::Set('settings_privacy_policy', Settings::Get('settings_general_privacy_policy'));
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_users', 'accepted')))) {
            $db->rawQuery("ALTER TABLE `gex_users` MODIFY `date_lastonline_web` timestamp NOT NULL DEFAULT '1980-01-01 01:00:00'");
            $db->rawQuery("ALTER TABLE `gex_users` MODIFY `date_lastonline_gmod` timestamp NOT NULL DEFAULT '1980-01-01 01:00:00'");
            $db->rawQuery('ALTER TABLE `gex_users` ADD `accepted` TINYINT(1) NOT NULL');
        }

        if ('' == Settings::Get('settings_privacy_collect_ips')) {
            Settings::Set('settings_privacy_collect_ips', 1);
        }

        //2.4.6
        $db->where('name', 'paysafecard');
        $db->update('gateways', array('icon' => 'lock'));

        //2.4.8
        Permissions::AllowPagesForEveryone('cancellation_terms');
        Permissions::AllowPagesForEveryone('shop');

        if ('' == Settings::Get('settings_donations_email_enabled')) {
            Settings::Set('settings_donations_email_enabled', 0);
        }

        if ('' == Settings::Get('settings_donations_email_required')) {
            Settings::Set('settings_donations_email_required', 0);
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_emailqueue', 'attachments')))) {
            $db->rawQuery('ALTER TABLE `gex_emailqueue` ADD `attachments` TEXT NOT NULL');
        }

        if ('' == Settings::Get('settings_donations_checkboxes')) {
            Settings::Set('settings_donations_checkboxes', 'I agree to the <a href=index.php?t=tos target=_blank>Terms of Service</a>');
        }

        if (sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_packages_bought', 'date')))) {
            $db->rawQuery("ALTER TABLE `gex_bans` MODIFY `date_unbanned` timestamp NOT NULL DEFAULT '1980-01-01 01:00:00'");
            $db->rawQuery("ALTER TABLE `gex_console` MODIFY `updated` timestamp NOT NULL DEFAULT '1980-01-01 01:00:00'");
            $db->rawQuery("ALTER TABLE `gex_products` MODIFY `checked` timestamp NOT NULL DEFAULT '1980-01-01 01:00:00'");
            $db->rawQuery("ALTER TABLE `gex_rewards` MODIFY `expires` timestamp NOT NULL DEFAULT '1980-01-01 01:00:00'");
            $db->rawQuery("ALTER TABLE `gex_tickets` MODIFY `updated` timestamp NOT NULL DEFAULT '1980-01-01 01:00:00'");
            $db->rawQuery("ALTER TABLE `gex_packages_bought` MODIFY `expires` timestamp NOT NULL DEFAULT '1980-01-01 01:00:00', MODIFY `date` timestamp NOT NULL DEFAULT '1980-01-01 01:00:00'");
            $db->rawQuery('ALTER TABLE `gex_packages_bought` MODIFY `activated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP');
            $db->rawQuery('ALTER TABLE `gex_packages_bought` DROP COLUMN `date`');
        }

        if ('donate' == Settings::Get('settings_general_startpage')) {
            Settings::Set('settings_general_startpage', 'shop');
        }

        //2.4.9
        if ('' == Settings::Get('settings_design_snow')) {
            Settings::Set('settings_design_snow', 0);
        }

        //2.5.0
        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_users', 'discord_username')))) {
            $db->rawQuery('ALTER TABLE `gex_users` ADD `discord_username` TEXT NOT NULL');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_users', 'discord_user_id')))) {
            $db->rawQuery('ALTER TABLE `gex_users` ADD `discord_user_id` TEXT NOT NULL');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_groups', 'discord_role_ids')))) {
            $db->rawQuery('ALTER TABLE `gex_groups` ADD `discord_role_ids` TEXT NOT NULL');
        }

        DeleteTarget('assets/php/HTMLPurifier');
        DeleteTarget('assets/php/PHPMailer');
        DeleteTarget('assets/php/SourceQuery');
        DeleteTarget('assets/php/Teamspeak3Framework');
        DeleteTarget('request/discord_test.php');

        //2.5.2
        if (version_compare($gex->GetValue('version_installed'), '2.5.2', '<')) {
            Cleanup::CleanDebug();
        }

        //2.6.0
        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_packages', 'required')))) {
            $db->rawQuery('ALTER TABLE `gex_packages` ADD `required` TEXT NOT NULL');

            $db->update('packages', array('required' => '[]'));
        }

        //2.7.0
        if (sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_users', 'ipdetails')))) {
            $db->rawQuery('ALTER TABLE `gex_users` DROP COLUMN `ipdetails`');
        }

        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_users', 'country_code')))) {
            $db->rawQuery('ALTER TABLE `gex_users` ADD `country_code` VARCHAR(2)');
        }

        if (!sizeof($db->rawQuery("SHOW TABLES LIKE 'gex_cache'"))) {
            $db->rawQuery('create table `gex_cache`
                (
                    `identifier` varchar(128) not null,
                    `value` longtext null,
                    `timestamp` timestamp default now() not null,
                    constraint `gex_cache_pk`
                        primary key (`identifier`)
                ) DEFAULT CHARSET=latin1;
            ');
        }

        Cleanup::CleanDebug();

        Permissions::AllowPagesForEveryone('invoice');
    }

    if (version_compare($gex->GetValue('version_installed'), '2.7.1', '<')) {
        DeleteTarget('addons/ather/');
    }

    if (version_compare($gex->GetValue('version_installed'), '2.7.5', '<=')) {
        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_donations', 'package_name')))) {
            $db->rawQuery('ALTER TABLE `gex_donations` ADD `package_name` TEXT');
        }

        $path = './language/';

        if (file_exists($path)) {
            $scan = scandir($path);

            foreach ($scan as $key => $file) {
                if ('.php' == substr($file, -4) && 6 == strlen($file)) {
                    $lang = substr($file, 0, 2);

                    if(!file_exists($path . $lang . '.json')){
                        file_put_contents($path . $lang . '.json', '{}');
                    }

                    DeleteTarget($path . $file);
                }
            }
        }
    }

    if (version_compare($gex->GetValue('version_installed'), '2.7.7', '<')) {
        if (!sizeof($db->rawQuery('SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?', array(Config::Get('mysql_db'), 'gex_donations', 'api_notified')))) {
            $db->rawQuery('ALTER TABLE `gex_donations` ADD `api_notified` TINYINT NOT NULL DEFAULT 1;');
        }
    }

}
